/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.ProgressRequestBody;
import org.wso2.am.integration.clients.admin.ProgressResponseBody;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationInfoDTO;

public class ApplicationIndividualApi {
    private ApiClient apiClient;

    public ApplicationIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call exportApplicationsGetCall(String appName, String appOwner, Boolean withKeys, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/export/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (appName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("appName", appName));
        }
        if (appOwner != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("appOwner", appOwner));
        }
        if (withKeys != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("withKeys", withKeys));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/zip"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call exportApplicationsGetValidateBeforeCall(String appName, String appOwner, Boolean withKeys, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling exportApplicationsGet(Async)");
        }
        if (appOwner == null) {
            throw new ApiException("Missing the required parameter 'appOwner' when calling exportApplicationsGet(Async)");
        }
        Call call = this.exportApplicationsGetCall(appName, appOwner, withKeys, progressListener, progressRequestListener);
        return call;
    }

    public File exportApplicationsGet(String appName, String appOwner, Boolean withKeys) throws ApiException {
        ApiResponse<File> resp = this.exportApplicationsGetWithHttpInfo(appName, appOwner, withKeys);
        return resp.getData();
    }

    public ApiResponse<File> exportApplicationsGetWithHttpInfo(String appName, String appOwner, Boolean withKeys) throws ApiException {
        Call call = this.exportApplicationsGetValidateBeforeCall(appName, appOwner, withKeys, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call exportApplicationsGetAsync(String appName, String appOwner, Boolean withKeys, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.exportApplicationsGetValidateBeforeCall(appName, appOwner, withKeys, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call importApplicationsPostCall(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/import/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (preserveOwner != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("preserveOwner", preserveOwner));
        }
        if (skipSubscriptions != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skipSubscriptions", skipSubscriptions));
        }
        if (appOwner != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("appOwner", appOwner));
        }
        if (skipApplicationKeys != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skipApplicationKeys", skipApplicationKeys));
        }
        if (update != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("update", update));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call importApplicationsPostValidateBeforeCall(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling importApplicationsPost(Async)");
        }
        Call call = this.importApplicationsPostCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationInfoDTO importApplicationsPost(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update) throws ApiException {
        ApiResponse<ApplicationInfoDTO> resp = this.importApplicationsPostWithHttpInfo(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update);
        return resp.getData();
    }

    public ApiResponse<ApplicationInfoDTO> importApplicationsPostWithHttpInfo(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update) throws ApiException {
        Call call = this.importApplicationsPostValidateBeforeCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, null, null);
        Type localVarReturnType = new TypeToken<ApplicationInfoDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call importApplicationsPostAsync(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, final ApiCallback<ApplicationInfoDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importApplicationsPostValidateBeforeCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationInfoDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

