/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class BotDetectionDataDTO {
    @SerializedName(value="recordedTime")
    private Long recordedTime = null;
    @SerializedName(value="messageID")
    private String messageID = null;
    @SerializedName(value="apiMethod")
    private String apiMethod = null;
    @SerializedName(value="headerSet")
    private String headerSet = null;
    @SerializedName(value="messageBody")
    private String messageBody = null;
    @SerializedName(value="clientIp")
    private String clientIp = null;

    public BotDetectionDataDTO recordedTime(Long recordedTime) {
        this.recordedTime = recordedTime;
        return this;
    }

    @ApiModelProperty(example="1591734138413", value="The time of detection")
    public Long getRecordedTime() {
        return this.recordedTime;
    }

    public void setRecordedTime(Long recordedTime) {
        this.recordedTime = recordedTime;
    }

    public BotDetectionDataDTO messageID(String messageID) {
        this.messageID = messageID;
        return this;
    }

    @ApiModelProperty(example="urn:uuid:1ed6d2de-29df-4fed-a96a-46d2329dce65", value="The message ID")
    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public BotDetectionDataDTO apiMethod(String apiMethod) {
        this.apiMethod = apiMethod;
        return this;
    }

    @ApiModelProperty(example="GET", value="The api method")
    public String getApiMethod() {
        return this.apiMethod;
    }

    public void setApiMethod(String apiMethod) {
        this.apiMethod = apiMethod;
    }

    public BotDetectionDataDTO headerSet(String headerSet) {
        this.headerSet = headerSet;
        return this;
    }

    @ApiModelProperty(example="", value="The header set")
    public String getHeaderSet() {
        return this.headerSet;
    }

    public void setHeaderSet(String headerSet) {
        this.headerSet = headerSet;
    }

    public BotDetectionDataDTO messageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    @ApiModelProperty(example="<soapenv:Body xmlns:soapenv=\\\"http://www.w3.org/2003/05/soap-envelope\\\"/>", value="The content of the message body")
    public String getMessageBody() {
        return this.messageBody;
    }

    public void setMessageBody(String messageBody) {
        this.messageBody = messageBody;
    }

    public BotDetectionDataDTO clientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    @ApiModelProperty(example="127.0.0.1", value="The IP of the client")
    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BotDetectionDataDTO botDetectionData = (BotDetectionDataDTO)o;
        return Objects.equals(this.recordedTime, botDetectionData.recordedTime) && Objects.equals(this.messageID, botDetectionData.messageID) && Objects.equals(this.apiMethod, botDetectionData.apiMethod) && Objects.equals(this.headerSet, botDetectionData.headerSet) && Objects.equals(this.messageBody, botDetectionData.messageBody) && Objects.equals(this.clientIp, botDetectionData.clientIp);
    }

    public int hashCode() {
        return Objects.hash(this.recordedTime, this.messageID, this.apiMethod, this.headerSet, this.messageBody, this.clientIp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BotDetectionDataDTO {\n");
        sb.append("    recordedTime: ").append(this.toIndentedString(this.recordedTime)).append("\n");
        sb.append("    messageID: ").append(this.toIndentedString(this.messageID)).append("\n");
        sb.append("    apiMethod: ").append(this.toIndentedString(this.apiMethod)).append("\n");
        sb.append("    headerSet: ").append(this.toIndentedString(this.headerSet)).append("\n");
        sb.append("    messageBody: ").append(this.toIndentedString(this.messageBody)).append("\n");
        sb.append("    clientIp: ").append(this.toIndentedString(this.clientIp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

