/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;

public class ConditionalGroupDTO {
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="conditions")
    private List<ThrottleConditionDTO> conditions = new ArrayList<ThrottleConditionDTO>();
    @SerializedName(value="limit")
    private ThrottleLimitDTO limit = null;

    public ConditionalGroupDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the Conditional Group")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ConditionalGroupDTO conditions(List<ThrottleConditionDTO> conditions) {
        this.conditions = conditions;
        return this;
    }

    public ConditionalGroupDTO addConditionsItem(ThrottleConditionDTO conditionsItem) {
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(example="\"[\\n  {\\n    \\\"type\\\": \\\"HEADERCONDITION\\\",\\n    \\\"invertCondition\\\": false,\\n    \\\"headerCondition\\\":\\n    {\\n      \\\"headerName\\\": \\\"Host\\\",\\n      \\\"headerValue\\\": \\\"10.100.7.77\\\"\\n    }\\n\\t},\\n\\t{\\n    \\\"type\\\": \\\"IPCONDITION\\\",\\n    \\\"invertCondition\\\": false,\\n    \\\"ipCondition\\\":\\n    {\\n      \\\"ipConditionType\\\": \\\"IPSPECIFIC\\\",\\n      \\\"specificIP\\\": \\\"10.100.1.22\\\",\\n      \\\"startingIP\\\": null,\\n      \\\"endingIP\\\": null\\n    }\\n\\t},\\n\\t{\\n    \\\"type\\\": \\\"QUERYPARAMETERCONDITION\\\",\\n    \\\"invertCondition\\\": false,\\n    \\\"queryParameterCondition\\\":\\n    {\\n      \\\"parameterName\\\": \\\"name\\\",\\n      \\\"parameterValue\\\": \\\"admin\\\"\\n    }\\n\\t},\\n\\t{\\n    \\\"type\\\": \\\"JWTCLAIMSCONDITION\\\",\\n    \\\"invertCondition\\\": true,\\n    \\\"jwtClaimsCondition\\\":\\n    {\\n      \\\"claimUrl\\\": \\\"claimUrl0\\\",\\n      \\\"attribute\\\": \\\"claimAttr0\\\"\\n    }\\n  }\\n]\\n\"", required=true, value="Individual throttling conditions. They can be defined as either HeaderCondition, IPCondition, JWTClaimsCondition, QueryParameterCondition Please see schemas of each of those throttling condition in Definitions section. ")
    public List<ThrottleConditionDTO> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ThrottleConditionDTO> conditions) {
        this.conditions = conditions;
    }

    public ConditionalGroupDTO limit(ThrottleLimitDTO limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ThrottleLimitDTO getLimit() {
        return this.limit;
    }

    public void setLimit(ThrottleLimitDTO limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalGroupDTO conditionalGroup = (ConditionalGroupDTO)o;
        return Objects.equals(this.description, conditionalGroup.description) && Objects.equals(this.conditions, conditionalGroup.conditions) && Objects.equals(this.limit, conditionalGroup.limit);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.conditions, this.limit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConditionalGroupDTO {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

