/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class IPConditionDTO {
    @SerializedName(value="ipConditionType")
    private IpConditionTypeEnum ipConditionType = null;
    @SerializedName(value="specificIP")
    private String specificIP = null;
    @SerializedName(value="startingIP")
    private String startingIP = null;
    @SerializedName(value="endingIP")
    private String endingIP = null;

    public IPConditionDTO ipConditionType(IpConditionTypeEnum ipConditionType) {
        this.ipConditionType = ipConditionType;
        return this;
    }

    @ApiModelProperty(value="Type of the IP condition. Allowed values are \"IPRANGE\" and \"IPSPECIFIC\"")
    public IpConditionTypeEnum getIpConditionType() {
        return this.ipConditionType;
    }

    public void setIpConditionType(IpConditionTypeEnum ipConditionType) {
        this.ipConditionType = ipConditionType;
    }

    public IPConditionDTO specificIP(String specificIP) {
        this.specificIP = specificIP;
        return this;
    }

    @ApiModelProperty(required=true, value="Specific IP when \"IPSPECIFIC\" is used as the ipConditionType")
    public String getSpecificIP() {
        return this.specificIP;
    }

    public void setSpecificIP(String specificIP) {
        this.specificIP = specificIP;
    }

    public IPConditionDTO startingIP(String startingIP) {
        this.startingIP = startingIP;
        return this;
    }

    @ApiModelProperty(value="Staring IP when \"IPRANGE\" is used as the ipConditionType")
    public String getStartingIP() {
        return this.startingIP;
    }

    public void setStartingIP(String startingIP) {
        this.startingIP = startingIP;
    }

    public IPConditionDTO endingIP(String endingIP) {
        this.endingIP = endingIP;
        return this;
    }

    @ApiModelProperty(value="Ending IP when \"IPRANGE\" is used as the ipConditionType")
    public String getEndingIP() {
        return this.endingIP;
    }

    public void setEndingIP(String endingIP) {
        this.endingIP = endingIP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPConditionDTO ipCondition = (IPConditionDTO)o;
        return Objects.equals((Object)this.ipConditionType, (Object)ipCondition.ipConditionType) && Objects.equals(this.specificIP, ipCondition.specificIP) && Objects.equals(this.startingIP, ipCondition.startingIP) && Objects.equals(this.endingIP, ipCondition.endingIP);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ipConditionType, this.specificIP, this.startingIP, this.endingIP});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IPConditionDTO {\n");
        sb.append("    ipConditionType: ").append(this.toIndentedString((Object)this.ipConditionType)).append("\n");
        sb.append("    specificIP: ").append(this.toIndentedString(this.specificIP)).append("\n");
        sb.append("    startingIP: ").append(this.toIndentedString(this.startingIP)).append("\n");
        sb.append("    endingIP: ").append(this.toIndentedString(this.endingIP)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IpConditionTypeEnum {
        IPRANGE("IPRANGE"),
        IPSPECIFIC("IPSPECIFIC");

        private String value;

        private IpConditionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IpConditionTypeEnum fromValue(String text) {
            for (IpConditionTypeEnum b : IpConditionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<IpConditionTypeEnum> {
            public void write(JsonWriter jsonWriter, IpConditionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IpConditionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IpConditionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

