/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - **Admin Portal**. Please see [full OpenAPI Specification](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.7.206/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin.v1/src/main/resources/admin-api.yaml) of the API which is written using [OAS 3.0](http://swagger.io/) specification.  # Authentication Our REST APIs are protected using OAuth2 and access control is achieved through scopes. Before you start invoking the the API you need to obtain an access token with the required scopes. This guide will walk you through the steps that you will need to follow to obtain an access token. First you need to obtain the consumer key/secret key pair by calling the dynamic client registration (DCR) endpoint. You can add your preferred grant types in the payload. A sample payload is shown below. ```   {   \"callbackUrl\":\"www.google.lk\",   \"clientName\":\"rest_api_admin\",   \"owner\":\"admin\",   \"grantType\":\"client_credentials password refresh_token\",   \"saasApp\":true   } ``` Create a file (payload.json) with the above sample payload, and use the cURL shown bellow to invoke the DCR endpoint. Authorization header of this should contain the base64 encoded admin username and password. **Format of the request** ```   curl -X POST -H \"Authorization: Basic Base64(admin_username:admin_password)\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://<host>:<servlet_port>/client-registration/v0.17/register ``` **Sample request** ```   curl -X POST -H \"Authorization: Basic YWRtaW46YWRtaW4=\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://localhost:9443/client-registration/v0.17/register ``` Following is a sample response after invoking the above curl. ``` { \"clientId\": \"fOCi4vNJ59PpHucC2CAYfYuADdMa\", \"clientName\": \"rest_api_admin\", \"callBackURL\": \"www.google.lk\", \"clientSecret\": \"a4FwHlq0iCIKVs2MPIIDnepZnYMa\", \"isSaasApplication\": true, \"appOwner\": \"admin\", \"jsonString\": \"{\\\"grant_types\\\":\\\"client_credentials password refresh_token\\\",\\\"redirect_uris\\\":\\\"www.google.lk\\\",\\\"client_name\\\":\\\"rest_api_admin\\\"}\", \"jsonAppAttribute\": \"{}\", \"tokenType\": null } ``` Next you must use the above client id and secret to obtain the access token. We will be using the password grant type for this, you can use any grant type you desire. You also need to add the proper **scope** when getting the access token. All possible scopes for Admin REST API can be viewed in **OAuth2 Security** section of this document and scope for each resource is given in **authorizations** section of resource documentation. Following is the format of the request if you are using the password grant type. ``` curl -k -d \"grant_type=password&username=<admin_username>&password=<admin_passowrd>&scope=<scopes seperated by space>\" \\ -H \"Authorization: Basic base64(cliet_id:client_secret)\" \\ https://<host>:<gateway_port>/token ``` **Sample request** ``` curl https://localhost:8243/token -k \\ -H \"Authorization: Basic Zk9DaTR2Tko1OVBwSHVjQzJDQVlmWXVBRGRNYTphNEZ3SGxxMGlDSUtWczJNUElJRG5lcFpuWU1h\" \\ -d \"grant_type=password&username=admin&password=admin&scope=apim:admin apim:tier_view\" ``` Shown below is a sample response to the above request. ``` { \"access_token\": \"e79bda48-3406-3178-acce-f6e4dbdcbb12\", \"refresh_token\": \"a757795d-e69f-38b8-bd85-9aded677a97c\", \"scope\": \"apim:admin apim:tier_view\", \"token_type\": \"Bearer\", \"expires_in\": 3600 } ``` Now you have a valid access token, which you can use to invoke an API. Navigate through the API descriptions to find the required API, obtain an access token as described above and invoke the API with the authentication header. If you use a different authentication mechanism, this process may change.  # Try out in Postman If you want to try-out the embedded postman collection with \"Run in Postman\" option, please follow the guidelines listed below. * All of the OAuth2 secured endpoints have been configured with an Authorization Bearer header with a parameterized access token. Before invoking any REST API resource make sure you run the `Register DCR Application` and `Generate Access Token` requests to fetch an access token with all required scopes. * Make sure you have an API Manager instance up and running. * Update the `basepath` parameter to match the hostname and port of the APIM instance.  [![Run in Postman](https://run.pstmn.io/button.svg)](https://app.getpostman.com/run-collection/f5ac2ca9fb22afef6ed6) 
 *
 * The version of the OpenAPI document: v2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api;

import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.ProgressRequestBody;
import org.wso2.am.integration.clients.admin.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.wso2.am.integration.clients.admin.api.dto.ErrorDTO;
import java.io.File;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiProductIndividualApi {
    private ApiClient localVarApiClient;

    public ApiProductIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiProductIndividualApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for exportApiProductGet
     * @param name API Product Name  (required)
     * @param version Version of the API Product  (required)
     * @param providerName Provider name of the API Product  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Product Status on export  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Export Successful.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call exportApiProductGetCall(String name, String version, String providerName, String format, Boolean preserveStatus, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/export/api-product";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (providerName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("providerName", providerName));
        }

        if (format != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("format", format));
        }

        if (preserveStatus != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("preserveStatus", preserveStatus));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/zip", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call exportApiProductGetValidateBeforeCall(String name, String version, String providerName, String format, Boolean preserveStatus, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling exportApiProductGet(Async)");
        }
        
        // verify the required parameter 'version' is set
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling exportApiProductGet(Async)");
        }
        

        okhttp3.Call localVarCall = exportApiProductGetCall(name, version, providerName, format, preserveStatus, _callback);
        return localVarCall;

    }

    /**
     * Export an API Product
     * This operation can be used to export the details of a particular API Product as a zip file. 
     * @param name API Product Name  (required)
     * @param version Version of the API Product  (required)
     * @param providerName Provider name of the API Product  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Product Status on export  (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Export Successful.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public File exportApiProductGet(String name, String version, String providerName, String format, Boolean preserveStatus) throws ApiException {
        ApiResponse<File> localVarResp = exportApiProductGetWithHttpInfo(name, version, providerName, format, preserveStatus);
        return localVarResp.getData();
    }

    /**
     * Export an API Product
     * This operation can be used to export the details of a particular API Product as a zip file. 
     * @param name API Product Name  (required)
     * @param version Version of the API Product  (required)
     * @param providerName Provider name of the API Product  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Product Status on export  (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Export Successful.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> exportApiProductGetWithHttpInfo(String name, String version, String providerName, String format, Boolean preserveStatus) throws ApiException {
        okhttp3.Call localVarCall = exportApiProductGetValidateBeforeCall(name, version, providerName, format, preserveStatus, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Export an API Product (asynchronously)
     * This operation can be used to export the details of a particular API Product as a zip file. 
     * @param name API Product Name  (required)
     * @param version Version of the API Product  (required)
     * @param providerName Provider name of the API Product  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Product Status on export  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Export Successful.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call exportApiProductGetAsync(String name, String version, String providerName, String format, Boolean preserveStatus, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = exportApiProductGetValidateBeforeCall(name, version, providerName, format, preserveStatus, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for importApiProductPost
     * @param file Zip archive consisting on exported API Product configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API Product. This is the user choice to keep or replace the API Product provider.  (optional)
     * @param importAPIs Whether to import the dependent APIs or not.  (optional)
     * @param overwriteAPIProduct Whether to update the API Product or not. This is used when updating already existing API Products.  (optional)
     * @param overwriteAPIs Whether to update the dependent APIs or not. This is used when updating already existing dependent APIs of an API Product.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Created. API Product Imported Successfully.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. The request must be conditional but no condition has been specified. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict. Specified resource already exists. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call importApiProductPostCall(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/import/api-product";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (preserveProvider != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("preserveProvider", preserveProvider));
        }

        if (importAPIs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("importAPIs", importAPIs));
        }

        if (overwriteAPIProduct != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("overwriteAPIProduct", overwriteAPIProduct));
        }

        if (overwriteAPIs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("overwriteAPIs", overwriteAPIs));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call importApiProductPostValidateBeforeCall(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling importApiProductPost(Async)");
        }
        

        okhttp3.Call localVarCall = importApiProductPostCall(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs, _callback);
        return localVarCall;

    }

    /**
     * Import an API Product
     * This operation can be used to import an API Product. 
     * @param file Zip archive consisting on exported API Product configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API Product. This is the user choice to keep or replace the API Product provider.  (optional)
     * @param importAPIs Whether to import the dependent APIs or not.  (optional)
     * @param overwriteAPIProduct Whether to update the API Product or not. This is used when updating already existing API Products.  (optional)
     * @param overwriteAPIs Whether to update the dependent APIs or not. This is used when updating already existing dependent APIs of an API Product.  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Created. API Product Imported Successfully.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. The request must be conditional but no condition has been specified. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict. Specified resource already exists. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public void importApiProductPost(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs) throws ApiException {
        importApiProductPostWithHttpInfo(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs);
    }

    /**
     * Import an API Product
     * This operation can be used to import an API Product. 
     * @param file Zip archive consisting on exported API Product configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API Product. This is the user choice to keep or replace the API Product provider.  (optional)
     * @param importAPIs Whether to import the dependent APIs or not.  (optional)
     * @param overwriteAPIProduct Whether to update the API Product or not. This is used when updating already existing API Products.  (optional)
     * @param overwriteAPIs Whether to update the dependent APIs or not. This is used when updating already existing dependent APIs of an API Product.  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Created. API Product Imported Successfully.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. The request must be conditional but no condition has been specified. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict. Specified resource already exists. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> importApiProductPostWithHttpInfo(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs) throws ApiException {
        okhttp3.Call localVarCall = importApiProductPostValidateBeforeCall(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Import an API Product (asynchronously)
     * This operation can be used to import an API Product. 
     * @param file Zip archive consisting on exported API Product configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API Product. This is the user choice to keep or replace the API Product provider.  (optional)
     * @param importAPIs Whether to import the dependent APIs or not.  (optional)
     * @param overwriteAPIProduct Whether to update the API Product or not. This is used when updating already existing API Products.  (optional)
     * @param overwriteAPIs Whether to update the dependent APIs or not. This is used when updating already existing dependent APIs of an API Product.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Created. API Product Imported Successfully.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. The request must be conditional but no condition has been specified. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict. Specified resource already exists. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call importApiProductPostAsync(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = importApiProductPostValidateBeforeCall(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
