/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - **Admin Portal**. Please see [full OpenAPI Specification](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.7.206/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin.v1/src/main/resources/admin-api.yaml) of the API which is written using [OAS 3.0](http://swagger.io/) specification.  # Authentication Our REST APIs are protected using OAuth2 and access control is achieved through scopes. Before you start invoking the the API you need to obtain an access token with the required scopes. This guide will walk you through the steps that you will need to follow to obtain an access token. First you need to obtain the consumer key/secret key pair by calling the dynamic client registration (DCR) endpoint. You can add your preferred grant types in the payload. A sample payload is shown below. ```   {   \"callbackUrl\":\"www.google.lk\",   \"clientName\":\"rest_api_admin\",   \"owner\":\"admin\",   \"grantType\":\"client_credentials password refresh_token\",   \"saasApp\":true   } ``` Create a file (payload.json) with the above sample payload, and use the cURL shown bellow to invoke the DCR endpoint. Authorization header of this should contain the base64 encoded admin username and password. **Format of the request** ```   curl -X POST -H \"Authorization: Basic Base64(admin_username:admin_password)\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://<host>:<servlet_port>/client-registration/v0.17/register ``` **Sample request** ```   curl -X POST -H \"Authorization: Basic YWRtaW46YWRtaW4=\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://localhost:9443/client-registration/v0.17/register ``` Following is a sample response after invoking the above curl. ``` { \"clientId\": \"fOCi4vNJ59PpHucC2CAYfYuADdMa\", \"clientName\": \"rest_api_admin\", \"callBackURL\": \"www.google.lk\", \"clientSecret\": \"a4FwHlq0iCIKVs2MPIIDnepZnYMa\", \"isSaasApplication\": true, \"appOwner\": \"admin\", \"jsonString\": \"{\\\"grant_types\\\":\\\"client_credentials password refresh_token\\\",\\\"redirect_uris\\\":\\\"www.google.lk\\\",\\\"client_name\\\":\\\"rest_api_admin\\\"}\", \"jsonAppAttribute\": \"{}\", \"tokenType\": null } ``` Next you must use the above client id and secret to obtain the access token. We will be using the password grant type for this, you can use any grant type you desire. You also need to add the proper **scope** when getting the access token. All possible scopes for Admin REST API can be viewed in **OAuth2 Security** section of this document and scope for each resource is given in **authorizations** section of resource documentation. Following is the format of the request if you are using the password grant type. ``` curl -k -d \"grant_type=password&username=<admin_username>&password=<admin_passowrd>&scope=<scopes seperated by space>\" \\ -H \"Authorization: Basic base64(cliet_id:client_secret)\" \\ https://<host>:<gateway_port>/token ``` **Sample request** ``` curl https://localhost:8243/token -k \\ -H \"Authorization: Basic Zk9DaTR2Tko1OVBwSHVjQzJDQVlmWXVBRGRNYTphNEZ3SGxxMGlDSUtWczJNUElJRG5lcFpuWU1h\" \\ -d \"grant_type=password&username=admin&password=admin&scope=apim:admin apim:tier_view\" ``` Shown below is a sample response to the above request. ``` { \"access_token\": \"e79bda48-3406-3178-acce-f6e4dbdcbb12\", \"refresh_token\": \"a757795d-e69f-38b8-bd85-9aded677a97c\", \"scope\": \"apim:admin apim:tier_view\", \"token_type\": \"Bearer\", \"expires_in\": 3600 } ``` Now you have a valid access token, which you can use to invoke an API. Navigate through the API descriptions to find the required API, obtain an access token as described above and invoke the API with the authentication header. If you use a different authentication mechanism, this process may change.  # Try out in Postman If you want to try-out the embedded postman collection with \"Run in Postman\" option, please follow the guidelines listed below. * All of the OAuth2 secured endpoints have been configured with an Authorization Bearer header with a parameterized access token. Before invoking any REST API resource make sure you run the `Register DCR Application` and `Generate Access Token` requests to fetch an access token with all required scopes. * Make sure you have an API Manager instance up and running. * Update the `basepath` parameter to match the hostname and port of the APIM instance.  [![Run in Postman](https://run.pstmn.io/button.svg)](https://app.getpostman.com/run-collection/f5ac2ca9fb22afef6ed6) 
 *
 * The version of the OpenAPI document: v2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonCreator;
/**
* Blocking Conditions
*/
    @ApiModel(description = "Blocking Conditions")

public class BlockingConditionDTO {
        public static final String SERIALIZED_NAME_CONDITION_ID = "conditionId";
        @SerializedName(SERIALIZED_NAME_CONDITION_ID)
            private String conditionId;

            /**
* Type of the blocking condition
*/
    @JsonAdapter(ConditionTypeEnum.Adapter.class)
public enum ConditionTypeEnum {
        API("API"),
        
        APPLICATION("APPLICATION"),
        
        IP("IP"),
        
        IPRANGE("IPRANGE"),
        
        USER("USER");

private String value;

ConditionTypeEnum(String value) {
this.value = value;
}

public String getValue() {
return value;
}

@Override
public String toString() {
return String.valueOf(value);
}

public static ConditionTypeEnum fromValue(String value) {
    for (ConditionTypeEnum b : ConditionTypeEnum.values()) {
    if (b.name().equals(value)) {
        return b;
    }
}
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
}

    public static class Adapter extends TypeAdapter<ConditionTypeEnum> {
    @Override
    public void write(final JsonWriter jsonWriter, final ConditionTypeEnum enumeration) throws IOException {
    jsonWriter.value(enumeration.getValue());
    }

    @Override
    public ConditionTypeEnum read(final JsonReader jsonReader) throws IOException {
    String value =  jsonReader.nextString();
    return ConditionTypeEnum.fromValue(value);
    }
    }
}

        public static final String SERIALIZED_NAME_CONDITION_TYPE = "conditionType";
        @SerializedName(SERIALIZED_NAME_CONDITION_TYPE)
            private ConditionTypeEnum conditionType;

        public static final String SERIALIZED_NAME_CONDITION_VALUE = "conditionValue";
        @SerializedName(SERIALIZED_NAME_CONDITION_VALUE)
            private Object conditionValue;

        public static final String SERIALIZED_NAME_CONDITION_STATUS = "conditionStatus";
        @SerializedName(SERIALIZED_NAME_CONDITION_STATUS)
            private Boolean conditionStatus;


        public BlockingConditionDTO conditionId(String conditionId) {
        
        this.conditionId = conditionId;
        return this;
        }

    /**
        * Id of the blocking condition
    * @return conditionId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "b513eb68-69e8-4c32-92cf-852c101363cf", value = "Id of the blocking condition")
    
    public String getConditionId() {
        return conditionId;
    }


    public void setConditionId(String conditionId) {
        this.conditionId = conditionId;
    }


        public BlockingConditionDTO conditionType(ConditionTypeEnum conditionType) {
        
        this.conditionType = conditionType;
        return this;
        }

    /**
        * Type of the blocking condition
    * @return conditionType
    **/
      @ApiModelProperty(example = "IP", required = true, value = "Type of the blocking condition")
    
    public ConditionTypeEnum getConditionType() {
        return conditionType;
    }


    public void setConditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
    }


        public BlockingConditionDTO conditionValue(Object conditionValue) {
        
        this.conditionValue = conditionValue;
        return this;
        }

    /**
        * Value of the blocking condition
    * @return conditionValue
    **/
      @ApiModelProperty(example = "{\"fixedIp\":\"192.168.1.1\",\"invert\":false}", required = true, value = "Value of the blocking condition")
    
    public Object getConditionValue() {
        return conditionValue;
    }


    public void setConditionValue(Object conditionValue) {
        this.conditionValue = conditionValue;
    }


        public BlockingConditionDTO conditionStatus(Boolean conditionStatus) {
        
        this.conditionStatus = conditionStatus;
        return this;
        }

    /**
        * Status of the blocking condition
    * @return conditionStatus
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "true", value = "Status of the blocking condition")
    
    public Boolean isConditionStatus() {
        return conditionStatus;
    }


    public void setConditionStatus(Boolean conditionStatus) {
        this.conditionStatus = conditionStatus;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
        return true;
        }
        if (o == null || getClass() != o.getClass()) {
        return false;
        }
            BlockingConditionDTO blockingCondition = (BlockingConditionDTO) o;
            return Objects.equals(this.conditionId, blockingCondition.conditionId) &&
            Objects.equals(this.conditionType, blockingCondition.conditionType) &&
            Objects.equals(this.conditionValue, blockingCondition.conditionValue) &&
            Objects.equals(this.conditionStatus, blockingCondition.conditionStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(conditionId, conditionType, conditionValue, conditionStatus);
    }


@Override
public String toString() {
StringBuilder sb = new StringBuilder();
sb.append("class BlockingConditionDTO {\n");
    sb.append("    conditionId: ").append(toIndentedString(conditionId)).append("\n");
    sb.append("    conditionType: ").append(toIndentedString(conditionType)).append("\n");
    sb.append("    conditionValue: ").append(toIndentedString(conditionValue)).append("\n");
    sb.append("    conditionStatus: ").append(toIndentedString(conditionStatus)).append("\n");
sb.append("}");
return sb.toString();
}

/**
* Convert the given object to string with each line indented by 4 spaces
* (except the first line).
*/
private String toIndentedString(Object o) {
if (o == null) {
return "null";
}
return o.toString().replace("\n", "\n    ");
}

}

