/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationInfoDTO;

public class ApplicationIndividualApi {
    private ApiClient localVarApiClient;

    public ApplicationIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationIndividualApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call exportApplicationsGetCall(String appName, String appOwner, Boolean withKeys, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/export/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (appName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("appName", appName));
        }
        if (appOwner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("appOwner", appOwner));
        }
        if (withKeys != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withKeys", withKeys));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/zip"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call exportApplicationsGetValidateBeforeCall(String appName, String appOwner, Boolean withKeys, ApiCallback _callback) throws ApiException {
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling exportApplicationsGet(Async)");
        }
        if (appOwner == null) {
            throw new ApiException("Missing the required parameter 'appOwner' when calling exportApplicationsGet(Async)");
        }
        Call localVarCall = this.exportApplicationsGetCall(appName, appOwner, withKeys, _callback);
        return localVarCall;
    }

    public File exportApplicationsGet(String appName, String appOwner, Boolean withKeys) throws ApiException {
        ApiResponse<File> localVarResp = this.exportApplicationsGetWithHttpInfo(appName, appOwner, withKeys);
        return localVarResp.getData();
    }

    public ApiResponse<File> exportApplicationsGetWithHttpInfo(String appName, String appOwner, Boolean withKeys) throws ApiException {
        Call localVarCall = this.exportApplicationsGetValidateBeforeCall(appName, appOwner, withKeys, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call exportApplicationsGetAsync(String appName, String appOwner, Boolean withKeys, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.exportApplicationsGetValidateBeforeCall(appName, appOwner, withKeys, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call importApplicationsPostCall(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/import/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (preserveOwner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("preserveOwner", preserveOwner));
        }
        if (skipSubscriptions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipSubscriptions", skipSubscriptions));
        }
        if (appOwner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("appOwner", appOwner));
        }
        if (skipApplicationKeys != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipApplicationKeys", skipApplicationKeys));
        }
        if (update != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("update", update));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importApplicationsPostValidateBeforeCall(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, ApiCallback _callback) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling importApplicationsPost(Async)");
        }
        Call localVarCall = this.importApplicationsPostCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, _callback);
        return localVarCall;
    }

    public ApplicationInfoDTO importApplicationsPost(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update) throws ApiException {
        ApiResponse<ApplicationInfoDTO> localVarResp = this.importApplicationsPostWithHttpInfo(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationInfoDTO> importApplicationsPostWithHttpInfo(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update) throws ApiException {
        Call localVarCall = this.importApplicationsPostValidateBeforeCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, null);
        Type localVarReturnType = new TypeToken<ApplicationInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call importApplicationsPostAsync(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, ApiCallback<ApplicationInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.importApplicationsPostValidateBeforeCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, _callback);
        Type localVarReturnType = new TypeToken<ApplicationInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

