/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class WorkflowDTO {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;

    public WorkflowDTO status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="APPROVED", required=true, value="This attribute declares whether this workflow task is approved or rejected. ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public WorkflowDTO attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{}", value="Custom attributes to complete the workflow task ")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public WorkflowDTO description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Approve workflow request.", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDTO workflow = (WorkflowDTO)o;
        return Objects.equals((Object)this.status, (Object)workflow.status) && Objects.equals(this.attributes, workflow.attributes) && Objects.equals(this.description, workflow.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.attributes, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowDTO {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        APPROVED("APPROVED"),
        REJECTED("REJECTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

