/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class KeyManagerInfoDTO {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "tokenType";
    @SerializedName(value="tokenType")
    private TokenTypeEnum tokenType = TokenTypeEnum.DIRECT;

    public KeyManagerInfoDTO id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public KeyManagerInfoDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="WSO2 IS", required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KeyManagerInfoDTO type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="IS", required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public KeyManagerInfoDTO description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is a key manager for Developers", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public KeyManagerInfoDTO enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public KeyManagerInfoDTO tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="EXCHANGED", value="The type of the tokens to be used (exchanged or without exchanged). Accepted values are EXCHANGED and DIRECT.")
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyManagerInfoDTO keyManagerInfo = (KeyManagerInfoDTO)o;
        return Objects.equals(this.id, keyManagerInfo.id) && Objects.equals(this.name, keyManagerInfo.name) && Objects.equals(this.type, keyManagerInfo.type) && Objects.equals(this.description, keyManagerInfo.description) && Objects.equals(this.enabled, keyManagerInfo.enabled) && Objects.equals((Object)this.tokenType, (Object)keyManagerInfo.tokenType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.description, this.enabled, this.tokenType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyManagerInfoDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TokenTypeEnum {
        EXCHANGED("EXCHANGED"),
        DIRECT("DIRECT"),
        BOTH("BOTH");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TokenTypeEnum> {
            public void write(JsonWriter jsonWriter, TokenTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TokenTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TokenTypeEnum.fromValue(value);
            }
        }
    }
}

