/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - **Admin Portal**. Please see [full OpenAPI Specification](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.7.206/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin.v1/src/main/resources/admin-api.yaml) of the API which is written using [OAS 3.0](http://swagger.io/) specification.  # Authentication Our REST APIs are protected using OAuth2 and access control is achieved through scopes. Before you start invoking the the API you need to obtain an access token with the required scopes. This guide will walk you through the steps that you will need to follow to obtain an access token. First you need to obtain the consumer key/secret key pair by calling the dynamic client registration (DCR) endpoint. You can add your preferred grant types in the payload. A sample payload is shown below. ```   {   \"callbackUrl\":\"www.google.lk\",   \"clientName\":\"rest_api_admin\",   \"owner\":\"admin\",   \"grantType\":\"client_credentials password refresh_token\",   \"saasApp\":true   } ``` Create a file (payload.json) with the above sample payload, and use the cURL shown bellow to invoke the DCR endpoint. Authorization header of this should contain the base64 encoded admin username and password. **Format of the request** ```   curl -X POST -H \"Authorization: Basic Base64(admin_username:admin_password)\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://<host>:<servlet_port>/client-registration/v0.17/register ``` **Sample request** ```   curl -X POST -H \"Authorization: Basic YWRtaW46YWRtaW4=\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://localhost:9443/client-registration/v0.17/register ``` Following is a sample response after invoking the above curl. ``` { \"clientId\": \"fOCi4vNJ59PpHucC2CAYfYuADdMa\", \"clientName\": \"rest_api_admin\", \"callBackURL\": \"www.google.lk\", \"clientSecret\": \"a4FwHlq0iCIKVs2MPIIDnepZnYMa\", \"isSaasApplication\": true, \"appOwner\": \"admin\", \"jsonString\": \"{\\\"grant_types\\\":\\\"client_credentials password refresh_token\\\",\\\"redirect_uris\\\":\\\"www.google.lk\\\",\\\"client_name\\\":\\\"rest_api_admin\\\"}\", \"jsonAppAttribute\": \"{}\", \"tokenType\": null } ``` Next you must use the above client id and secret to obtain the access token. We will be using the password grant type for this, you can use any grant type you desire. You also need to add the proper **scope** when getting the access token. All possible scopes for Admin REST API can be viewed in **OAuth2 Security** section of this document and scope for each resource is given in **authorizations** section of resource documentation. Following is the format of the request if you are using the password grant type. ``` curl -k -d \"grant_type=password&username=<admin_username>&password=<admin_passowrd>&scope=<scopes seperated by space>\" \\ -H \"Authorization: Basic base64(cliet_id:client_secret)\" \\ https://<host>:<gateway_port>/token ``` **Sample request** ``` curl https://localhost:8243/token -k \\ -H \"Authorization: Basic Zk9DaTR2Tko1OVBwSHVjQzJDQVlmWXVBRGRNYTphNEZ3SGxxMGlDSUtWczJNUElJRG5lcFpuWU1h\" \\ -d \"grant_type=password&username=admin&password=admin&scope=apim:admin apim:tier_view\" ``` Shown below is a sample response to the above request. ``` { \"access_token\": \"e79bda48-3406-3178-acce-f6e4dbdcbb12\", \"refresh_token\": \"a757795d-e69f-38b8-bd85-9aded677a97c\", \"scope\": \"apim:admin apim:tier_view\", \"token_type\": \"Bearer\", \"expires_in\": 3600 } ``` Now you have a valid access token, which you can use to invoke an API. Navigate through the API descriptions to find the required API, obtain an access token as described above and invoke the API with the authentication header. If you use a different authentication mechanism, this process may change.  # Try out in Postman If you want to try-out the embedded postman collection with \"Run in Postman\" option, please follow the guidelines listed below. * All of the OAuth2 secured endpoints have been configured with an Authorization Bearer header with a parameterized access token. Before invoking any REST API resource make sure you run the `Register DCR Application` and `Generate Access Token` requests to fetch an access token with all required scopes. * Make sure you have an API Manager instance up and running. * Update the `basepath` parameter to match the hostname and port of the APIM instance.  [![Run in Postman](https://run.pstmn.io/button.svg)](https://app.getpostman.com/run-collection/f5ac2ca9fb22afef6ed6) 
 *
 * The version of the OpenAPI document: v4
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.wso2.am.integration.clients.admin.api.dto.ClaimMappingEntryDTO;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerCertificatesDTO;
import org.wso2.am.integration.clients.admin.api.dto.TokenValidationDTO;
import com.fasterxml.jackson.annotation.JsonCreator;
/**
* KeyManagerDTO
*/

public class KeyManagerDTO {
        public static final String SERIALIZED_NAME_ID = "id";
        @SerializedName(SERIALIZED_NAME_ID)
            private String id;

        public static final String SERIALIZED_NAME_NAME = "name";
        @SerializedName(SERIALIZED_NAME_NAME)
            private String name;

        public static final String SERIALIZED_NAME_DISPLAY_NAME = "displayName";
        @SerializedName(SERIALIZED_NAME_DISPLAY_NAME)
            private String displayName;

        public static final String SERIALIZED_NAME_TYPE = "type";
        @SerializedName(SERIALIZED_NAME_TYPE)
            private String type;

        public static final String SERIALIZED_NAME_DESCRIPTION = "description";
        @SerializedName(SERIALIZED_NAME_DESCRIPTION)
            private String description;

        public static final String SERIALIZED_NAME_WELL_KNOWN_ENDPOINT = "wellKnownEndpoint";
        @SerializedName(SERIALIZED_NAME_WELL_KNOWN_ENDPOINT)
            private String wellKnownEndpoint;

        public static final String SERIALIZED_NAME_INTROSPECTION_ENDPOINT = "introspectionEndpoint";
        @SerializedName(SERIALIZED_NAME_INTROSPECTION_ENDPOINT)
            private String introspectionEndpoint;

        public static final String SERIALIZED_NAME_CLIENT_REGISTRATION_ENDPOINT = "clientRegistrationEndpoint";
        @SerializedName(SERIALIZED_NAME_CLIENT_REGISTRATION_ENDPOINT)
            private String clientRegistrationEndpoint;

        public static final String SERIALIZED_NAME_TOKEN_ENDPOINT = "tokenEndpoint";
        @SerializedName(SERIALIZED_NAME_TOKEN_ENDPOINT)
            private String tokenEndpoint;

        public static final String SERIALIZED_NAME_DISPLAY_TOKEN_ENDPOINT = "displayTokenEndpoint";
        @SerializedName(SERIALIZED_NAME_DISPLAY_TOKEN_ENDPOINT)
            private String displayTokenEndpoint;

        public static final String SERIALIZED_NAME_REVOKE_ENDPOINT = "revokeEndpoint";
        @SerializedName(SERIALIZED_NAME_REVOKE_ENDPOINT)
            private String revokeEndpoint;

        public static final String SERIALIZED_NAME_DISPLAY_REVOKE_ENDPOINT = "displayRevokeEndpoint";
        @SerializedName(SERIALIZED_NAME_DISPLAY_REVOKE_ENDPOINT)
            private String displayRevokeEndpoint;

        public static final String SERIALIZED_NAME_USER_INFO_ENDPOINT = "userInfoEndpoint";
        @SerializedName(SERIALIZED_NAME_USER_INFO_ENDPOINT)
            private String userInfoEndpoint;

        public static final String SERIALIZED_NAME_AUTHORIZE_ENDPOINT = "authorizeEndpoint";
        @SerializedName(SERIALIZED_NAME_AUTHORIZE_ENDPOINT)
            private String authorizeEndpoint;

        public static final String SERIALIZED_NAME_CERTIFICATES = "certificates";
        @SerializedName(SERIALIZED_NAME_CERTIFICATES)
            private KeyManagerCertificatesDTO certificates;

        public static final String SERIALIZED_NAME_ISSUER = "issuer";
        @SerializedName(SERIALIZED_NAME_ISSUER)
            private String issuer;

        public static final String SERIALIZED_NAME_ALIAS = "alias";
        @SerializedName(SERIALIZED_NAME_ALIAS)
            private String alias;

        public static final String SERIALIZED_NAME_SCOPE_MANAGEMENT_ENDPOINT = "scopeManagementEndpoint";
        @SerializedName(SERIALIZED_NAME_SCOPE_MANAGEMENT_ENDPOINT)
            private String scopeManagementEndpoint;

        public static final String SERIALIZED_NAME_AVAILABLE_GRANT_TYPES = "availableGrantTypes";
        @SerializedName(SERIALIZED_NAME_AVAILABLE_GRANT_TYPES)
            private List<String> availableGrantTypes = null;

        public static final String SERIALIZED_NAME_ENABLE_TOKEN_GENERATION = "enableTokenGeneration";
        @SerializedName(SERIALIZED_NAME_ENABLE_TOKEN_GENERATION)
            private Boolean enableTokenGeneration;

        public static final String SERIALIZED_NAME_ENABLE_TOKEN_ENCRYPTION = "enableTokenEncryption";
        @SerializedName(SERIALIZED_NAME_ENABLE_TOKEN_ENCRYPTION)
            private Boolean enableTokenEncryption = false;

        public static final String SERIALIZED_NAME_ENABLE_TOKEN_HASHING = "enableTokenHashing";
        @SerializedName(SERIALIZED_NAME_ENABLE_TOKEN_HASHING)
            private Boolean enableTokenHashing = false;

        public static final String SERIALIZED_NAME_ENABLE_MAP_O_AUTH_CONSUMER_APPS = "enableMapOAuthConsumerApps";
        @SerializedName(SERIALIZED_NAME_ENABLE_MAP_O_AUTH_CONSUMER_APPS)
            private Boolean enableMapOAuthConsumerApps = false;

        public static final String SERIALIZED_NAME_ENABLE_O_AUTH_APP_CREATION = "enableOAuthAppCreation";
        @SerializedName(SERIALIZED_NAME_ENABLE_O_AUTH_APP_CREATION)
            private Boolean enableOAuthAppCreation = false;

        public static final String SERIALIZED_NAME_ENABLE_SELF_VALIDATION_J_W_T = "enableSelfValidationJWT";
        @SerializedName(SERIALIZED_NAME_ENABLE_SELF_VALIDATION_J_W_T)
            private Boolean enableSelfValidationJWT = true;

        public static final String SERIALIZED_NAME_CLAIM_MAPPING = "claimMapping";
        @SerializedName(SERIALIZED_NAME_CLAIM_MAPPING)
            private List<ClaimMappingEntryDTO> claimMapping = null;

        public static final String SERIALIZED_NAME_CONSUMER_KEY_CLAIM = "consumerKeyClaim";
        @SerializedName(SERIALIZED_NAME_CONSUMER_KEY_CLAIM)
            private String consumerKeyClaim;

        public static final String SERIALIZED_NAME_SCOPES_CLAIM = "scopesClaim";
        @SerializedName(SERIALIZED_NAME_SCOPES_CLAIM)
            private String scopesClaim;

        public static final String SERIALIZED_NAME_TOKEN_VALIDATION = "tokenValidation";
        @SerializedName(SERIALIZED_NAME_TOKEN_VALIDATION)
            private List<TokenValidationDTO> tokenValidation = null;

        public static final String SERIALIZED_NAME_ENABLED = "enabled";
        @SerializedName(SERIALIZED_NAME_ENABLED)
            private Boolean enabled;

        public static final String SERIALIZED_NAME_ADDITIONAL_PROPERTIES = "additionalProperties";
        @SerializedName(SERIALIZED_NAME_ADDITIONAL_PROPERTIES)
            private Object additionalProperties;

            /**
* The type of the tokens to be used (exchanged or without exchanged). Accepted values are EXCHANGED and DIRECT.
*/
    @JsonAdapter(TokenTypeEnum.Adapter.class)
public enum TokenTypeEnum {
        EXCHANGED("EXCHANGED"),
        
        DIRECT("DIRECT"),
        
        BOTH("BOTH");

private String value;

TokenTypeEnum(String value) {
this.value = value;
}

public String getValue() {
return value;
}

@Override
public String toString() {
return String.valueOf(value);
}

public static TokenTypeEnum fromValue(String value) {
    for (TokenTypeEnum b : TokenTypeEnum.values()) {
    if (b.name().equals(value)) {
        return b;
    }
}
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
}

    public static class Adapter extends TypeAdapter<TokenTypeEnum> {
    @Override
    public void write(final JsonWriter jsonWriter, final TokenTypeEnum enumeration) throws IOException {
    jsonWriter.value(enumeration.getValue());
    }

    @Override
    public TokenTypeEnum read(final JsonReader jsonReader) throws IOException {
    String value =  jsonReader.nextString();
    return TokenTypeEnum.fromValue(value);
    }
    }
}

        public static final String SERIALIZED_NAME_TOKEN_TYPE = "tokenType";
        @SerializedName(SERIALIZED_NAME_TOKEN_TYPE)
            private TokenTypeEnum tokenType = TokenTypeEnum.DIRECT;


        public KeyManagerDTO id(String id) {
        
        this.id = id;
        return this;
        }

    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "01234567-0123-0123-0123-012345678901", value = "")
    
    public String getId() {
        return id;
    }


    public void setId(String id) {
        this.id = id;
    }


        public KeyManagerDTO name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
      @ApiModelProperty(example = "WSO2 Identity Server", required = true, value = "")
    
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }


        public KeyManagerDTO displayName(String displayName) {
        
        this.displayName = displayName;
        return this;
        }

    /**
        * display name of Key Manager to  show in UI 
    * @return displayName
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "WSO2 Identity Server", value = "display name of Key Manager to  show in UI ")
    
    public String getDisplayName() {
        return displayName;
    }


    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }


        public KeyManagerDTO type(String type) {
        
        this.type = type;
        return this;
        }

    /**
        * Get type
    * @return type
    **/
      @ApiModelProperty(example = "WSO2-IS", required = true, value = "")
    
    public String getType() {
        return type;
    }


    public void setType(String type) {
        this.type = type;
    }


        public KeyManagerDTO description(String description) {
        
        this.description = description;
        return this;
        }

    /**
        * Get description
    * @return description
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "This is a key manager for Developers", value = "")
    
    public String getDescription() {
        return description;
    }


    public void setDescription(String description) {
        this.description = description;
    }


        public KeyManagerDTO wellKnownEndpoint(String wellKnownEndpoint) {
        
        this.wellKnownEndpoint = wellKnownEndpoint;
        return this;
        }

    /**
        * Well-Known Endpoint of Identity Provider. 
    * @return wellKnownEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Well-Known Endpoint of Identity Provider. ")
    
    public String getWellKnownEndpoint() {
        return wellKnownEndpoint;
    }


    public void setWellKnownEndpoint(String wellKnownEndpoint) {
        this.wellKnownEndpoint = wellKnownEndpoint;
    }


        public KeyManagerDTO introspectionEndpoint(String introspectionEndpoint) {
        
        this.introspectionEndpoint = introspectionEndpoint;
        return this;
        }

    /**
        * Get introspectionEndpoint
    * @return introspectionEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9444/oauth2/introspect", value = "")
    
    public String getIntrospectionEndpoint() {
        return introspectionEndpoint;
    }


    public void setIntrospectionEndpoint(String introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }


        public KeyManagerDTO clientRegistrationEndpoint(String clientRegistrationEndpoint) {
        
        this.clientRegistrationEndpoint = clientRegistrationEndpoint;
        return this;
        }

    /**
        * Get clientRegistrationEndpoint
    * @return clientRegistrationEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9444/keymanager-operations/dcr/register", value = "")
    
    public String getClientRegistrationEndpoint() {
        return clientRegistrationEndpoint;
    }


    public void setClientRegistrationEndpoint(String clientRegistrationEndpoint) {
        this.clientRegistrationEndpoint = clientRegistrationEndpoint;
    }


        public KeyManagerDTO tokenEndpoint(String tokenEndpoint) {
        
        this.tokenEndpoint = tokenEndpoint;
        return this;
        }

    /**
        * Get tokenEndpoint
    * @return tokenEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9444/oauth2/token", value = "")
    
    public String getTokenEndpoint() {
        return tokenEndpoint;
    }


    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }


        public KeyManagerDTO displayTokenEndpoint(String displayTokenEndpoint) {
        
        this.displayTokenEndpoint = displayTokenEndpoint;
        return this;
        }

    /**
        * Get displayTokenEndpoint
    * @return displayTokenEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9444/oauth2/token", value = "")
    
    public String getDisplayTokenEndpoint() {
        return displayTokenEndpoint;
    }


    public void setDisplayTokenEndpoint(String displayTokenEndpoint) {
        this.displayTokenEndpoint = displayTokenEndpoint;
    }


        public KeyManagerDTO revokeEndpoint(String revokeEndpoint) {
        
        this.revokeEndpoint = revokeEndpoint;
        return this;
        }

    /**
        * Get revokeEndpoint
    * @return revokeEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9444/oauth2/revoke", value = "")
    
    public String getRevokeEndpoint() {
        return revokeEndpoint;
    }


    public void setRevokeEndpoint(String revokeEndpoint) {
        this.revokeEndpoint = revokeEndpoint;
    }


        public KeyManagerDTO displayRevokeEndpoint(String displayRevokeEndpoint) {
        
        this.displayRevokeEndpoint = displayRevokeEndpoint;
        return this;
        }

    /**
        * Get displayRevokeEndpoint
    * @return displayRevokeEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9444/oauth2/revoke", value = "")
    
    public String getDisplayRevokeEndpoint() {
        return displayRevokeEndpoint;
    }


    public void setDisplayRevokeEndpoint(String displayRevokeEndpoint) {
        this.displayRevokeEndpoint = displayRevokeEndpoint;
    }


        public KeyManagerDTO userInfoEndpoint(String userInfoEndpoint) {
        
        this.userInfoEndpoint = userInfoEndpoint;
        return this;
        }

    /**
        * Get userInfoEndpoint
    * @return userInfoEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9444/oauth2/userinfo?schema=openid", value = "")
    
    public String getUserInfoEndpoint() {
        return userInfoEndpoint;
    }


    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }


        public KeyManagerDTO authorizeEndpoint(String authorizeEndpoint) {
        
        this.authorizeEndpoint = authorizeEndpoint;
        return this;
        }

    /**
        * Get authorizeEndpoint
    * @return authorizeEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9444/oauth2/authorize", value = "")
    
    public String getAuthorizeEndpoint() {
        return authorizeEndpoint;
    }


    public void setAuthorizeEndpoint(String authorizeEndpoint) {
        this.authorizeEndpoint = authorizeEndpoint;
    }


        public KeyManagerDTO certificates(KeyManagerCertificatesDTO certificates) {
        
        this.certificates = certificates;
        return this;
        }

    /**
        * Get certificates
    * @return certificates
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
    
    public KeyManagerCertificatesDTO getCertificates() {
        return certificates;
    }


    public void setCertificates(KeyManagerCertificatesDTO certificates) {
        this.certificates = certificates;
    }


        public KeyManagerDTO issuer(String issuer) {
        
        this.issuer = issuer;
        return this;
        }

    /**
        * Get issuer
    * @return issuer
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9444/services", value = "")
    
    public String getIssuer() {
        return issuer;
    }


    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }


        public KeyManagerDTO alias(String alias) {
        
        this.alias = alias;
        return this;
        }

    /**
        * The alias of Identity Provider. If the tokenType is EXCHANGED, the alias value should be inclusive in the audience values of the JWT token 
    * @return alias
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://localhost:9443/oauth2/token", value = "The alias of Identity Provider. If the tokenType is EXCHANGED, the alias value should be inclusive in the audience values of the JWT token ")
    
    public String getAlias() {
        return alias;
    }


    public void setAlias(String alias) {
        this.alias = alias;
    }


        public KeyManagerDTO scopeManagementEndpoint(String scopeManagementEndpoint) {
        
        this.scopeManagementEndpoint = scopeManagementEndpoint;
        return this;
        }

    /**
        * Get scopeManagementEndpoint
    * @return scopeManagementEndpoint
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "https://wso2is.com:9444/api/identity/oauth2/v1.0/scopes", value = "")
    
    public String getScopeManagementEndpoint() {
        return scopeManagementEndpoint;
    }


    public void setScopeManagementEndpoint(String scopeManagementEndpoint) {
        this.scopeManagementEndpoint = scopeManagementEndpoint;
    }


        public KeyManagerDTO availableGrantTypes(List<String> availableGrantTypes) {
        
        this.availableGrantTypes = availableGrantTypes;
        return this;
        }

    /**
        * Get availableGrantTypes
    * @return availableGrantTypes
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
    
    public List<String> getAvailableGrantTypes() {
        return availableGrantTypes;
    }


    public void setAvailableGrantTypes(List<String> availableGrantTypes) {
        this.availableGrantTypes = availableGrantTypes;
    }


        public KeyManagerDTO enableTokenGeneration(Boolean enableTokenGeneration) {
        
        this.enableTokenGeneration = enableTokenGeneration;
        return this;
        }

    /**
        * Get enableTokenGeneration
    * @return enableTokenGeneration
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "true", value = "")
    
    public Boolean isEnableTokenGeneration() {
        return enableTokenGeneration;
    }


    public void setEnableTokenGeneration(Boolean enableTokenGeneration) {
        this.enableTokenGeneration = enableTokenGeneration;
    }


        public KeyManagerDTO enableTokenEncryption(Boolean enableTokenEncryption) {
        
        this.enableTokenEncryption = enableTokenEncryption;
        return this;
        }

    /**
        * Get enableTokenEncryption
    * @return enableTokenEncryption
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "false", value = "")
    
    public Boolean isEnableTokenEncryption() {
        return enableTokenEncryption;
    }


    public void setEnableTokenEncryption(Boolean enableTokenEncryption) {
        this.enableTokenEncryption = enableTokenEncryption;
    }


        public KeyManagerDTO enableTokenHashing(Boolean enableTokenHashing) {
        
        this.enableTokenHashing = enableTokenHashing;
        return this;
        }

    /**
        * Get enableTokenHashing
    * @return enableTokenHashing
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "false", value = "")
    
    public Boolean isEnableTokenHashing() {
        return enableTokenHashing;
    }


    public void setEnableTokenHashing(Boolean enableTokenHashing) {
        this.enableTokenHashing = enableTokenHashing;
    }


        public KeyManagerDTO enableMapOAuthConsumerApps(Boolean enableMapOAuthConsumerApps) {
        
        this.enableMapOAuthConsumerApps = enableMapOAuthConsumerApps;
        return this;
        }

    /**
        * Get enableMapOAuthConsumerApps
    * @return enableMapOAuthConsumerApps
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "false", value = "")
    
    public Boolean isEnableMapOAuthConsumerApps() {
        return enableMapOAuthConsumerApps;
    }


    public void setEnableMapOAuthConsumerApps(Boolean enableMapOAuthConsumerApps) {
        this.enableMapOAuthConsumerApps = enableMapOAuthConsumerApps;
    }


        public KeyManagerDTO enableOAuthAppCreation(Boolean enableOAuthAppCreation) {
        
        this.enableOAuthAppCreation = enableOAuthAppCreation;
        return this;
        }

    /**
        * Get enableOAuthAppCreation
    * @return enableOAuthAppCreation
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "false", value = "")
    
    public Boolean isEnableOAuthAppCreation() {
        return enableOAuthAppCreation;
    }


    public void setEnableOAuthAppCreation(Boolean enableOAuthAppCreation) {
        this.enableOAuthAppCreation = enableOAuthAppCreation;
    }


        public KeyManagerDTO enableSelfValidationJWT(Boolean enableSelfValidationJWT) {
        
        this.enableSelfValidationJWT = enableSelfValidationJWT;
        return this;
        }

    /**
        * Get enableSelfValidationJWT
    * @return enableSelfValidationJWT
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "true", value = "")
    
    public Boolean isEnableSelfValidationJWT() {
        return enableSelfValidationJWT;
    }


    public void setEnableSelfValidationJWT(Boolean enableSelfValidationJWT) {
        this.enableSelfValidationJWT = enableSelfValidationJWT;
    }


        public KeyManagerDTO claimMapping(List<ClaimMappingEntryDTO> claimMapping) {
        
        this.claimMapping = claimMapping;
        return this;
        }

    /**
        * Get claimMapping
    * @return claimMapping
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
    
    public List<ClaimMappingEntryDTO> getClaimMapping() {
        return claimMapping;
    }


    public void setClaimMapping(List<ClaimMappingEntryDTO> claimMapping) {
        this.claimMapping = claimMapping;
    }


        public KeyManagerDTO consumerKeyClaim(String consumerKeyClaim) {
        
        this.consumerKeyClaim = consumerKeyClaim;
        return this;
        }

    /**
        * Get consumerKeyClaim
    * @return consumerKeyClaim
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "azp", value = "")
    
    public String getConsumerKeyClaim() {
        return consumerKeyClaim;
    }


    public void setConsumerKeyClaim(String consumerKeyClaim) {
        this.consumerKeyClaim = consumerKeyClaim;
    }


        public KeyManagerDTO scopesClaim(String scopesClaim) {
        
        this.scopesClaim = scopesClaim;
        return this;
        }

    /**
        * Get scopesClaim
    * @return scopesClaim
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "scp", value = "")
    
    public String getScopesClaim() {
        return scopesClaim;
    }


    public void setScopesClaim(String scopesClaim) {
        this.scopesClaim = scopesClaim;
    }


        public KeyManagerDTO tokenValidation(List<TokenValidationDTO> tokenValidation) {
        
        this.tokenValidation = tokenValidation;
        return this;
        }

    /**
        * Get tokenValidation
    * @return tokenValidation
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
    
    public List<TokenValidationDTO> getTokenValidation() {
        return tokenValidation;
    }


    public void setTokenValidation(List<TokenValidationDTO> tokenValidation) {
        this.tokenValidation = tokenValidation;
    }


        public KeyManagerDTO enabled(Boolean enabled) {
        
        this.enabled = enabled;
        return this;
        }

    /**
        * Get enabled
    * @return enabled
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "true", value = "")
    
    public Boolean isEnabled() {
        return enabled;
    }


    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }


        public KeyManagerDTO additionalProperties(Object additionalProperties) {
        
        this.additionalProperties = additionalProperties;
        return this;
        }

    /**
        * Get additionalProperties
    * @return additionalProperties
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "{\"self_validate_jwt\":true,\"Username\":\"admin\",\"Password\":\"admin\"}", value = "")
    
    public Object getAdditionalProperties() {
        return additionalProperties;
    }


    public void setAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
    }


        public KeyManagerDTO tokenType(TokenTypeEnum tokenType) {
        
        this.tokenType = tokenType;
        return this;
        }

    /**
        * The type of the tokens to be used (exchanged or without exchanged). Accepted values are EXCHANGED and DIRECT.
    * @return tokenType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "EXCHANGED", value = "The type of the tokens to be used (exchanged or without exchanged). Accepted values are EXCHANGED and DIRECT.")
    
    public TokenTypeEnum getTokenType() {
        return tokenType;
    }


    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
        return true;
        }
        if (o == null || getClass() != o.getClass()) {
        return false;
        }
            KeyManagerDTO keyManager = (KeyManagerDTO) o;
            return Objects.equals(this.id, keyManager.id) &&
            Objects.equals(this.name, keyManager.name) &&
            Objects.equals(this.displayName, keyManager.displayName) &&
            Objects.equals(this.type, keyManager.type) &&
            Objects.equals(this.description, keyManager.description) &&
            Objects.equals(this.wellKnownEndpoint, keyManager.wellKnownEndpoint) &&
            Objects.equals(this.introspectionEndpoint, keyManager.introspectionEndpoint) &&
            Objects.equals(this.clientRegistrationEndpoint, keyManager.clientRegistrationEndpoint) &&
            Objects.equals(this.tokenEndpoint, keyManager.tokenEndpoint) &&
            Objects.equals(this.displayTokenEndpoint, keyManager.displayTokenEndpoint) &&
            Objects.equals(this.revokeEndpoint, keyManager.revokeEndpoint) &&
            Objects.equals(this.displayRevokeEndpoint, keyManager.displayRevokeEndpoint) &&
            Objects.equals(this.userInfoEndpoint, keyManager.userInfoEndpoint) &&
            Objects.equals(this.authorizeEndpoint, keyManager.authorizeEndpoint) &&
            Objects.equals(this.certificates, keyManager.certificates) &&
            Objects.equals(this.issuer, keyManager.issuer) &&
            Objects.equals(this.alias, keyManager.alias) &&
            Objects.equals(this.scopeManagementEndpoint, keyManager.scopeManagementEndpoint) &&
            Objects.equals(this.availableGrantTypes, keyManager.availableGrantTypes) &&
            Objects.equals(this.enableTokenGeneration, keyManager.enableTokenGeneration) &&
            Objects.equals(this.enableTokenEncryption, keyManager.enableTokenEncryption) &&
            Objects.equals(this.enableTokenHashing, keyManager.enableTokenHashing) &&
            Objects.equals(this.enableMapOAuthConsumerApps, keyManager.enableMapOAuthConsumerApps) &&
            Objects.equals(this.enableOAuthAppCreation, keyManager.enableOAuthAppCreation) &&
            Objects.equals(this.enableSelfValidationJWT, keyManager.enableSelfValidationJWT) &&
            Objects.equals(this.claimMapping, keyManager.claimMapping) &&
            Objects.equals(this.consumerKeyClaim, keyManager.consumerKeyClaim) &&
            Objects.equals(this.scopesClaim, keyManager.scopesClaim) &&
            Objects.equals(this.tokenValidation, keyManager.tokenValidation) &&
            Objects.equals(this.enabled, keyManager.enabled) &&
            Objects.equals(this.additionalProperties, keyManager.additionalProperties) &&
            Objects.equals(this.tokenType, keyManager.tokenType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, displayName, type, description, wellKnownEndpoint, introspectionEndpoint, clientRegistrationEndpoint, tokenEndpoint, displayTokenEndpoint, revokeEndpoint, displayRevokeEndpoint, userInfoEndpoint, authorizeEndpoint, certificates, issuer, alias, scopeManagementEndpoint, availableGrantTypes, enableTokenGeneration, enableTokenEncryption, enableTokenHashing, enableMapOAuthConsumerApps, enableOAuthAppCreation, enableSelfValidationJWT, claimMapping, consumerKeyClaim, scopesClaim, tokenValidation, enabled, additionalProperties, tokenType);
    }


@Override
public String toString() {
StringBuilder sb = new StringBuilder();
sb.append("class KeyManagerDTO {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    wellKnownEndpoint: ").append(toIndentedString(wellKnownEndpoint)).append("\n");
    sb.append("    introspectionEndpoint: ").append(toIndentedString(introspectionEndpoint)).append("\n");
    sb.append("    clientRegistrationEndpoint: ").append(toIndentedString(clientRegistrationEndpoint)).append("\n");
    sb.append("    tokenEndpoint: ").append(toIndentedString(tokenEndpoint)).append("\n");
    sb.append("    displayTokenEndpoint: ").append(toIndentedString(displayTokenEndpoint)).append("\n");
    sb.append("    revokeEndpoint: ").append(toIndentedString(revokeEndpoint)).append("\n");
    sb.append("    displayRevokeEndpoint: ").append(toIndentedString(displayRevokeEndpoint)).append("\n");
    sb.append("    userInfoEndpoint: ").append(toIndentedString(userInfoEndpoint)).append("\n");
    sb.append("    authorizeEndpoint: ").append(toIndentedString(authorizeEndpoint)).append("\n");
    sb.append("    certificates: ").append(toIndentedString(certificates)).append("\n");
    sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
    sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
    sb.append("    scopeManagementEndpoint: ").append(toIndentedString(scopeManagementEndpoint)).append("\n");
    sb.append("    availableGrantTypes: ").append(toIndentedString(availableGrantTypes)).append("\n");
    sb.append("    enableTokenGeneration: ").append(toIndentedString(enableTokenGeneration)).append("\n");
    sb.append("    enableTokenEncryption: ").append(toIndentedString(enableTokenEncryption)).append("\n");
    sb.append("    enableTokenHashing: ").append(toIndentedString(enableTokenHashing)).append("\n");
    sb.append("    enableMapOAuthConsumerApps: ").append(toIndentedString(enableMapOAuthConsumerApps)).append("\n");
    sb.append("    enableOAuthAppCreation: ").append(toIndentedString(enableOAuthAppCreation)).append("\n");
    sb.append("    enableSelfValidationJWT: ").append(toIndentedString(enableSelfValidationJWT)).append("\n");
    sb.append("    claimMapping: ").append(toIndentedString(claimMapping)).append("\n");
    sb.append("    consumerKeyClaim: ").append(toIndentedString(consumerKeyClaim)).append("\n");
    sb.append("    scopesClaim: ").append(toIndentedString(scopesClaim)).append("\n");
    sb.append("    tokenValidation: ").append(toIndentedString(tokenValidation)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("    tokenType: ").append(toIndentedString(tokenType)).append("\n");
sb.append("}");
return sb.toString();
}

/**
* Convert the given object to string with each line indented by 4 spaces
* (except the first line).
*/
private String toIndentedString(Object o) {
if (o == null) {
return "null";
}
return o.toString().replace("\n", "\n    ");
}

}

