/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Blocking Conditions")
public class BlockingConditionDTO {
    public static final String SERIALIZED_NAME_CONDITION_ID = "conditionId";
    @SerializedName(value="conditionId")
    private String conditionId;
    public static final String SERIALIZED_NAME_CONDITION_TYPE = "conditionType";
    @SerializedName(value="conditionType")
    private ConditionTypeEnum conditionType;
    public static final String SERIALIZED_NAME_CONDITION_VALUE = "conditionValue";
    @SerializedName(value="conditionValue")
    private Object conditionValue;
    public static final String SERIALIZED_NAME_CONDITION_STATUS = "conditionStatus";
    @SerializedName(value="conditionStatus")
    private Boolean conditionStatus;

    public BlockingConditionDTO conditionId(String conditionId) {
        this.conditionId = conditionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="b513eb68-69e8-4c32-92cf-852c101363cf", value="Id of the blocking condition")
    public String getConditionId() {
        return this.conditionId;
    }

    public void setConditionId(String conditionId) {
        this.conditionId = conditionId;
    }

    public BlockingConditionDTO conditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
        return this;
    }

    @ApiModelProperty(example="IP", required=true, value="Type of the blocking condition")
    public ConditionTypeEnum getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
    }

    public BlockingConditionDTO conditionValue(Object conditionValue) {
        this.conditionValue = conditionValue;
        return this;
    }

    @ApiModelProperty(example="{\"fixedIp\":\"192.168.1.1\",\"invert\":false}", required=true, value="Value of the blocking condition")
    public Object getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(Object conditionValue) {
        this.conditionValue = conditionValue;
    }

    public BlockingConditionDTO conditionStatus(Boolean conditionStatus) {
        this.conditionStatus = conditionStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Status of the blocking condition")
    public Boolean isConditionStatus() {
        return this.conditionStatus;
    }

    public void setConditionStatus(Boolean conditionStatus) {
        this.conditionStatus = conditionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockingConditionDTO blockingCondition = (BlockingConditionDTO)o;
        return Objects.equals(this.conditionId, blockingCondition.conditionId) && Objects.equals((Object)this.conditionType, (Object)blockingCondition.conditionType) && Objects.equals(this.conditionValue, blockingCondition.conditionValue) && Objects.equals(this.conditionStatus, blockingCondition.conditionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditionId, this.conditionType, this.conditionValue, this.conditionStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlockingConditionDTO {\n");
        sb.append("    conditionId: ").append(this.toIndentedString(this.conditionId)).append("\n");
        sb.append("    conditionType: ").append(this.toIndentedString((Object)this.conditionType)).append("\n");
        sb.append("    conditionValue: ").append(this.toIndentedString(this.conditionValue)).append("\n");
        sb.append("    conditionStatus: ").append(this.toIndentedString(this.conditionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ConditionTypeEnum {
        API("API"),
        APPLICATION("APPLICATION"),
        IP("IP"),
        IPRANGE("IPRANGE"),
        USER("USER");

        private String value;

        private ConditionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConditionTypeEnum fromValue(String value) {
            for (ConditionTypeEnum b : ConditionTypeEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ConditionTypeEnum> {
            public void write(JsonWriter jsonWriter, ConditionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ConditionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ConditionTypeEnum.fromValue(value);
            }
        }
    }
}

