/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;

public class LLMProviderRequestDTO {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CONFIGURATIONS = "configurations";
    @SerializedName(value="configurations")
    private String configurations;
    public static final String SERIALIZED_NAME_API_DEFINITION = "apiDefinition";
    @SerializedName(value="apiDefinition")
    private File apiDefinition;
    public static final String SERIALIZED_NAME_MODEL_LIST = "modelList";
    @SerializedName(value="modelList")
    private String modelList;

    public LLMProviderRequestDTO name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="OpenAI", value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LLMProviderRequestDTO apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1.0.0", value="")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public LLMProviderRequestDTO description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="OpenAI LLM", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LLMProviderRequestDTO configurations(String configurations) {
        this.configurations = configurations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="LLM Provider configurations")
    public String getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(String configurations) {
        this.configurations = configurations;
    }

    public LLMProviderRequestDTO apiDefinition(File apiDefinition) {
        this.apiDefinition = apiDefinition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OpenAPI specification")
    public File getApiDefinition() {
        return this.apiDefinition;
    }

    public void setApiDefinition(File apiDefinition) {
        this.apiDefinition = apiDefinition;
    }

    public LLMProviderRequestDTO modelList(String modelList) {
        this.modelList = modelList;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of models supported by the LLM Provider as a stringified JSON array")
    public String getModelList() {
        return this.modelList;
    }

    public void setModelList(String modelList) {
        this.modelList = modelList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLMProviderRequestDTO llMProviderRequest = (LLMProviderRequestDTO)o;
        return Objects.equals(this.name, llMProviderRequest.name) && Objects.equals(this.apiVersion, llMProviderRequest.apiVersion) && Objects.equals(this.description, llMProviderRequest.description) && Objects.equals(this.configurations, llMProviderRequest.configurations) && Objects.equals(this.apiDefinition, llMProviderRequest.apiDefinition) && Objects.equals(this.modelList, llMProviderRequest.modelList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.apiVersion, this.description, this.configurations, this.apiDefinition, this.modelList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LLMProviderRequestDTO {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    configurations: ").append(this.toIndentedString(this.configurations)).append("\n");
        sb.append("    apiDefinition: ").append(this.toIndentedString(this.apiDefinition)).append("\n");
        sb.append("    modelList: ").append(this.toIndentedString(this.modelList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

