/*
 * WSO2 API Manager - Gateway
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Gateway. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/master/components/apimgt/org.wso2.carbon.apimgt.rest.api.gateway/src/main/resources/gateway-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v2.1
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.gateway.api.v2.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.am.integration.clients.gateway.api.v2.dto.ApplicationKeyMappingDTO;

/**
 * ApplicationInfoDTO
 */

public class ApplicationInfoDTO {
  @SerializedName("uuid")
  private String uuid = null;

  @SerializedName("id")
  private Integer id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("subName")
  private String subName = null;

  @SerializedName("policy")
  private String policy = null;

  @SerializedName("tokenType")
  private String tokenType = null;

  @SerializedName("attributes")
  private Map<String, String> attributes = null;

  @SerializedName("keys")
  private List<ApplicationKeyMappingDTO> keys = null;

  public ApplicationInfoDTO uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

   /**
   * Get uuid
   * @return uuid
  **/
  @ApiModelProperty(example = "d290f1ee-6c54-4b01-90e6-d701848f0851", value = "")
  public String getUuid() {
    return uuid;
  }

  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  public ApplicationInfoDTO id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(example = "1", value = "")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public ApplicationInfoDTO name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(example = "PizzaAPP", value = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ApplicationInfoDTO subName(String subName) {
    this.subName = subName;
    return this;
  }

   /**
   * Get subName
   * @return subName
  **/
  @ApiModelProperty(example = "admin", value = "")
  public String getSubName() {
    return subName;
  }

  public void setSubName(String subName) {
    this.subName = subName;
  }

  public ApplicationInfoDTO policy(String policy) {
    this.policy = policy;
    return this;
  }

   /**
   * Application level throtting policy.
   * @return policy
  **/
  @ApiModelProperty(example = "Gold", value = "Application level throtting policy.")
  public String getPolicy() {
    return policy;
  }

  public void setPolicy(String policy) {
    this.policy = policy;
  }

  public ApplicationInfoDTO tokenType(String tokenType) {
    this.tokenType = tokenType;
    return this;
  }

   /**
   * type of the token.
   * @return tokenType
  **/
  @ApiModelProperty(example = "JWT", value = "type of the token.")
  public String getTokenType() {
    return tokenType;
  }

  public void setTokenType(String tokenType) {
    this.tokenType = tokenType;
  }

  public ApplicationInfoDTO attributes(Map<String, String> attributes) {
    this.attributes = attributes;
    return this;
  }

  public ApplicationInfoDTO putAttributesItem(String key, String attributesItem) {
    if (this.attributes == null) {
      this.attributes = new HashMap<>();
    }
    this.attributes.put(key, attributesItem);
    return this;
  }

   /**
   * Get attributes
   * @return attributes
  **/
  @ApiModelProperty(value = "")
  public Map<String, String> getAttributes() {
    return attributes;
  }

  public void setAttributes(Map<String, String> attributes) {
    this.attributes = attributes;
  }

  public ApplicationInfoDTO keys(List<ApplicationKeyMappingDTO> keys) {
    this.keys = keys;
    return this;
  }

  public ApplicationInfoDTO addKeysItem(ApplicationKeyMappingDTO keysItem) {
    if (this.keys == null) {
      this.keys = new ArrayList<>();
    }
    this.keys.add(keysItem);
    return this;
  }

   /**
   * Get keys
   * @return keys
  **/
  @ApiModelProperty(value = "")
  public List<ApplicationKeyMappingDTO> getKeys() {
    return keys;
  }

  public void setKeys(List<ApplicationKeyMappingDTO> keys) {
    this.keys = keys;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationInfoDTO applicationInfo = (ApplicationInfoDTO) o;
    return Objects.equals(this.uuid, applicationInfo.uuid) &&
        Objects.equals(this.id, applicationInfo.id) &&
        Objects.equals(this.name, applicationInfo.name) &&
        Objects.equals(this.subName, applicationInfo.subName) &&
        Objects.equals(this.policy, applicationInfo.policy) &&
        Objects.equals(this.tokenType, applicationInfo.tokenType) &&
        Objects.equals(this.attributes, applicationInfo.attributes) &&
        Objects.equals(this.keys, applicationInfo.keys);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uuid, id, name, subName, policy, tokenType, attributes, keys);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationInfoDTO {\n");
    
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    subName: ").append(toIndentedString(subName)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    tokenType: ").append(toIndentedString(tokenType)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    keys: ").append(toIndentedString(keys)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

