/*
 * WSO2 API Manager - Gateway
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Gateway. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/master/components/apimgt/org.wso2.carbon.apimgt.rest.api.gateway/src/main/resources/gateway-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v2.1
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.gateway.api.v2.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * ApplicationKeyMappingDTO
 */

public class ApplicationKeyMappingDTO {
  @SerializedName("consumerKey")
  private String consumerKey = null;

  @SerializedName("keyType")
  private String keyType = null;

  @SerializedName("keyManager")
  private String keyManager = null;

  public ApplicationKeyMappingDTO consumerKey(String consumerKey) {
    this.consumerKey = consumerKey;
    return this;
  }

   /**
   * Get consumerKey
   * @return consumerKey
  **/
  @ApiModelProperty(example = "d290f1ee-6c54-4b01-90e6-d701848f0851", value = "")
  public String getConsumerKey() {
    return consumerKey;
  }

  public void setConsumerKey(String consumerKey) {
    this.consumerKey = consumerKey;
  }

  public ApplicationKeyMappingDTO keyType(String keyType) {
    this.keyType = keyType;
    return this;
  }

   /**
   * Get keyType
   * @return keyType
  **/
  @ApiModelProperty(example = "Production", value = "")
  public String getKeyType() {
    return keyType;
  }

  public void setKeyType(String keyType) {
    this.keyType = keyType;
  }

  public ApplicationKeyMappingDTO keyManager(String keyManager) {
    this.keyManager = keyManager;
    return this;
  }

   /**
   * Get keyManager
   * @return keyManager
  **/
  @ApiModelProperty(example = "Resident Key Manager", value = "")
  public String getKeyManager() {
    return keyManager;
  }

  public void setKeyManager(String keyManager) {
    this.keyManager = keyManager;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationKeyMappingDTO applicationKeyMapping = (ApplicationKeyMappingDTO) o;
    return Objects.equals(this.consumerKey, applicationKeyMapping.consumerKey) &&
        Objects.equals(this.keyType, applicationKeyMapping.keyType) &&
        Objects.equals(this.keyManager, applicationKeyMapping.keyManager);
  }

  @Override
  public int hashCode() {
    return Objects.hash(consumerKey, keyType, keyManager);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationKeyMappingDTO {\n");
    
    sb.append("    consumerKey: ").append(toIndentedString(consumerKey)).append("\n");
    sb.append("    keyType: ").append(toIndentedString(keyType)).append("\n");
    sb.append("    keyManager: ").append(toIndentedString(keyManager)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

