/*
 * WSO2 API Manager - Gateway
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Gateway. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/master/components/apimgt/org.wso2.carbon.apimgt.rest.api.gateway/src/main/resources/gateway-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v2.1
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.gateway.api.v2.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.wso2.am.integration.clients.gateway.api.v2.dto.ApplicationInfoDTO;

/**
 * SubscriptionInfoDTO
 */

public class SubscriptionInfoDTO {
  @SerializedName("subscriptionUUID")
  private String subscriptionUUID = null;

  @SerializedName("subscriptionPolicy")
  private String subscriptionPolicy = null;

  @SerializedName("status")
  private String status = null;

  @SerializedName("application")
  private ApplicationInfoDTO application = null;

  public SubscriptionInfoDTO subscriptionUUID(String subscriptionUUID) {
    this.subscriptionUUID = subscriptionUUID;
    return this;
  }

   /**
   * Get subscriptionUUID
   * @return subscriptionUUID
  **/
  @ApiModelProperty(example = "d290f1ee-6c54-4b01-90e6-d701748f0851", value = "")
  public String getSubscriptionUUID() {
    return subscriptionUUID;
  }

  public void setSubscriptionUUID(String subscriptionUUID) {
    this.subscriptionUUID = subscriptionUUID;
  }

  public SubscriptionInfoDTO subscriptionPolicy(String subscriptionPolicy) {
    this.subscriptionPolicy = subscriptionPolicy;
    return this;
  }

   /**
   * Get subscriptionPolicy
   * @return subscriptionPolicy
  **/
  @ApiModelProperty(example = "Gold", value = "")
  public String getSubscriptionPolicy() {
    return subscriptionPolicy;
  }

  public void setSubscriptionPolicy(String subscriptionPolicy) {
    this.subscriptionPolicy = subscriptionPolicy;
  }

  public SubscriptionInfoDTO status(String status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @ApiModelProperty(example = "UnBlocked", value = "")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public SubscriptionInfoDTO application(ApplicationInfoDTO application) {
    this.application = application;
    return this;
  }

   /**
   * Get application
   * @return application
  **/
  @ApiModelProperty(value = "")
  public ApplicationInfoDTO getApplication() {
    return application;
  }

  public void setApplication(ApplicationInfoDTO application) {
    this.application = application;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubscriptionInfoDTO subscriptionInfo = (SubscriptionInfoDTO) o;
    return Objects.equals(this.subscriptionUUID, subscriptionInfo.subscriptionUUID) &&
        Objects.equals(this.subscriptionPolicy, subscriptionInfo.subscriptionPolicy) &&
        Objects.equals(this.status, subscriptionInfo.status) &&
        Objects.equals(this.application, subscriptionInfo.application);
  }

  @Override
  public int hashCode() {
    return Objects.hash(subscriptionUUID, subscriptionPolicy, status, application);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubscriptionInfoDTO {\n");
    
    sb.append("    subscriptionUUID: ").append(toIndentedString(subscriptionUUID)).append("\n");
    sb.append("    subscriptionPolicy: ").append(toIndentedString(subscriptionPolicy)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    application: ").append(toIndentedString(application)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

