/*
 * WSO2 API Manager - Gateway
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Gateway. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/master/components/apimgt/org.wso2.carbon.apimgt.rest.api.gateway/src/main/resources/gateway-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v2.1
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.gateway.api.v2.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * URLMappingDTO
 */

public class URLMappingDTO {
  @SerializedName("authScheme")
  private String authScheme = null;

  @SerializedName("throttlingPolicy")
  private String throttlingPolicy = null;

  @SerializedName("httpMethod")
  private String httpMethod = null;

  @SerializedName("urlPattern")
  private String urlPattern = null;

  @SerializedName("scopes")
  private List<String> scopes = null;

  public URLMappingDTO authScheme(String authScheme) {
    this.authScheme = authScheme;
    return this;
  }

   /**
   * Get authScheme
   * @return authScheme
  **/
  @ApiModelProperty(example = "Application & Application User", value = "")
  public String getAuthScheme() {
    return authScheme;
  }

  public void setAuthScheme(String authScheme) {
    this.authScheme = authScheme;
  }

  public URLMappingDTO throttlingPolicy(String throttlingPolicy) {
    this.throttlingPolicy = throttlingPolicy;
    return this;
  }

   /**
   * Get throttlingPolicy
   * @return throttlingPolicy
  **/
  @ApiModelProperty(example = "Unlimited", value = "")
  public String getThrottlingPolicy() {
    return throttlingPolicy;
  }

  public void setThrottlingPolicy(String throttlingPolicy) {
    this.throttlingPolicy = throttlingPolicy;
  }

  public URLMappingDTO httpMethod(String httpMethod) {
    this.httpMethod = httpMethod;
    return this;
  }

   /**
   * Get httpMethod
   * @return httpMethod
  **/
  @ApiModelProperty(example = "GET", value = "")
  public String getHttpMethod() {
    return httpMethod;
  }

  public void setHttpMethod(String httpMethod) {
    this.httpMethod = httpMethod;
  }

  public URLMappingDTO urlPattern(String urlPattern) {
    this.urlPattern = urlPattern;
    return this;
  }

   /**
   * Get urlPattern
   * @return urlPattern
  **/
  @ApiModelProperty(example = "/menu", value = "")
  public String getUrlPattern() {
    return urlPattern;
  }

  public void setUrlPattern(String urlPattern) {
    this.urlPattern = urlPattern;
  }

  public URLMappingDTO scopes(List<String> scopes) {
    this.scopes = scopes;
    return this;
  }

  public URLMappingDTO addScopesItem(String scopesItem) {
    if (this.scopes == null) {
      this.scopes = new ArrayList<>();
    }
    this.scopes.add(scopesItem);
    return this;
  }

   /**
   * Get scopes
   * @return scopes
  **/
  @ApiModelProperty(value = "")
  public List<String> getScopes() {
    return scopes;
  }

  public void setScopes(List<String> scopes) {
    this.scopes = scopes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    URLMappingDTO urLMapping = (URLMappingDTO) o;
    return Objects.equals(this.authScheme, urLMapping.authScheme) &&
        Objects.equals(this.throttlingPolicy, urLMapping.throttlingPolicy) &&
        Objects.equals(this.httpMethod, urLMapping.httpMethod) &&
        Objects.equals(this.urlPattern, urLMapping.urlPattern) &&
        Objects.equals(this.scopes, urLMapping.scopes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authScheme, throttlingPolicy, httpMethod, urlPattern, scopes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class URLMappingDTO {\n");
    
    sb.append("    authScheme: ").append(toIndentedString(authScheme)).append("\n");
    sb.append("    throttlingPolicy: ").append(toIndentedString(throttlingPolicy)).append("\n");
    sb.append("    httpMethod: ").append(toIndentedString(httpMethod)).append("\n");
    sb.append("    urlPattern: ").append(toIndentedString(urlPattern)).append("\n");
    sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

