/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.gateway.api.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.gateway.api.ApiCallback;
import org.wso2.am.integration.clients.gateway.api.ApiClient;
import org.wso2.am.integration.clients.gateway.api.ApiException;
import org.wso2.am.integration.clients.gateway.api.ApiResponse;
import org.wso2.am.integration.clients.gateway.api.Configuration;
import org.wso2.am.integration.clients.gateway.api.Pair;
import org.wso2.am.integration.clients.gateway.api.ProgressRequestBody;
import org.wso2.am.integration.clients.gateway.api.ProgressResponseBody;
import org.wso2.am.integration.clients.gateway.api.v2.dto.DeployResponseDTO;

public class DeployApiApi {
    private ApiClient apiClient;

    public DeployApiApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeployApiApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call redployAPICall(String apiName, String version, String tenantDomain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/redeploy-api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiName", apiName));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        if (tenantDomain != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantDomain", tenantDomain));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call redployAPIValidateBeforeCall(String apiName, String version, String tenantDomain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiName == null) {
            throw new ApiException("Missing the required parameter 'apiName' when calling redployAPI(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling redployAPI(Async)");
        }
        Call call = this.redployAPICall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        return call;
    }

    public DeployResponseDTO redployAPI(String apiName, String version, String tenantDomain) throws ApiException {
        ApiResponse<DeployResponseDTO> resp = this.redployAPIWithHttpInfo(apiName, version, tenantDomain);
        return resp.getData();
    }

    public ApiResponse<DeployResponseDTO> redployAPIWithHttpInfo(String apiName, String version, String tenantDomain) throws ApiException {
        Call call = this.redployAPIValidateBeforeCall(apiName, version, tenantDomain, null, null);
        Type localVarReturnType = new TypeToken<DeployResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call redployAPIAsync(String apiName, String version, String tenantDomain, final ApiCallback<DeployResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.redployAPIValidateBeforeCall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeployResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

