/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.internal.api;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.internal.ApiCallback;
import org.wso2.am.integration.clients.internal.ApiClient;
import org.wso2.am.integration.clients.internal.ApiException;
import org.wso2.am.integration.clients.internal.ApiResponse;
import org.wso2.am.integration.clients.internal.Configuration;
import org.wso2.am.integration.clients.internal.Pair;
import org.wso2.am.integration.clients.internal.ProgressRequestBody;
import org.wso2.am.integration.clients.internal.ProgressResponseBody;

public class RetrievingRuntimeArtifactsApi {
    private ApiClient apiClient;

    public RetrievingRuntimeArtifactsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RetrievingRuntimeArtifactsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call endpointCertificatesGetCall(String xWSO2Tenant, String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (alias != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("alias", alias));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("xWSO2Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointCertificatesGetValidateBeforeCall(String xWSO2Tenant, String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xWSO2Tenant == null) {
            throw new ApiException("Missing the required parameter 'xWSO2Tenant' when calling endpointCertificatesGet(Async)");
        }
        Call call = this.endpointCertificatesGetCall(xWSO2Tenant, alias, progressListener, progressRequestListener);
        return call;
    }

    public void endpointCertificatesGet(String xWSO2Tenant, String alias) throws ApiException {
        this.endpointCertificatesGetWithHttpInfo(xWSO2Tenant, alias);
    }

    public ApiResponse<Void> endpointCertificatesGetWithHttpInfo(String xWSO2Tenant, String alias) throws ApiException {
        Call call = this.endpointCertificatesGetValidateBeforeCall(xWSO2Tenant, alias, null, null);
        return this.apiClient.execute(call);
    }

    public Call endpointCertificatesGetAsync(String xWSO2Tenant, String alias, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointCertificatesGetValidateBeforeCall(xWSO2Tenant, alias, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call gaConfigGetCall(String xWSO2Tenant, String apiId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/ga-config";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiId", apiId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("xWSO2Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gaConfigGetValidateBeforeCall(String xWSO2Tenant, String apiId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xWSO2Tenant == null) {
            throw new ApiException("Missing the required parameter 'xWSO2Tenant' when calling gaConfigGet(Async)");
        }
        Call call = this.gaConfigGetCall(xWSO2Tenant, apiId, progressListener, progressRequestListener);
        return call;
    }

    public void gaConfigGet(String xWSO2Tenant, String apiId) throws ApiException {
        this.gaConfigGetWithHttpInfo(xWSO2Tenant, apiId);
    }

    public ApiResponse<Void> gaConfigGetWithHttpInfo(String xWSO2Tenant, String apiId) throws ApiException {
        Call call = this.gaConfigGetValidateBeforeCall(xWSO2Tenant, apiId, null, null);
        return this.apiClient.execute(call);
    }

    public Call gaConfigGetAsync(String xWSO2Tenant, String apiId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gaConfigGetValidateBeforeCall(xWSO2Tenant, apiId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call runtimeArtifactsGetCall(String xWSO2Tenant, String apiId, String gatewayLabel, String type, String name, String version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/runtime-artifacts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiId", apiId));
        }
        if (gatewayLabel != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("gatewayLabel", gatewayLabel));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("xWSO2Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runtimeArtifactsGetValidateBeforeCall(String xWSO2Tenant, String apiId, String gatewayLabel, String type, String name, String version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xWSO2Tenant == null) {
            throw new ApiException("Missing the required parameter 'xWSO2Tenant' when calling runtimeArtifactsGet(Async)");
        }
        Call call = this.runtimeArtifactsGetCall(xWSO2Tenant, apiId, gatewayLabel, type, name, version, progressListener, progressRequestListener);
        return call;
    }

    public void runtimeArtifactsGet(String xWSO2Tenant, String apiId, String gatewayLabel, String type, String name, String version) throws ApiException {
        this.runtimeArtifactsGetWithHttpInfo(xWSO2Tenant, apiId, gatewayLabel, type, name, version);
    }

    public ApiResponse<Void> runtimeArtifactsGetWithHttpInfo(String xWSO2Tenant, String apiId, String gatewayLabel, String type, String name, String version) throws ApiException {
        Call call = this.runtimeArtifactsGetValidateBeforeCall(xWSO2Tenant, apiId, gatewayLabel, type, name, version, null, null);
        return this.apiClient.execute(call);
    }

    public Call runtimeArtifactsGetAsync(String xWSO2Tenant, String apiId, String gatewayLabel, String type, String name, String version, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runtimeArtifactsGetValidateBeforeCall(xWSO2Tenant, apiId, gatewayLabel, type, name, version, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

