/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.internal.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.internal.ApiCallback;
import org.wso2.am.integration.clients.internal.ApiClient;
import org.wso2.am.integration.clients.internal.ApiException;
import org.wso2.am.integration.clients.internal.ApiResponse;
import org.wso2.am.integration.clients.internal.Configuration;
import org.wso2.am.integration.clients.internal.Pair;
import org.wso2.am.integration.clients.internal.ProgressRequestBody;
import org.wso2.am.integration.clients.internal.ProgressResponseBody;
import org.wso2.am.integration.clients.internal.api.dto.SynapseAttributesDTO;

public class RetrievingSynapseArtifactsApi {
    private ApiClient apiClient;

    public RetrievingSynapseArtifactsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RetrievingSynapseArtifactsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call synapseAttributesGetCall(String apiName, String tenantDomain, String version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/synapse-attributes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiName", apiName));
        }
        if (tenantDomain != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantDomain", tenantDomain));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call synapseAttributesGetValidateBeforeCall(String apiName, String tenantDomain, String version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.synapseAttributesGetCall(apiName, tenantDomain, version, progressListener, progressRequestListener);
        return call;
    }

    public SynapseAttributesDTO synapseAttributesGet(String apiName, String tenantDomain, String version) throws ApiException {
        ApiResponse<SynapseAttributesDTO> resp = this.synapseAttributesGetWithHttpInfo(apiName, tenantDomain, version);
        return resp.getData();
    }

    public ApiResponse<SynapseAttributesDTO> synapseAttributesGetWithHttpInfo(String apiName, String tenantDomain, String version) throws ApiException {
        Call call = this.synapseAttributesGetValidateBeforeCall(apiName, tenantDomain, version, null, null);
        Type localVarReturnType = new TypeToken<SynapseAttributesDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call synapseAttributesGetAsync(String apiName, String tenantDomain, String version, final ApiCallback<SynapseAttributesDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.synapseAttributesGetValidateBeforeCall(apiName, tenantDomain, version, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SynapseAttributesDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

