/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.ProgressRequestBody;
import org.wso2.am.integration.clients.publisher.api.ProgressResponseBody;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.FileInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ResourcePathListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ThrottlingPolicyDTO;

public class ApIsApi {
    private ApiClient apiClient;

    public ApIsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApIsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call apisApiIdDeleteCall(String apiId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdDeleteValidateBeforeCall(String apiId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDelete(Async)");
        }
        Call call = this.apisApiIdDeleteCall(apiId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdDelete(String apiId, String ifMatch) throws ApiException {
        this.apisApiIdDeleteWithHttpInfo(apiId, ifMatch);
    }

    public ApiResponse<Void> apisApiIdDeleteWithHttpInfo(String apiId, String ifMatch) throws ApiException {
        Call call = this.apisApiIdDeleteValidateBeforeCall(apiId, ifMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdDeleteAsync(String apiId, String ifMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdDeleteValidateBeforeCall(apiId, ifMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdGetCall(String apiId, String xWSO2Tenant, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdGetValidateBeforeCall(String apiId, String xWSO2Tenant, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdGet(Async)");
        }
        Call call = this.apisApiIdGetCall(apiId, xWSO2Tenant, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public APIDTO apisApiIdGet(String apiId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        ApiResponse<APIDTO> resp = this.apisApiIdGetWithHttpInfo(apiId, xWSO2Tenant, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<APIDTO> apisApiIdGetWithHttpInfo(String apiId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        Call call = this.apisApiIdGetValidateBeforeCall(apiId, xWSO2Tenant, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdGetAsync(String apiId, String xWSO2Tenant, String ifNoneMatch, final ApiCallback<APIDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdGetValidateBeforeCall(apiId, xWSO2Tenant, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdPutCall(String apiId, APIDTO body, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        APIDTO localVarPostBody = body;
        String localVarPath = "/apis/{apiId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdPutValidateBeforeCall(String apiId, APIDTO body, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apisApiIdPut(Async)");
        }
        Call call = this.apisApiIdPutCall(apiId, body, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public APIDTO apisApiIdPut(String apiId, APIDTO body, String ifMatch) throws ApiException {
        ApiResponse<APIDTO> resp = this.apisApiIdPutWithHttpInfo(apiId, body, ifMatch);
        return resp.getData();
    }

    public ApiResponse<APIDTO> apisApiIdPutWithHttpInfo(String apiId, APIDTO body, String ifMatch) throws ApiException {
        Call call = this.apisApiIdPutValidateBeforeCall(apiId, body, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdPutAsync(String apiId, APIDTO body, String ifMatch, final ApiCallback<APIDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdPutValidateBeforeCall(apiId, body, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdResourcePathsGetCall(String apiId, Integer limit, Integer offset, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/resource-paths".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdResourcePathsGetValidateBeforeCall(String apiId, Integer limit, Integer offset, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdResourcePathsGet(Async)");
        }
        Call call = this.apisApiIdResourcePathsGetCall(apiId, limit, offset, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public ResourcePathListDTO apisApiIdResourcePathsGet(String apiId, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        ApiResponse<ResourcePathListDTO> resp = this.apisApiIdResourcePathsGetWithHttpInfo(apiId, limit, offset, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<ResourcePathListDTO> apisApiIdResourcePathsGetWithHttpInfo(String apiId, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        Call call = this.apisApiIdResourcePathsGetValidateBeforeCall(apiId, limit, offset, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<ResourcePathListDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdResourcePathsGetAsync(String apiId, Integer limit, Integer offset, String ifNoneMatch, final ApiCallback<ResourcePathListDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdResourcePathsGetValidateBeforeCall(apiId, limit, offset, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourcePathListDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdSubscriptionPoliciesGetCall(String apiId, String xWSO2Tenant, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/subscription-policies".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdSubscriptionPoliciesGetValidateBeforeCall(String apiId, String xWSO2Tenant, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdSubscriptionPoliciesGet(Async)");
        }
        Call call = this.apisApiIdSubscriptionPoliciesGetCall(apiId, xWSO2Tenant, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public ThrottlingPolicyDTO apisApiIdSubscriptionPoliciesGet(String apiId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        ApiResponse<ThrottlingPolicyDTO> resp = this.apisApiIdSubscriptionPoliciesGetWithHttpInfo(apiId, xWSO2Tenant, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<ThrottlingPolicyDTO> apisApiIdSubscriptionPoliciesGetWithHttpInfo(String apiId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        Call call = this.apisApiIdSubscriptionPoliciesGetValidateBeforeCall(apiId, xWSO2Tenant, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<ThrottlingPolicyDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdSubscriptionPoliciesGetAsync(String apiId, String xWSO2Tenant, String ifNoneMatch, final ApiCallback<ThrottlingPolicyDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdSubscriptionPoliciesGetValidateBeforeCall(apiId, xWSO2Tenant, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ThrottlingPolicyDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdSwaggerGetCall(String apiId, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/swagger".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdSwaggerGetValidateBeforeCall(String apiId, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdSwaggerGet(Async)");
        }
        Call call = this.apisApiIdSwaggerGetCall(apiId, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public String apisApiIdSwaggerGet(String apiId, String ifNoneMatch) throws ApiException {
        ApiResponse<String> resp = this.apisApiIdSwaggerGetWithHttpInfo(apiId, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<String> apisApiIdSwaggerGetWithHttpInfo(String apiId, String ifNoneMatch) throws ApiException {
        Call call = this.apisApiIdSwaggerGetValidateBeforeCall(apiId, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdSwaggerGetAsync(String apiId, String ifNoneMatch, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdSwaggerGetValidateBeforeCall(apiId, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdSwaggerPutCall(String apiId, String apiDefinition, String url, File file, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/swagger".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (apiDefinition != null) {
            localVarFormParams.put("apiDefinition", apiDefinition);
        }
        if (url != null) {
            localVarFormParams.put("url", url);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdSwaggerPutValidateBeforeCall(String apiId, String apiDefinition, String url, File file, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdSwaggerPut(Async)");
        }
        Call call = this.apisApiIdSwaggerPutCall(apiId, apiDefinition, url, file, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public String apisApiIdSwaggerPut(String apiId, String apiDefinition, String url, File file, String ifMatch) throws ApiException {
        ApiResponse<String> resp = this.apisApiIdSwaggerPutWithHttpInfo(apiId, apiDefinition, url, file, ifMatch);
        return resp.getData();
    }

    public ApiResponse<String> apisApiIdSwaggerPutWithHttpInfo(String apiId, String apiDefinition, String url, File file, String ifMatch) throws ApiException {
        Call call = this.apisApiIdSwaggerPutValidateBeforeCall(apiId, apiDefinition, url, file, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdSwaggerPutAsync(String apiId, String apiDefinition, String url, File file, String ifMatch, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdSwaggerPutValidateBeforeCall(apiId, apiDefinition, url, file, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdThumbnailGetCall(String apiId, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/thumbnail".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdThumbnailGetValidateBeforeCall(String apiId, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdThumbnailGet(Async)");
        }
        Call call = this.apisApiIdThumbnailGetCall(apiId, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdThumbnailGet(String apiId, String ifNoneMatch) throws ApiException {
        this.apisApiIdThumbnailGetWithHttpInfo(apiId, ifNoneMatch);
    }

    public ApiResponse<Void> apisApiIdThumbnailGetWithHttpInfo(String apiId, String ifNoneMatch) throws ApiException {
        Call call = this.apisApiIdThumbnailGetValidateBeforeCall(apiId, ifNoneMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdThumbnailGetAsync(String apiId, String ifNoneMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdThumbnailGetValidateBeforeCall(apiId, ifNoneMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisCopyApiPostCall(String newVersion, String apiId, Boolean defaultVersion, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/copy-api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (newVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("newVersion", newVersion));
        }
        if (defaultVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("defaultVersion", defaultVersion));
        }
        if (apiId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiId", apiId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisCopyApiPostValidateBeforeCall(String newVersion, String apiId, Boolean defaultVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (newVersion == null) {
            throw new ApiException("Missing the required parameter 'newVersion' when calling apisCopyApiPost(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisCopyApiPost(Async)");
        }
        Call call = this.apisCopyApiPostCall(newVersion, apiId, defaultVersion, progressListener, progressRequestListener);
        return call;
    }

    public APIDTO apisCopyApiPost(String newVersion, String apiId, Boolean defaultVersion) throws ApiException {
        ApiResponse<APIDTO> resp = this.apisCopyApiPostWithHttpInfo(newVersion, apiId, defaultVersion);
        return resp.getData();
    }

    public ApiResponse<APIDTO> apisCopyApiPostWithHttpInfo(String newVersion, String apiId, Boolean defaultVersion) throws ApiException {
        Call call = this.apisCopyApiPostValidateBeforeCall(newVersion, apiId, defaultVersion, null, null);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisCopyApiPostAsync(String newVersion, String apiId, Boolean defaultVersion, final ApiCallback<APIDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisCopyApiPostValidateBeforeCall(newVersion, apiId, defaultVersion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisGetCall(Integer limit, Integer offset, String xWSO2Tenant, String query, String ifNoneMatch, Boolean expand, String accept, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query", query));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisGetValidateBeforeCall(Integer limit, Integer offset, String xWSO2Tenant, String query, String ifNoneMatch, Boolean expand, String accept, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.apisGetCall(limit, offset, xWSO2Tenant, query, ifNoneMatch, expand, accept, progressListener, progressRequestListener);
        return call;
    }

    public APIListDTO apisGet(Integer limit, Integer offset, String xWSO2Tenant, String query, String ifNoneMatch, Boolean expand, String accept) throws ApiException {
        ApiResponse<APIListDTO> resp = this.apisGetWithHttpInfo(limit, offset, xWSO2Tenant, query, ifNoneMatch, expand, accept);
        return resp.getData();
    }

    public ApiResponse<APIListDTO> apisGetWithHttpInfo(Integer limit, Integer offset, String xWSO2Tenant, String query, String ifNoneMatch, Boolean expand, String accept) throws ApiException {
        Call call = this.apisGetValidateBeforeCall(limit, offset, xWSO2Tenant, query, ifNoneMatch, expand, accept, null, null);
        Type localVarReturnType = new TypeToken<APIListDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisGetAsync(Integer limit, Integer offset, String xWSO2Tenant, String query, String ifNoneMatch, Boolean expand, String accept, final ApiCallback<APIListDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisGetValidateBeforeCall(limit, offset, xWSO2Tenant, query, ifNoneMatch, expand, accept, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIListDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisImportGraphqlSchemaPostCall(String type, File file, String additionalProperties, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/import-graphql-schema";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarFormParams.put("type", type);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (additionalProperties != null) {
            localVarFormParams.put("additionalProperties", additionalProperties);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisImportGraphqlSchemaPostValidateBeforeCall(String type, File file, String additionalProperties, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.apisImportGraphqlSchemaPostCall(type, file, additionalProperties, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public APIDTO apisImportGraphqlSchemaPost(String type, File file, String additionalProperties, String ifMatch) throws ApiException {
        ApiResponse<APIDTO> resp = this.apisImportGraphqlSchemaPostWithHttpInfo(type, file, additionalProperties, ifMatch);
        return resp.getData();
    }

    public ApiResponse<APIDTO> apisImportGraphqlSchemaPostWithHttpInfo(String type, File file, String additionalProperties, String ifMatch) throws ApiException {
        Call call = this.apisImportGraphqlSchemaPostValidateBeforeCall(type, file, additionalProperties, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisImportGraphqlSchemaPostAsync(String type, File file, String additionalProperties, String ifMatch, final ApiCallback<APIDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisImportGraphqlSchemaPostValidateBeforeCall(type, file, additionalProperties, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisPostCall(APIDTO body, String openAPIVersion, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        APIDTO localVarPostBody = body;
        String localVarPath = "/apis";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (openAPIVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("openAPIVersion", openAPIVersion));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisPostValidateBeforeCall(APIDTO body, String openAPIVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apisPost(Async)");
        }
        Call call = this.apisPostCall(body, openAPIVersion, progressListener, progressRequestListener);
        return call;
    }

    public APIDTO apisPost(APIDTO body, String openAPIVersion) throws ApiException {
        ApiResponse<APIDTO> resp = this.apisPostWithHttpInfo(body, openAPIVersion);
        return resp.getData();
    }

    public ApiResponse<APIDTO> apisPostWithHttpInfo(APIDTO body, String openAPIVersion) throws ApiException {
        Call call = this.apisPostValidateBeforeCall(body, openAPIVersion, null, null);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisPostAsync(APIDTO body, String openAPIVersion, final ApiCallback<APIDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisPostValidateBeforeCall(body, openAPIVersion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getWSDLOfAPICall(String apiId, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/wsdl".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/wsdl", "application/zip"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWSDLOfAPIValidateBeforeCall(String apiId, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getWSDLOfAPI(Async)");
        }
        Call call = this.getWSDLOfAPICall(apiId, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public void getWSDLOfAPI(String apiId, String ifNoneMatch) throws ApiException {
        this.getWSDLOfAPIWithHttpInfo(apiId, ifNoneMatch);
    }

    public ApiResponse<Void> getWSDLOfAPIWithHttpInfo(String apiId, String ifNoneMatch) throws ApiException {
        Call call = this.getWSDLOfAPIValidateBeforeCall(apiId, ifNoneMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call getWSDLOfAPIAsync(String apiId, String ifNoneMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWSDLOfAPIValidateBeforeCall(apiId, ifNoneMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call importOpenAPIDefinitionCall(File file, String url, String additionalProperties, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/import-openapi";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (url != null) {
            localVarFormParams.put("url", url);
        }
        if (additionalProperties != null) {
            localVarFormParams.put("additionalProperties", additionalProperties);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call importOpenAPIDefinitionValidateBeforeCall(File file, String url, String additionalProperties, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.importOpenAPIDefinitionCall(file, url, additionalProperties, progressListener, progressRequestListener);
        return call;
    }

    public APIDTO importOpenAPIDefinition(File file, String url, String additionalProperties) throws ApiException {
        ApiResponse<APIDTO> resp = this.importOpenAPIDefinitionWithHttpInfo(file, url, additionalProperties);
        return resp.getData();
    }

    public ApiResponse<APIDTO> importOpenAPIDefinitionWithHttpInfo(File file, String url, String additionalProperties) throws ApiException {
        Call call = this.importOpenAPIDefinitionValidateBeforeCall(file, url, additionalProperties, null, null);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call importOpenAPIDefinitionAsync(File file, String url, String additionalProperties, final ApiCallback<APIDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importOpenAPIDefinitionValidateBeforeCall(file, url, additionalProperties, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call importWSDLDefinitionCall(File file, String url, String additionalProperties, String implementationType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/import-wsdl";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (url != null) {
            localVarFormParams.put("url", url);
        }
        if (additionalProperties != null) {
            localVarFormParams.put("additionalProperties", additionalProperties);
        }
        if (implementationType != null) {
            localVarFormParams.put("implementationType", implementationType);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call importWSDLDefinitionValidateBeforeCall(File file, String url, String additionalProperties, String implementationType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.importWSDLDefinitionCall(file, url, additionalProperties, implementationType, progressListener, progressRequestListener);
        return call;
    }

    public APIDTO importWSDLDefinition(File file, String url, String additionalProperties, String implementationType) throws ApiException {
        ApiResponse<APIDTO> resp = this.importWSDLDefinitionWithHttpInfo(file, url, additionalProperties, implementationType);
        return resp.getData();
    }

    public ApiResponse<APIDTO> importWSDLDefinitionWithHttpInfo(File file, String url, String additionalProperties, String implementationType) throws ApiException {
        Call call = this.importWSDLDefinitionValidateBeforeCall(file, url, additionalProperties, implementationType, null, null);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call importWSDLDefinitionAsync(File file, String url, String additionalProperties, String implementationType, final ApiCallback<APIDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importWSDLDefinitionValidateBeforeCall(file, url, additionalProperties, implementationType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAPIThumbnailCall(String apiId, File file, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/thumbnail".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAPIThumbnailValidateBeforeCall(String apiId, File file, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling updateAPIThumbnail(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling updateAPIThumbnail(Async)");
        }
        Call call = this.updateAPIThumbnailCall(apiId, file, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public FileInfoDTO updateAPIThumbnail(String apiId, File file, String ifMatch) throws ApiException {
        ApiResponse<FileInfoDTO> resp = this.updateAPIThumbnailWithHttpInfo(apiId, file, ifMatch);
        return resp.getData();
    }

    public ApiResponse<FileInfoDTO> updateAPIThumbnailWithHttpInfo(String apiId, File file, String ifMatch) throws ApiException {
        Call call = this.updateAPIThumbnailValidateBeforeCall(apiId, file, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<FileInfoDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAPIThumbnailAsync(String apiId, File file, String ifMatch, final ApiCallback<FileInfoDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAPIThumbnailValidateBeforeCall(apiId, file, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileInfoDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateWSDLOfAPICall(String apiId, File file, String url, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/wsdl".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (url != null) {
            localVarFormParams.put("url", url);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateWSDLOfAPIValidateBeforeCall(String apiId, File file, String url, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling updateWSDLOfAPI(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling updateWSDLOfAPI(Async)");
        }
        Call call = this.updateWSDLOfAPICall(apiId, file, url, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public void updateWSDLOfAPI(String apiId, File file, String url, String ifMatch) throws ApiException {
        this.updateWSDLOfAPIWithHttpInfo(apiId, file, url, ifMatch);
    }

    public ApiResponse<Void> updateWSDLOfAPIWithHttpInfo(String apiId, File file, String url, String ifMatch) throws ApiException {
        Call call = this.updateWSDLOfAPIValidateBeforeCall(apiId, file, url, ifMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateWSDLOfAPIAsync(String apiId, File file, String url, String ifMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateWSDLOfAPIValidateBeforeCall(apiId, file, url, ifMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

