/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.ProgressRequestBody;
import org.wso2.am.integration.clients.publisher.api.ProgressResponseBody;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentListDTO;

public class ApiProductDocumentsApi {
    private ApiClient apiClient;

    public ApiProductDocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiProductDocumentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdContentGetCall(String apiProductId, String documentId, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}/content".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdDocumentsDocumentIdContentGetValidateBeforeCall(String apiProductId, String documentId, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdDocumentsDocumentIdContentGet(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apiProductsApiProductIdDocumentsDocumentIdContentGet(Async)");
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdContentGetCall(apiProductId, documentId, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public void apiProductsApiProductIdDocumentsDocumentIdContentGet(String apiProductId, String documentId, String accept, String ifNoneMatch) throws ApiException {
        this.apiProductsApiProductIdDocumentsDocumentIdContentGetWithHttpInfo(apiProductId, documentId, accept, ifNoneMatch);
    }

    public ApiResponse<Void> apiProductsApiProductIdDocumentsDocumentIdContentGetWithHttpInfo(String apiProductId, String documentId, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdContentGetValidateBeforeCall(apiProductId, documentId, accept, ifNoneMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdContentGetAsync(String apiProductId, String documentId, String accept, String ifNoneMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdContentGetValidateBeforeCall(apiProductId, documentId, accept, ifNoneMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdContentPostCall(String apiProductId, String documentId, File file, String inlineContent, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}/content".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (inlineContent != null) {
            localVarFormParams.put("inlineContent", inlineContent);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdDocumentsDocumentIdContentPostValidateBeforeCall(String apiProductId, String documentId, File file, String inlineContent, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdDocumentsDocumentIdContentPost(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apiProductsApiProductIdDocumentsDocumentIdContentPost(Async)");
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdContentPostCall(apiProductId, documentId, file, inlineContent, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public DocumentDTO apiProductsApiProductIdDocumentsDocumentIdContentPost(String apiProductId, String documentId, File file, String inlineContent, String ifMatch) throws ApiException {
        ApiResponse<DocumentDTO> resp = this.apiProductsApiProductIdDocumentsDocumentIdContentPostWithHttpInfo(apiProductId, documentId, file, inlineContent, ifMatch);
        return resp.getData();
    }

    public ApiResponse<DocumentDTO> apiProductsApiProductIdDocumentsDocumentIdContentPostWithHttpInfo(String apiProductId, String documentId, File file, String inlineContent, String ifMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdContentPostValidateBeforeCall(apiProductId, documentId, file, inlineContent, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdContentPostAsync(String apiProductId, String documentId, File file, String inlineContent, String ifMatch, final ApiCallback<DocumentDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdContentPostValidateBeforeCall(apiProductId, documentId, file, inlineContent, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdDeleteCall(String apiProductId, String documentId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdDocumentsDocumentIdDeleteValidateBeforeCall(String apiProductId, String documentId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdDocumentsDocumentIdDelete(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apiProductsApiProductIdDocumentsDocumentIdDelete(Async)");
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdDeleteCall(apiProductId, documentId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public void apiProductsApiProductIdDocumentsDocumentIdDelete(String apiProductId, String documentId, String ifMatch) throws ApiException {
        this.apiProductsApiProductIdDocumentsDocumentIdDeleteWithHttpInfo(apiProductId, documentId, ifMatch);
    }

    public ApiResponse<Void> apiProductsApiProductIdDocumentsDocumentIdDeleteWithHttpInfo(String apiProductId, String documentId, String ifMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdDeleteValidateBeforeCall(apiProductId, documentId, ifMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdDeleteAsync(String apiProductId, String documentId, String ifMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdDeleteValidateBeforeCall(apiProductId, documentId, ifMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdGetCall(String apiProductId, String documentId, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdDocumentsDocumentIdGetValidateBeforeCall(String apiProductId, String documentId, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdDocumentsDocumentIdGet(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apiProductsApiProductIdDocumentsDocumentIdGet(Async)");
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdGetCall(apiProductId, documentId, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public DocumentDTO apiProductsApiProductIdDocumentsDocumentIdGet(String apiProductId, String documentId, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<DocumentDTO> resp = this.apiProductsApiProductIdDocumentsDocumentIdGetWithHttpInfo(apiProductId, documentId, accept, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<DocumentDTO> apiProductsApiProductIdDocumentsDocumentIdGetWithHttpInfo(String apiProductId, String documentId, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdGetValidateBeforeCall(apiProductId, documentId, accept, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdGetAsync(String apiProductId, String documentId, String accept, String ifNoneMatch, final ApiCallback<DocumentDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdGetValidateBeforeCall(apiProductId, documentId, accept, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdPutCall(String apiProductId, String documentId, DocumentDTO body, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DocumentDTO localVarPostBody = body;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdDocumentsDocumentIdPutValidateBeforeCall(String apiProductId, String documentId, DocumentDTO body, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdDocumentsDocumentIdPut(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apiProductsApiProductIdDocumentsDocumentIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apiProductsApiProductIdDocumentsDocumentIdPut(Async)");
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdPutCall(apiProductId, documentId, body, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public DocumentDTO apiProductsApiProductIdDocumentsDocumentIdPut(String apiProductId, String documentId, DocumentDTO body, String ifMatch) throws ApiException {
        ApiResponse<DocumentDTO> resp = this.apiProductsApiProductIdDocumentsDocumentIdPutWithHttpInfo(apiProductId, documentId, body, ifMatch);
        return resp.getData();
    }

    public ApiResponse<DocumentDTO> apiProductsApiProductIdDocumentsDocumentIdPutWithHttpInfo(String apiProductId, String documentId, DocumentDTO body, String ifMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdPutValidateBeforeCall(apiProductId, documentId, body, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsApiProductIdDocumentsDocumentIdPutAsync(String apiProductId, String documentId, DocumentDTO body, String ifMatch, final ApiCallback<DocumentDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdDocumentsDocumentIdPutValidateBeforeCall(apiProductId, documentId, body, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apiProductsApiProductIdDocumentsGetCall(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdDocumentsGetValidateBeforeCall(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdDocumentsGet(Async)");
        }
        Call call = this.apiProductsApiProductIdDocumentsGetCall(apiProductId, limit, offset, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public DocumentListDTO apiProductsApiProductIdDocumentsGet(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<DocumentListDTO> resp = this.apiProductsApiProductIdDocumentsGetWithHttpInfo(apiProductId, limit, offset, accept, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<DocumentListDTO> apiProductsApiProductIdDocumentsGetWithHttpInfo(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdDocumentsGetValidateBeforeCall(apiProductId, limit, offset, accept, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<DocumentListDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsApiProductIdDocumentsGetAsync(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch, final ApiCallback<DocumentListDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdDocumentsGetValidateBeforeCall(apiProductId, limit, offset, accept, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentListDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apiProductsApiProductIdDocumentsPostCall(String apiProductId, DocumentDTO body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DocumentDTO localVarPostBody = body;
        String localVarPath = "/api-products/{apiProductId}/documents".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdDocumentsPostValidateBeforeCall(String apiProductId, DocumentDTO body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdDocumentsPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apiProductsApiProductIdDocumentsPost(Async)");
        }
        Call call = this.apiProductsApiProductIdDocumentsPostCall(apiProductId, body, progressListener, progressRequestListener);
        return call;
    }

    public DocumentDTO apiProductsApiProductIdDocumentsPost(String apiProductId, DocumentDTO body) throws ApiException {
        ApiResponse<DocumentDTO> resp = this.apiProductsApiProductIdDocumentsPostWithHttpInfo(apiProductId, body);
        return resp.getData();
    }

    public ApiResponse<DocumentDTO> apiProductsApiProductIdDocumentsPostWithHttpInfo(String apiProductId, DocumentDTO body) throws ApiException {
        Call call = this.apiProductsApiProductIdDocumentsPostValidateBeforeCall(apiProductId, body, null, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsApiProductIdDocumentsPostAsync(String apiProductId, DocumentDTO body, final ApiCallback<DocumentDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdDocumentsPostValidateBeforeCall(apiProductId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

