/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.ProgressRequestBody;
import org.wso2.am.integration.clients.publisher.api.ProgressResponseBody;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductOutdatedStatusDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.FileInfoDTO;

public class ApiProductsApi {
    private ApiClient apiClient;

    public ApiProductsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiProductsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call apiProductsApiProductIdDeleteCall(String apiProductId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdDeleteValidateBeforeCall(String apiProductId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdDelete(Async)");
        }
        Call call = this.apiProductsApiProductIdDeleteCall(apiProductId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public void apiProductsApiProductIdDelete(String apiProductId, String ifMatch) throws ApiException {
        this.apiProductsApiProductIdDeleteWithHttpInfo(apiProductId, ifMatch);
    }

    public ApiResponse<Void> apiProductsApiProductIdDeleteWithHttpInfo(String apiProductId, String ifMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdDeleteValidateBeforeCall(apiProductId, ifMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call apiProductsApiProductIdDeleteAsync(String apiProductId, String ifMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdDeleteValidateBeforeCall(apiProductId, ifMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apiProductsApiProductIdGetCall(String apiProductId, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdGetValidateBeforeCall(String apiProductId, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdGet(Async)");
        }
        Call call = this.apiProductsApiProductIdGetCall(apiProductId, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public APIProductDTO apiProductsApiProductIdGet(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<APIProductDTO> resp = this.apiProductsApiProductIdGetWithHttpInfo(apiProductId, accept, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<APIProductDTO> apiProductsApiProductIdGetWithHttpInfo(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdGetValidateBeforeCall(apiProductId, accept, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsApiProductIdGetAsync(String apiProductId, String accept, String ifNoneMatch, final ApiCallback<APIProductDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdGetValidateBeforeCall(apiProductId, accept, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apiProductsApiProductIdIsOutdatedGetCall(String apiProductId, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/is-outdated".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdIsOutdatedGetValidateBeforeCall(String apiProductId, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdIsOutdatedGet(Async)");
        }
        Call call = this.apiProductsApiProductIdIsOutdatedGetCall(apiProductId, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public APIProductOutdatedStatusDTO apiProductsApiProductIdIsOutdatedGet(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<APIProductOutdatedStatusDTO> resp = this.apiProductsApiProductIdIsOutdatedGetWithHttpInfo(apiProductId, accept, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<APIProductOutdatedStatusDTO> apiProductsApiProductIdIsOutdatedGetWithHttpInfo(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdIsOutdatedGetValidateBeforeCall(apiProductId, accept, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<APIProductOutdatedStatusDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsApiProductIdIsOutdatedGetAsync(String apiProductId, String accept, String ifNoneMatch, final ApiCallback<APIProductOutdatedStatusDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdIsOutdatedGetValidateBeforeCall(apiProductId, accept, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIProductOutdatedStatusDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apiProductsApiProductIdPutCall(String apiProductId, APIProductDTO body, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        APIProductDTO localVarPostBody = body;
        String localVarPath = "/api-products/{apiProductId}".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdPutValidateBeforeCall(String apiProductId, APIProductDTO body, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apiProductsApiProductIdPut(Async)");
        }
        Call call = this.apiProductsApiProductIdPutCall(apiProductId, body, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public APIProductDTO apiProductsApiProductIdPut(String apiProductId, APIProductDTO body, String ifMatch) throws ApiException {
        ApiResponse<APIProductDTO> resp = this.apiProductsApiProductIdPutWithHttpInfo(apiProductId, body, ifMatch);
        return resp.getData();
    }

    public ApiResponse<APIProductDTO> apiProductsApiProductIdPutWithHttpInfo(String apiProductId, APIProductDTO body, String ifMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdPutValidateBeforeCall(apiProductId, body, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsApiProductIdPutAsync(String apiProductId, APIProductDTO body, String ifMatch, final ApiCallback<APIProductDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdPutValidateBeforeCall(apiProductId, body, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apiProductsApiProductIdSwaggerGetCall(String apiProductId, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/swagger".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdSwaggerGetValidateBeforeCall(String apiProductId, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdSwaggerGet(Async)");
        }
        Call call = this.apiProductsApiProductIdSwaggerGetCall(apiProductId, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public void apiProductsApiProductIdSwaggerGet(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        this.apiProductsApiProductIdSwaggerGetWithHttpInfo(apiProductId, accept, ifNoneMatch);
    }

    public ApiResponse<Void> apiProductsApiProductIdSwaggerGetWithHttpInfo(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdSwaggerGetValidateBeforeCall(apiProductId, accept, ifNoneMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call apiProductsApiProductIdSwaggerGetAsync(String apiProductId, String accept, String ifNoneMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdSwaggerGetValidateBeforeCall(apiProductId, accept, ifNoneMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apiProductsApiProductIdThumbnailGetCall(String apiProductId, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/thumbnail".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdThumbnailGetValidateBeforeCall(String apiProductId, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdThumbnailGet(Async)");
        }
        Call call = this.apiProductsApiProductIdThumbnailGetCall(apiProductId, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public void apiProductsApiProductIdThumbnailGet(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        this.apiProductsApiProductIdThumbnailGetWithHttpInfo(apiProductId, accept, ifNoneMatch);
    }

    public ApiResponse<Void> apiProductsApiProductIdThumbnailGetWithHttpInfo(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdThumbnailGetValidateBeforeCall(apiProductId, accept, ifNoneMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call apiProductsApiProductIdThumbnailGetAsync(String apiProductId, String accept, String ifNoneMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdThumbnailGetValidateBeforeCall(apiProductId, accept, ifNoneMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apiProductsApiProductIdThumbnailPutCall(String apiProductId, File file, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/thumbnail".replaceAll("\\{apiProductId\\}", this.apiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsApiProductIdThumbnailPutValidateBeforeCall(String apiProductId, File file, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling apiProductsApiProductIdThumbnailPut(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling apiProductsApiProductIdThumbnailPut(Async)");
        }
        Call call = this.apiProductsApiProductIdThumbnailPutCall(apiProductId, file, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public FileInfoDTO apiProductsApiProductIdThumbnailPut(String apiProductId, File file, String ifMatch) throws ApiException {
        ApiResponse<FileInfoDTO> resp = this.apiProductsApiProductIdThumbnailPutWithHttpInfo(apiProductId, file, ifMatch);
        return resp.getData();
    }

    public ApiResponse<FileInfoDTO> apiProductsApiProductIdThumbnailPutWithHttpInfo(String apiProductId, File file, String ifMatch) throws ApiException {
        Call call = this.apiProductsApiProductIdThumbnailPutValidateBeforeCall(apiProductId, file, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<FileInfoDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsApiProductIdThumbnailPutAsync(String apiProductId, File file, String ifMatch, final ApiCallback<FileInfoDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsApiProductIdThumbnailPutValidateBeforeCall(apiProductId, file, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileInfoDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apiProductsGetCall(Integer limit, Integer offset, String query, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query", query));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsGetValidateBeforeCall(Integer limit, Integer offset, String query, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.apiProductsGetCall(limit, offset, query, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public APIProductListDTO apiProductsGet(Integer limit, Integer offset, String query, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<APIProductListDTO> resp = this.apiProductsGetWithHttpInfo(limit, offset, query, accept, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<APIProductListDTO> apiProductsGetWithHttpInfo(Integer limit, Integer offset, String query, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.apiProductsGetValidateBeforeCall(limit, offset, query, accept, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<APIProductListDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsGetAsync(Integer limit, Integer offset, String query, String accept, String ifNoneMatch, final ApiCallback<APIProductListDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsGetValidateBeforeCall(limit, offset, query, accept, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIProductListDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apiProductsPostCall(APIProductDTO body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        APIProductDTO localVarPostBody = body;
        String localVarPath = "/api-products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apiProductsPostValidateBeforeCall(APIProductDTO body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apiProductsPost(Async)");
        }
        Call call = this.apiProductsPostCall(body, progressListener, progressRequestListener);
        return call;
    }

    public APIProductDTO apiProductsPost(APIProductDTO body) throws ApiException {
        ApiResponse<APIProductDTO> resp = this.apiProductsPostWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<APIProductDTO> apiProductsPostWithHttpInfo(APIProductDTO body) throws ApiException {
        Call call = this.apiProductsPostValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apiProductsPostAsync(APIProductDTO body, final ApiCallback<APIProductDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apiProductsPostValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

