/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.ProgressRequestBody;
import org.wso2.am.integration.clients.publisher.api.ProgressResponseBody;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ResourcePolicyInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ResourcePolicyListDTO;

public class ApiResourcePoliciesApi {
    private ApiClient apiClient;

    public ApiResourcePoliciesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiResourcePoliciesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call apisApiIdResourcePoliciesGetCall(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/resource-policies".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (resourcePath != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourcePath", resourcePath));
        }
        if (verb != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("verb", verb));
        }
        if (sequenceType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sequenceType", sequenceType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdResourcePoliciesGetValidateBeforeCall(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdResourcePoliciesGet(Async)");
        }
        if (sequenceType == null) {
            throw new ApiException("Missing the required parameter 'sequenceType' when calling apisApiIdResourcePoliciesGet(Async)");
        }
        Call call = this.apisApiIdResourcePoliciesGetCall(apiId, sequenceType, resourcePath, verb, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public ResourcePolicyListDTO apisApiIdResourcePoliciesGet(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch) throws ApiException {
        ApiResponse<ResourcePolicyListDTO> resp = this.apisApiIdResourcePoliciesGetWithHttpInfo(apiId, sequenceType, resourcePath, verb, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<ResourcePolicyListDTO> apisApiIdResourcePoliciesGetWithHttpInfo(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch) throws ApiException {
        Call call = this.apisApiIdResourcePoliciesGetValidateBeforeCall(apiId, sequenceType, resourcePath, verb, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<ResourcePolicyListDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdResourcePoliciesGetAsync(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch, final ApiCallback<ResourcePolicyListDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdResourcePoliciesGetValidateBeforeCall(apiId, sequenceType, resourcePath, verb, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourcePolicyListDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdResourcePoliciesResourcePolicyIdGetCall(String apiId, String resourcePolicyId, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/resource-policies/{resourcePolicyId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString())).replaceAll("\\{resourcePolicyId\\}", this.apiClient.escapeString(resourcePolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdResourcePoliciesResourcePolicyIdGetValidateBeforeCall(String apiId, String resourcePolicyId, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdResourcePoliciesResourcePolicyIdGet(Async)");
        }
        if (resourcePolicyId == null) {
            throw new ApiException("Missing the required parameter 'resourcePolicyId' when calling apisApiIdResourcePoliciesResourcePolicyIdGet(Async)");
        }
        Call call = this.apisApiIdResourcePoliciesResourcePolicyIdGetCall(apiId, resourcePolicyId, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public ResourcePolicyInfoDTO apisApiIdResourcePoliciesResourcePolicyIdGet(String apiId, String resourcePolicyId, String ifNoneMatch) throws ApiException {
        ApiResponse<ResourcePolicyInfoDTO> resp = this.apisApiIdResourcePoliciesResourcePolicyIdGetWithHttpInfo(apiId, resourcePolicyId, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<ResourcePolicyInfoDTO> apisApiIdResourcePoliciesResourcePolicyIdGetWithHttpInfo(String apiId, String resourcePolicyId, String ifNoneMatch) throws ApiException {
        Call call = this.apisApiIdResourcePoliciesResourcePolicyIdGetValidateBeforeCall(apiId, resourcePolicyId, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<ResourcePolicyInfoDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdResourcePoliciesResourcePolicyIdGetAsync(String apiId, String resourcePolicyId, String ifNoneMatch, final ApiCallback<ResourcePolicyInfoDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdResourcePoliciesResourcePolicyIdGetValidateBeforeCall(apiId, resourcePolicyId, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourcePolicyInfoDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdResourcePoliciesResourcePolicyIdPutCall(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO body, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ResourcePolicyInfoDTO localVarPostBody = body;
        String localVarPath = "/apis/{apiId}/resource-policies/{resourcePolicyId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString())).replaceAll("\\{resourcePolicyId\\}", this.apiClient.escapeString(resourcePolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdResourcePoliciesResourcePolicyIdPutValidateBeforeCall(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO body, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdResourcePoliciesResourcePolicyIdPut(Async)");
        }
        if (resourcePolicyId == null) {
            throw new ApiException("Missing the required parameter 'resourcePolicyId' when calling apisApiIdResourcePoliciesResourcePolicyIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apisApiIdResourcePoliciesResourcePolicyIdPut(Async)");
        }
        Call call = this.apisApiIdResourcePoliciesResourcePolicyIdPutCall(apiId, resourcePolicyId, body, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public ResourcePolicyInfoDTO apisApiIdResourcePoliciesResourcePolicyIdPut(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO body, String ifMatch) throws ApiException {
        ApiResponse<ResourcePolicyInfoDTO> resp = this.apisApiIdResourcePoliciesResourcePolicyIdPutWithHttpInfo(apiId, resourcePolicyId, body, ifMatch);
        return resp.getData();
    }

    public ApiResponse<ResourcePolicyInfoDTO> apisApiIdResourcePoliciesResourcePolicyIdPutWithHttpInfo(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO body, String ifMatch) throws ApiException {
        Call call = this.apisApiIdResourcePoliciesResourcePolicyIdPutValidateBeforeCall(apiId, resourcePolicyId, body, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<ResourcePolicyInfoDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdResourcePoliciesResourcePolicyIdPutAsync(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO body, String ifMatch, final ApiCallback<ResourcePolicyInfoDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdResourcePoliciesResourcePolicyIdPutValidateBeforeCall(apiId, resourcePolicyId, body, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourcePolicyInfoDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

