/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.ProgressRequestBody;
import org.wso2.am.integration.clients.publisher.api.ProgressResponseBody;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertificateInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ClientCertMetadataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ClientCertificatesDTO;

public class ClientCertificatesApi {
    private ApiClient apiClient;

    public ClientCertificatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ClientCertificatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call apisApiIdClientCertificatesAliasContentGetCall(String apiId, String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates/{alias}/content".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString())).replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdClientCertificatesAliasContentGetValidateBeforeCall(String apiId, String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdClientCertificatesAliasContentGet(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling apisApiIdClientCertificatesAliasContentGet(Async)");
        }
        Call call = this.apisApiIdClientCertificatesAliasContentGetCall(apiId, alias, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdClientCertificatesAliasContentGet(String apiId, String alias) throws ApiException {
        this.apisApiIdClientCertificatesAliasContentGetWithHttpInfo(apiId, alias);
    }

    public ApiResponse<Void> apisApiIdClientCertificatesAliasContentGetWithHttpInfo(String apiId, String alias) throws ApiException {
        Call call = this.apisApiIdClientCertificatesAliasContentGetValidateBeforeCall(apiId, alias, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdClientCertificatesAliasContentGetAsync(String apiId, String alias, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdClientCertificatesAliasContentGetValidateBeforeCall(apiId, alias, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdClientCertificatesAliasDeleteCall(String alias, String apiId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates/{alias}".replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString())).replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdClientCertificatesAliasDeleteValidateBeforeCall(String alias, String apiId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling apisApiIdClientCertificatesAliasDelete(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdClientCertificatesAliasDelete(Async)");
        }
        Call call = this.apisApiIdClientCertificatesAliasDeleteCall(alias, apiId, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdClientCertificatesAliasDelete(String alias, String apiId) throws ApiException {
        this.apisApiIdClientCertificatesAliasDeleteWithHttpInfo(alias, apiId);
    }

    public ApiResponse<Void> apisApiIdClientCertificatesAliasDeleteWithHttpInfo(String alias, String apiId) throws ApiException {
        Call call = this.apisApiIdClientCertificatesAliasDeleteValidateBeforeCall(alias, apiId, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdClientCertificatesAliasDeleteAsync(String alias, String apiId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdClientCertificatesAliasDeleteValidateBeforeCall(alias, apiId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdClientCertificatesAliasGetCall(String alias, String apiId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates/{alias}".replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString())).replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdClientCertificatesAliasGetValidateBeforeCall(String alias, String apiId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling apisApiIdClientCertificatesAliasGet(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdClientCertificatesAliasGet(Async)");
        }
        Call call = this.apisApiIdClientCertificatesAliasGetCall(alias, apiId, progressListener, progressRequestListener);
        return call;
    }

    public CertificateInfoDTO apisApiIdClientCertificatesAliasGet(String alias, String apiId) throws ApiException {
        ApiResponse<CertificateInfoDTO> resp = this.apisApiIdClientCertificatesAliasGetWithHttpInfo(alias, apiId);
        return resp.getData();
    }

    public ApiResponse<CertificateInfoDTO> apisApiIdClientCertificatesAliasGetWithHttpInfo(String alias, String apiId) throws ApiException {
        Call call = this.apisApiIdClientCertificatesAliasGetValidateBeforeCall(alias, apiId, null, null);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdClientCertificatesAliasGetAsync(String alias, String apiId, final ApiCallback<CertificateInfoDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdClientCertificatesAliasGetValidateBeforeCall(alias, apiId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdClientCertificatesAliasPutCall(String alias, String apiId, File certificate, String tier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates/{alias}".replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString())).replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if (tier != null) {
            localVarFormParams.put("tier", tier);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdClientCertificatesAliasPutValidateBeforeCall(String alias, String apiId, File certificate, String tier, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling apisApiIdClientCertificatesAliasPut(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdClientCertificatesAliasPut(Async)");
        }
        Call call = this.apisApiIdClientCertificatesAliasPutCall(alias, apiId, certificate, tier, progressListener, progressRequestListener);
        return call;
    }

    public ClientCertMetadataDTO apisApiIdClientCertificatesAliasPut(String alias, String apiId, File certificate, String tier) throws ApiException {
        ApiResponse<ClientCertMetadataDTO> resp = this.apisApiIdClientCertificatesAliasPutWithHttpInfo(alias, apiId, certificate, tier);
        return resp.getData();
    }

    public ApiResponse<ClientCertMetadataDTO> apisApiIdClientCertificatesAliasPutWithHttpInfo(String alias, String apiId, File certificate, String tier) throws ApiException {
        Call call = this.apisApiIdClientCertificatesAliasPutValidateBeforeCall(alias, apiId, certificate, tier, null, null);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdClientCertificatesAliasPutAsync(String alias, String apiId, File certificate, String tier, final ApiCallback<ClientCertMetadataDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdClientCertificatesAliasPutValidateBeforeCall(alias, apiId, certificate, tier, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdClientCertificatesGetCall(String apiId, Integer limit, Integer offset, String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (alias != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("alias", alias));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdClientCertificatesGetValidateBeforeCall(String apiId, Integer limit, Integer offset, String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdClientCertificatesGet(Async)");
        }
        Call call = this.apisApiIdClientCertificatesGetCall(apiId, limit, offset, alias, progressListener, progressRequestListener);
        return call;
    }

    public ClientCertificatesDTO apisApiIdClientCertificatesGet(String apiId, Integer limit, Integer offset, String alias) throws ApiException {
        ApiResponse<ClientCertificatesDTO> resp = this.apisApiIdClientCertificatesGetWithHttpInfo(apiId, limit, offset, alias);
        return resp.getData();
    }

    public ApiResponse<ClientCertificatesDTO> apisApiIdClientCertificatesGetWithHttpInfo(String apiId, Integer limit, Integer offset, String alias) throws ApiException {
        Call call = this.apisApiIdClientCertificatesGetValidateBeforeCall(apiId, limit, offset, alias, null, null);
        Type localVarReturnType = new TypeToken<ClientCertificatesDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdClientCertificatesGetAsync(String apiId, Integer limit, Integer offset, String alias, final ApiCallback<ClientCertificatesDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdClientCertificatesGetValidateBeforeCall(apiId, limit, offset, alias, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ClientCertificatesDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdClientCertificatesPostCall(File certificate, String alias, String apiId, String tier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if (alias != null) {
            localVarFormParams.put("alias", alias);
        }
        if (tier != null) {
            localVarFormParams.put("tier", tier);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdClientCertificatesPostValidateBeforeCall(File certificate, String alias, String apiId, String tier, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (certificate == null) {
            throw new ApiException("Missing the required parameter 'certificate' when calling apisApiIdClientCertificatesPost(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling apisApiIdClientCertificatesPost(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdClientCertificatesPost(Async)");
        }
        if (tier == null) {
            throw new ApiException("Missing the required parameter 'tier' when calling apisApiIdClientCertificatesPost(Async)");
        }
        Call call = this.apisApiIdClientCertificatesPostCall(certificate, alias, apiId, tier, progressListener, progressRequestListener);
        return call;
    }

    public ClientCertMetadataDTO apisApiIdClientCertificatesPost(File certificate, String alias, String apiId, String tier) throws ApiException {
        ApiResponse<ClientCertMetadataDTO> resp = this.apisApiIdClientCertificatesPostWithHttpInfo(certificate, alias, apiId, tier);
        return resp.getData();
    }

    public ApiResponse<ClientCertMetadataDTO> apisApiIdClientCertificatesPostWithHttpInfo(File certificate, String alias, String apiId, String tier) throws ApiException {
        Call call = this.apisApiIdClientCertificatesPostValidateBeforeCall(certificate, alias, apiId, tier, null, null);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdClientCertificatesPostAsync(File certificate, String alias, String apiId, String tier, final ApiCallback<ClientCertMetadataDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdClientCertificatesPostValidateBeforeCall(certificate, alias, apiId, tier, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

