/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.ProgressRequestBody;
import org.wso2.am.integration.clients.publisher.api.ProgressResponseBody;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertMetadataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertificateInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertificatesDTO;

public class EndpointCertificatesApi {
    private ApiClient apiClient;

    public EndpointCertificatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EndpointCertificatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call endpointCertificatesAliasContentGetCall(String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates/{alias}/content".replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointCertificatesAliasContentGetValidateBeforeCall(String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling endpointCertificatesAliasContentGet(Async)");
        }
        Call call = this.endpointCertificatesAliasContentGetCall(alias, progressListener, progressRequestListener);
        return call;
    }

    public void endpointCertificatesAliasContentGet(String alias) throws ApiException {
        this.endpointCertificatesAliasContentGetWithHttpInfo(alias);
    }

    public ApiResponse<Void> endpointCertificatesAliasContentGetWithHttpInfo(String alias) throws ApiException {
        Call call = this.endpointCertificatesAliasContentGetValidateBeforeCall(alias, null, null);
        return this.apiClient.execute(call);
    }

    public Call endpointCertificatesAliasContentGetAsync(String alias, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointCertificatesAliasContentGetValidateBeforeCall(alias, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call endpointCertificatesAliasDeleteCall(String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates/{alias}".replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointCertificatesAliasDeleteValidateBeforeCall(String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling endpointCertificatesAliasDelete(Async)");
        }
        Call call = this.endpointCertificatesAliasDeleteCall(alias, progressListener, progressRequestListener);
        return call;
    }

    public void endpointCertificatesAliasDelete(String alias) throws ApiException {
        this.endpointCertificatesAliasDeleteWithHttpInfo(alias);
    }

    public ApiResponse<Void> endpointCertificatesAliasDeleteWithHttpInfo(String alias) throws ApiException {
        Call call = this.endpointCertificatesAliasDeleteValidateBeforeCall(alias, null, null);
        return this.apiClient.execute(call);
    }

    public Call endpointCertificatesAliasDeleteAsync(String alias, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointCertificatesAliasDeleteValidateBeforeCall(alias, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call endpointCertificatesAliasGetCall(String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates/{alias}".replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointCertificatesAliasGetValidateBeforeCall(String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling endpointCertificatesAliasGet(Async)");
        }
        Call call = this.endpointCertificatesAliasGetCall(alias, progressListener, progressRequestListener);
        return call;
    }

    public CertificateInfoDTO endpointCertificatesAliasGet(String alias) throws ApiException {
        ApiResponse<CertificateInfoDTO> resp = this.endpointCertificatesAliasGetWithHttpInfo(alias);
        return resp.getData();
    }

    public ApiResponse<CertificateInfoDTO> endpointCertificatesAliasGetWithHttpInfo(String alias) throws ApiException {
        Call call = this.endpointCertificatesAliasGetValidateBeforeCall(alias, null, null);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call endpointCertificatesAliasGetAsync(String alias, final ApiCallback<CertificateInfoDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointCertificatesAliasGetValidateBeforeCall(alias, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call endpointCertificatesAliasPutCall(File certificate, String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates/{alias}".replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointCertificatesAliasPutValidateBeforeCall(File certificate, String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (certificate == null) {
            throw new ApiException("Missing the required parameter 'certificate' when calling endpointCertificatesAliasPut(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling endpointCertificatesAliasPut(Async)");
        }
        Call call = this.endpointCertificatesAliasPutCall(certificate, alias, progressListener, progressRequestListener);
        return call;
    }

    public CertMetadataDTO endpointCertificatesAliasPut(File certificate, String alias) throws ApiException {
        ApiResponse<CertMetadataDTO> resp = this.endpointCertificatesAliasPutWithHttpInfo(certificate, alias);
        return resp.getData();
    }

    public ApiResponse<CertMetadataDTO> endpointCertificatesAliasPutWithHttpInfo(File certificate, String alias) throws ApiException {
        Call call = this.endpointCertificatesAliasPutValidateBeforeCall(certificate, alias, null, null);
        Type localVarReturnType = new TypeToken<CertMetadataDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call endpointCertificatesAliasPutAsync(File certificate, String alias, final ApiCallback<CertMetadataDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointCertificatesAliasPutValidateBeforeCall(certificate, alias, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CertMetadataDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call endpointCertificatesGetCall(Integer limit, Integer offset, String alias, String endpoint, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (alias != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("alias", alias));
        }
        if (endpoint != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endpoint", endpoint));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointCertificatesGetValidateBeforeCall(Integer limit, Integer offset, String alias, String endpoint, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.endpointCertificatesGetCall(limit, offset, alias, endpoint, progressListener, progressRequestListener);
        return call;
    }

    public CertificatesDTO endpointCertificatesGet(Integer limit, Integer offset, String alias, String endpoint) throws ApiException {
        ApiResponse<CertificatesDTO> resp = this.endpointCertificatesGetWithHttpInfo(limit, offset, alias, endpoint);
        return resp.getData();
    }

    public ApiResponse<CertificatesDTO> endpointCertificatesGetWithHttpInfo(Integer limit, Integer offset, String alias, String endpoint) throws ApiException {
        Call call = this.endpointCertificatesGetValidateBeforeCall(limit, offset, alias, endpoint, null, null);
        Type localVarReturnType = new TypeToken<CertificatesDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call endpointCertificatesGetAsync(Integer limit, Integer offset, String alias, String endpoint, final ApiCallback<CertificatesDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointCertificatesGetValidateBeforeCall(limit, offset, alias, endpoint, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CertificatesDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call endpointCertificatesPostCall(File certificate, String alias, String endpoint, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if (alias != null) {
            localVarFormParams.put("alias", alias);
        }
        if (endpoint != null) {
            localVarFormParams.put("endpoint", endpoint);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointCertificatesPostValidateBeforeCall(File certificate, String alias, String endpoint, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (certificate == null) {
            throw new ApiException("Missing the required parameter 'certificate' when calling endpointCertificatesPost(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling endpointCertificatesPost(Async)");
        }
        if (endpoint == null) {
            throw new ApiException("Missing the required parameter 'endpoint' when calling endpointCertificatesPost(Async)");
        }
        Call call = this.endpointCertificatesPostCall(certificate, alias, endpoint, progressListener, progressRequestListener);
        return call;
    }

    public CertMetadataDTO endpointCertificatesPost(File certificate, String alias, String endpoint) throws ApiException {
        ApiResponse<CertMetadataDTO> resp = this.endpointCertificatesPostWithHttpInfo(certificate, alias, endpoint);
        return resp.getData();
    }

    public ApiResponse<CertMetadataDTO> endpointCertificatesPostWithHttpInfo(File certificate, String alias, String endpoint) throws ApiException {
        Call call = this.endpointCertificatesPostValidateBeforeCall(certificate, alias, endpoint, null, null);
        Type localVarReturnType = new TypeToken<CertMetadataDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call endpointCertificatesPostAsync(File certificate, String alias, String endpoint, final ApiCallback<CertMetadataDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointCertificatesPostValidateBeforeCall(certificate, alias, endpoint, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CertMetadataDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

