/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APICorsConfigurationDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIMonetizationInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductBusinessInformationDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ProductAPIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;

public class APIProductDTO {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="context")
    private String context = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="provider")
    private String provider = null;
    @SerializedName(value="hasThumbnail")
    private Boolean hasThumbnail = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="enableSchemaValidation")
    private Boolean enableSchemaValidation = null;
    @SerializedName(value="responseCachingEnabled")
    private Boolean responseCachingEnabled = null;
    @SerializedName(value="cacheTimeout")
    private Integer cacheTimeout = null;
    @SerializedName(value="visibility")
    private VisibilityEnum visibility = VisibilityEnum.PUBLIC;
    @SerializedName(value="visibleRoles")
    private List<String> visibleRoles = null;
    @SerializedName(value="visibleTenants")
    private List<String> visibleTenants = null;
    @SerializedName(value="accessControl")
    private AccessControlEnum accessControl = AccessControlEnum.NONE;
    @SerializedName(value="accessControlRoles")
    private List<String> accessControlRoles = null;
    @SerializedName(value="gatewayEnvironments")
    private List<String> gatewayEnvironments = null;
    @SerializedName(value="apiType")
    private String apiType = null;
    @SerializedName(value="transport")
    private List<String> transport = null;
    @SerializedName(value="tags")
    private List<String> tags = null;
    @SerializedName(value="policies")
    private List<String> policies = null;
    @SerializedName(value="apiThrottlingPolicy")
    private String apiThrottlingPolicy = null;
    @SerializedName(value="authorizationHeader")
    private String authorizationHeader = null;
    @SerializedName(value="securityScheme")
    private List<String> securityScheme = null;
    @SerializedName(value="subscriptionAvailability")
    private SubscriptionAvailabilityEnum subscriptionAvailability = null;
    @SerializedName(value="subscriptionAvailableTenants")
    private List<String> subscriptionAvailableTenants = null;
    @SerializedName(value="additionalProperties")
    private Map<String, String> additionalProperties = null;
    @SerializedName(value="monetization")
    private APIMonetizationInfoDTO monetization = null;
    @SerializedName(value="businessInformation")
    private APIProductBusinessInformationDTO businessInformation = null;
    @SerializedName(value="corsConfiguration")
    private APICorsConfigurationDTO corsConfiguration = null;
    @SerializedName(value="createdTime")
    private String createdTime = null;
    @SerializedName(value="lastUpdatedTime")
    private String lastUpdatedTime = null;
    @SerializedName(value="apis")
    private List<ProductAPIDTO> apis = null;
    @SerializedName(value="scopes")
    private List<ScopeDTO> scopes = null;

    public APIProductDTO id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="UUID of the api product ")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public APIProductDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="CalculatorAPIProduct", required=true, value="Name of the API Product")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public APIProductDTO context(String context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="CalculatorAPI", value="")
    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public APIProductDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="A calculator API Product that supports basic operations", value="A brief description about the API")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public APIProductDTO provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="admin", value="If the provider value is not given, the user invoking the API will be used as the provider. ")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public APIProductDTO hasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
        return this;
    }

    @ApiModelProperty(example="true", value="")
    public Boolean isHasThumbnail() {
        return this.hasThumbnail;
    }

    public void setHasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
    }

    public APIProductDTO state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="State of the API product. Only published api products are visible on the store ")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public APIProductDTO enableSchemaValidation(Boolean enableSchemaValidation) {
        this.enableSchemaValidation = enableSchemaValidation;
        return this;
    }

    @ApiModelProperty(example="false", value="")
    public Boolean isEnableSchemaValidation() {
        return this.enableSchemaValidation;
    }

    public void setEnableSchemaValidation(Boolean enableSchemaValidation) {
        this.enableSchemaValidation = enableSchemaValidation;
    }

    public APIProductDTO responseCachingEnabled(Boolean responseCachingEnabled) {
        this.responseCachingEnabled = responseCachingEnabled;
        return this;
    }

    @ApiModelProperty(example="true", value="")
    public Boolean isResponseCachingEnabled() {
        return this.responseCachingEnabled;
    }

    public void setResponseCachingEnabled(Boolean responseCachingEnabled) {
        this.responseCachingEnabled = responseCachingEnabled;
    }

    public APIProductDTO cacheTimeout(Integer cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
        return this;
    }

    @ApiModelProperty(example="300", value="")
    public Integer getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(Integer cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public APIProductDTO visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(example="PUBLIC", value="The visibility level of the API. Accepts one of the following. PUBLIC, PRIVATE, RESTRICTED.")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public APIProductDTO visibleRoles(List<String> visibleRoles) {
        this.visibleRoles = visibleRoles;
        return this;
    }

    public APIProductDTO addVisibleRolesItem(String visibleRolesItem) {
        if (this.visibleRoles == null) {
            this.visibleRoles = new ArrayList<String>();
        }
        this.visibleRoles.add(visibleRolesItem);
        return this;
    }

    @ApiModelProperty(example="[]", value="The user roles that are able to access the API")
    public List<String> getVisibleRoles() {
        return this.visibleRoles;
    }

    public void setVisibleRoles(List<String> visibleRoles) {
        this.visibleRoles = visibleRoles;
    }

    public APIProductDTO visibleTenants(List<String> visibleTenants) {
        this.visibleTenants = visibleTenants;
        return this;
    }

    public APIProductDTO addVisibleTenantsItem(String visibleTenantsItem) {
        if (this.visibleTenants == null) {
            this.visibleTenants = new ArrayList<String>();
        }
        this.visibleTenants.add(visibleTenantsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getVisibleTenants() {
        return this.visibleTenants;
    }

    public void setVisibleTenants(List<String> visibleTenants) {
        this.visibleTenants = visibleTenants;
    }

    public APIProductDTO accessControl(AccessControlEnum accessControl) {
        this.accessControl = accessControl;
        return this;
    }

    @ApiModelProperty(value="Defines whether the API Product is restricted to certain set of publishers or creators or is it visible to all the publishers and creators. If the accessControl restriction is none, this API Product can be modified by all the publishers and creators, if not it can only be viewable/modifiable by certain set of publishers and creators, based on the restriction. ")
    public AccessControlEnum getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(AccessControlEnum accessControl) {
        this.accessControl = accessControl;
    }

    public APIProductDTO accessControlRoles(List<String> accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
        return this;
    }

    public APIProductDTO addAccessControlRolesItem(String accessControlRolesItem) {
        if (this.accessControlRoles == null) {
            this.accessControlRoles = new ArrayList<String>();
        }
        this.accessControlRoles.add(accessControlRolesItem);
        return this;
    }

    @ApiModelProperty(example="[\"admin\"]", value="The user roles that are able to view/modify as API Product publisher or creator.")
    public List<String> getAccessControlRoles() {
        return this.accessControlRoles;
    }

    public void setAccessControlRoles(List<String> accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
    }

    public APIProductDTO gatewayEnvironments(List<String> gatewayEnvironments) {
        this.gatewayEnvironments = gatewayEnvironments;
        return this;
    }

    public APIProductDTO addGatewayEnvironmentsItem(String gatewayEnvironmentsItem) {
        if (this.gatewayEnvironments == null) {
            this.gatewayEnvironments = new ArrayList<String>();
        }
        this.gatewayEnvironments.add(gatewayEnvironmentsItem);
        return this;
    }

    @ApiModelProperty(example="[\"Production and Sandbox\"]", value="List of gateway environments the API Product is available ")
    public List<String> getGatewayEnvironments() {
        return this.gatewayEnvironments;
    }

    public void setGatewayEnvironments(List<String> gatewayEnvironments) {
        this.gatewayEnvironments = gatewayEnvironments;
    }

    public APIProductDTO apiType(String apiType) {
        this.apiType = apiType;
        return this;
    }

    @ApiModelProperty(example="APIProduct", value="The api type to be used. Accepted values are API, API PRODUCT")
    public String getApiType() {
        return this.apiType;
    }

    public void setApiType(String apiType) {
        this.apiType = apiType;
    }

    public APIProductDTO transport(List<String> transport) {
        this.transport = transport;
        return this;
    }

    public APIProductDTO addTransportItem(String transportItem) {
        if (this.transport == null) {
            this.transport = new ArrayList<String>();
        }
        this.transport.add(transportItem);
        return this;
    }

    @ApiModelProperty(example="[\"http\",\"https\"]", value="Supported transports for the API (http and/or https). ")
    public List<String> getTransport() {
        return this.transport;
    }

    public void setTransport(List<String> transport) {
        this.transport = transport;
    }

    public APIProductDTO tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public APIProductDTO addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[\"substract\",\"add\"]", value="")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public APIProductDTO policies(List<String> policies) {
        this.policies = policies;
        return this;
    }

    public APIProductDTO addPoliciesItem(String policiesItem) {
        if (this.policies == null) {
            this.policies = new ArrayList<String>();
        }
        this.policies.add(policiesItem);
        return this;
    }

    @ApiModelProperty(example="[\"Unlimited\"]", value="")
    public List<String> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<String> policies) {
        this.policies = policies;
    }

    public APIProductDTO apiThrottlingPolicy(String apiThrottlingPolicy) {
        this.apiThrottlingPolicy = apiThrottlingPolicy;
        return this;
    }

    @ApiModelProperty(example="Unlimited", value="The API level throttling policy selected for the particular API Product")
    public String getApiThrottlingPolicy() {
        return this.apiThrottlingPolicy;
    }

    public void setApiThrottlingPolicy(String apiThrottlingPolicy) {
        this.apiThrottlingPolicy = apiThrottlingPolicy;
    }

    public APIProductDTO authorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
        return this;
    }

    @ApiModelProperty(value="Name of the Authorization header used for invoking the API. If it is not set, Authorization header name specified in tenant or system level will be used. ")
    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public APIProductDTO securityScheme(List<String> securityScheme) {
        this.securityScheme = securityScheme;
        return this;
    }

    public APIProductDTO addSecuritySchemeItem(String securitySchemeItem) {
        if (this.securityScheme == null) {
            this.securityScheme = new ArrayList<String>();
        }
        this.securityScheme.add(securitySchemeItem);
        return this;
    }

    @ApiModelProperty(value="Types of API security, the current API secured with. It can be either OAuth2 or mutual SSL or both. If it is not set OAuth2 will be set as the security for the current API. ")
    public List<String> getSecurityScheme() {
        return this.securityScheme;
    }

    public void setSecurityScheme(List<String> securityScheme) {
        this.securityScheme = securityScheme;
    }

    public APIProductDTO subscriptionAvailability(SubscriptionAvailabilityEnum subscriptionAvailability) {
        this.subscriptionAvailability = subscriptionAvailability;
        return this;
    }

    @ApiModelProperty(example="CURRENT_TENANT", value="The subscription availability. Accepts one of the following. CURRENT_TENANT, ALL_TENANTS or SPECIFIC_TENANTS.")
    public SubscriptionAvailabilityEnum getSubscriptionAvailability() {
        return this.subscriptionAvailability;
    }

    public void setSubscriptionAvailability(SubscriptionAvailabilityEnum subscriptionAvailability) {
        this.subscriptionAvailability = subscriptionAvailability;
    }

    public APIProductDTO subscriptionAvailableTenants(List<String> subscriptionAvailableTenants) {
        this.subscriptionAvailableTenants = subscriptionAvailableTenants;
        return this;
    }

    public APIProductDTO addSubscriptionAvailableTenantsItem(String subscriptionAvailableTenantsItem) {
        if (this.subscriptionAvailableTenants == null) {
            this.subscriptionAvailableTenants = new ArrayList<String>();
        }
        this.subscriptionAvailableTenants.add(subscriptionAvailableTenantsItem);
        return this;
    }

    @ApiModelProperty(example="[\"tenant1\",\"tenant2\"]", value="")
    public List<String> getSubscriptionAvailableTenants() {
        return this.subscriptionAvailableTenants;
    }

    public void setSubscriptionAvailableTenants(List<String> subscriptionAvailableTenants) {
        this.subscriptionAvailableTenants = subscriptionAvailableTenants;
    }

    public APIProductDTO additionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public APIProductDTO putAdditionalPropertiesItem(String key, String additionalPropertiesItem) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, String>();
        }
        this.additionalProperties.put(key, additionalPropertiesItem);
        return this;
    }

    @ApiModelProperty(value="Map of custom properties of API")
    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public APIProductDTO monetization(APIMonetizationInfoDTO monetization) {
        this.monetization = monetization;
        return this;
    }

    @ApiModelProperty(value="")
    public APIMonetizationInfoDTO getMonetization() {
        return this.monetization;
    }

    public void setMonetization(APIMonetizationInfoDTO monetization) {
        this.monetization = monetization;
    }

    public APIProductDTO businessInformation(APIProductBusinessInformationDTO businessInformation) {
        this.businessInformation = businessInformation;
        return this;
    }

    @ApiModelProperty(value="")
    public APIProductBusinessInformationDTO getBusinessInformation() {
        return this.businessInformation;
    }

    public void setBusinessInformation(APIProductBusinessInformationDTO businessInformation) {
        this.businessInformation = businessInformation;
    }

    public APIProductDTO corsConfiguration(APICorsConfigurationDTO corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    public APICorsConfigurationDTO getCorsConfiguration() {
        return this.corsConfiguration;
    }

    public void setCorsConfiguration(APICorsConfigurationDTO corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public APIProductDTO createdTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @ApiModelProperty(example="2017-02-20T13:57:16.229+0000", value="")
    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public APIProductDTO lastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @ApiModelProperty(example="2017-02-20T13:57:16.229+0000", value="")
    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public APIProductDTO apis(List<ProductAPIDTO> apis) {
        this.apis = apis;
        return this;
    }

    public APIProductDTO addApisItem(ProductAPIDTO apisItem) {
        if (this.apis == null) {
            this.apis = new ArrayList<ProductAPIDTO>();
        }
        this.apis.add(apisItem);
        return this;
    }

    @ApiModelProperty(value="APIs and resources in the API Product. ")
    public List<ProductAPIDTO> getApis() {
        return this.apis;
    }

    public void setApis(List<ProductAPIDTO> apis) {
        this.apis = apis;
    }

    public APIProductDTO scopes(List<ScopeDTO> scopes) {
        this.scopes = scopes;
        return this;
    }

    public APIProductDTO addScopesItem(ScopeDTO scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<ScopeDTO>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ScopeDTO> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<ScopeDTO> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIProductDTO apIProduct = (APIProductDTO)o;
        return Objects.equals(this.id, apIProduct.id) && Objects.equals(this.name, apIProduct.name) && Objects.equals(this.context, apIProduct.context) && Objects.equals(this.description, apIProduct.description) && Objects.equals(this.provider, apIProduct.provider) && Objects.equals(this.hasThumbnail, apIProduct.hasThumbnail) && Objects.equals((Object)this.state, (Object)apIProduct.state) && Objects.equals(this.enableSchemaValidation, apIProduct.enableSchemaValidation) && Objects.equals(this.responseCachingEnabled, apIProduct.responseCachingEnabled) && Objects.equals(this.cacheTimeout, apIProduct.cacheTimeout) && Objects.equals((Object)this.visibility, (Object)apIProduct.visibility) && Objects.equals(this.visibleRoles, apIProduct.visibleRoles) && Objects.equals(this.visibleTenants, apIProduct.visibleTenants) && Objects.equals((Object)this.accessControl, (Object)apIProduct.accessControl) && Objects.equals(this.accessControlRoles, apIProduct.accessControlRoles) && Objects.equals(this.gatewayEnvironments, apIProduct.gatewayEnvironments) && Objects.equals(this.apiType, apIProduct.apiType) && Objects.equals(this.transport, apIProduct.transport) && Objects.equals(this.tags, apIProduct.tags) && Objects.equals(this.policies, apIProduct.policies) && Objects.equals(this.apiThrottlingPolicy, apIProduct.apiThrottlingPolicy) && Objects.equals(this.authorizationHeader, apIProduct.authorizationHeader) && Objects.equals(this.securityScheme, apIProduct.securityScheme) && Objects.equals((Object)this.subscriptionAvailability, (Object)apIProduct.subscriptionAvailability) && Objects.equals(this.subscriptionAvailableTenants, apIProduct.subscriptionAvailableTenants) && Objects.equals(this.additionalProperties, apIProduct.additionalProperties) && Objects.equals(this.monetization, apIProduct.monetization) && Objects.equals(this.businessInformation, apIProduct.businessInformation) && Objects.equals(this.corsConfiguration, apIProduct.corsConfiguration) && Objects.equals(this.createdTime, apIProduct.createdTime) && Objects.equals(this.lastUpdatedTime, apIProduct.lastUpdatedTime) && Objects.equals(this.apis, apIProduct.apis) && Objects.equals(this.scopes, apIProduct.scopes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.context, this.description, this.provider, this.hasThumbnail, this.state, this.enableSchemaValidation, this.responseCachingEnabled, this.cacheTimeout, this.visibility, this.visibleRoles, this.visibleTenants, this.accessControl, this.accessControlRoles, this.gatewayEnvironments, this.apiType, this.transport, this.tags, this.policies, this.apiThrottlingPolicy, this.authorizationHeader, this.securityScheme, this.subscriptionAvailability, this.subscriptionAvailableTenants, this.additionalProperties, this.monetization, this.businessInformation, this.corsConfiguration, this.createdTime, this.lastUpdatedTime, this.apis, this.scopes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIProductDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    hasThumbnail: ").append(this.toIndentedString(this.hasThumbnail)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    enableSchemaValidation: ").append(this.toIndentedString(this.enableSchemaValidation)).append("\n");
        sb.append("    responseCachingEnabled: ").append(this.toIndentedString(this.responseCachingEnabled)).append("\n");
        sb.append("    cacheTimeout: ").append(this.toIndentedString(this.cacheTimeout)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    visibleRoles: ").append(this.toIndentedString(this.visibleRoles)).append("\n");
        sb.append("    visibleTenants: ").append(this.toIndentedString(this.visibleTenants)).append("\n");
        sb.append("    accessControl: ").append(this.toIndentedString((Object)this.accessControl)).append("\n");
        sb.append("    accessControlRoles: ").append(this.toIndentedString(this.accessControlRoles)).append("\n");
        sb.append("    gatewayEnvironments: ").append(this.toIndentedString(this.gatewayEnvironments)).append("\n");
        sb.append("    apiType: ").append(this.toIndentedString(this.apiType)).append("\n");
        sb.append("    transport: ").append(this.toIndentedString(this.transport)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    apiThrottlingPolicy: ").append(this.toIndentedString(this.apiThrottlingPolicy)).append("\n");
        sb.append("    authorizationHeader: ").append(this.toIndentedString(this.authorizationHeader)).append("\n");
        sb.append("    securityScheme: ").append(this.toIndentedString(this.securityScheme)).append("\n");
        sb.append("    subscriptionAvailability: ").append(this.toIndentedString((Object)this.subscriptionAvailability)).append("\n");
        sb.append("    subscriptionAvailableTenants: ").append(this.toIndentedString(this.subscriptionAvailableTenants)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("    monetization: ").append(this.toIndentedString(this.monetization)).append("\n");
        sb.append("    businessInformation: ").append(this.toIndentedString(this.businessInformation)).append("\n");
        sb.append("    corsConfiguration: ").append(this.toIndentedString(this.corsConfiguration)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    apis: ").append(this.toIndentedString(this.apis)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SubscriptionAvailabilityEnum {
        CURRENT_TENANT("CURRENT_TENANT"),
        ALL_TENANTS("ALL_TENANTS"),
        SPECIFIC_TENANTS("SPECIFIC_TENANTS");

        private String value;

        private SubscriptionAvailabilityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SubscriptionAvailabilityEnum fromValue(String text) {
            for (SubscriptionAvailabilityEnum b : SubscriptionAvailabilityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SubscriptionAvailabilityEnum> {
            public void write(JsonWriter jsonWriter, SubscriptionAvailabilityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SubscriptionAvailabilityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SubscriptionAvailabilityEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AccessControlEnum {
        NONE("NONE"),
        RESTRICTED("RESTRICTED");

        private String value;

        private AccessControlEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccessControlEnum fromValue(String text) {
            for (AccessControlEnum b : AccessControlEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AccessControlEnum> {
            public void write(JsonWriter jsonWriter, AccessControlEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AccessControlEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AccessControlEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VisibilityEnum {
        PUBLIC("PUBLIC"),
        PRIVATE("PRIVATE"),
        RESTRICTED("RESTRICTED");

        private String value;

        private VisibilityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VisibilityEnum fromValue(String text) {
            for (VisibilityEnum b : VisibilityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VisibilityEnum> {
            public void write(JsonWriter jsonWriter, VisibilityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VisibilityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VisibilityEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        CREATED("CREATED"),
        PUBLISHED("PUBLISHED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

