/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ThrottlingPolicyDTO {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="policyLevel")
    private PolicyLevelEnum policyLevel = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;
    @SerializedName(value="requestCount")
    private Long requestCount = null;
    @SerializedName(value="unitTime")
    private Long unitTime = null;
    @SerializedName(value="timeUnit")
    private String timeUnit = null;
    @SerializedName(value="tierPlan")
    private TierPlanEnum tierPlan = null;
    @SerializedName(value="stopOnQuotaReach")
    private Boolean stopOnQuotaReach = null;
    @SerializedName(value="monetizationProperties")
    private Map<String, String> monetizationProperties = null;

    public ThrottlingPolicyDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Platinum", required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ThrottlingPolicyDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Allows 50 request(s) per minute.", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ThrottlingPolicyDTO policyLevel(PolicyLevelEnum policyLevel) {
        this.policyLevel = policyLevel;
        return this;
    }

    @ApiModelProperty(example="api", value="")
    public PolicyLevelEnum getPolicyLevel() {
        return this.policyLevel;
    }

    public void setPolicyLevel(PolicyLevelEnum policyLevel) {
        this.policyLevel = policyLevel;
    }

    public ThrottlingPolicyDTO displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="Platinum", value="")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ThrottlingPolicyDTO attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ThrottlingPolicyDTO putAttributesItem(String key, String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @ApiModelProperty(example="{}", value="Custom attributes added to the policy policy ")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ThrottlingPolicyDTO requestCount(Long requestCount) {
        this.requestCount = requestCount;
        return this;
    }

    @ApiModelProperty(example="50", required=true, value="Maximum number of requests which can be sent within a provided unit time ")
    public Long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(Long requestCount) {
        this.requestCount = requestCount;
    }

    public ThrottlingPolicyDTO unitTime(Long unitTime) {
        this.unitTime = unitTime;
        return this;
    }

    @ApiModelProperty(example="60000", required=true, value="")
    public Long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(Long unitTime) {
        this.unitTime = unitTime;
    }

    public ThrottlingPolicyDTO timeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    @ApiModelProperty(example="min", value="")
    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public ThrottlingPolicyDTO tierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
        return this;
    }

    @ApiModelProperty(example="FREE", required=true, value="This attribute declares whether this policy is available under commercial or free ")
    public TierPlanEnum getTierPlan() {
        return this.tierPlan;
    }

    public void setTierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
    }

    public ThrottlingPolicyDTO stopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="By making this attribute to false, you are capabale of sending requests even if the request count exceeded within a unit time ")
    public Boolean isStopOnQuotaReach() {
        return this.stopOnQuotaReach;
    }

    public void setStopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
    }

    public ThrottlingPolicyDTO monetizationProperties(Map<String, String> monetizationProperties) {
        this.monetizationProperties = monetizationProperties;
        return this;
    }

    public ThrottlingPolicyDTO putMonetizationPropertiesItem(String key, String monetizationPropertiesItem) {
        if (this.monetizationProperties == null) {
            this.monetizationProperties = new HashMap<String, String>();
        }
        this.monetizationProperties.put(key, monetizationPropertiesItem);
        return this;
    }

    @ApiModelProperty(example="{}", value="Properties of a tier plan which are related to monetization")
    public Map<String, String> getMonetizationProperties() {
        return this.monetizationProperties;
    }

    public void setMonetizationProperties(Map<String, String> monetizationProperties) {
        this.monetizationProperties = monetizationProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThrottlingPolicyDTO throttlingPolicy = (ThrottlingPolicyDTO)o;
        return Objects.equals(this.name, throttlingPolicy.name) && Objects.equals(this.description, throttlingPolicy.description) && Objects.equals((Object)this.policyLevel, (Object)throttlingPolicy.policyLevel) && Objects.equals(this.displayName, throttlingPolicy.displayName) && Objects.equals(this.attributes, throttlingPolicy.attributes) && Objects.equals(this.requestCount, throttlingPolicy.requestCount) && Objects.equals(this.unitTime, throttlingPolicy.unitTime) && Objects.equals(this.timeUnit, throttlingPolicy.timeUnit) && Objects.equals((Object)this.tierPlan, (Object)throttlingPolicy.tierPlan) && Objects.equals(this.stopOnQuotaReach, throttlingPolicy.stopOnQuotaReach) && Objects.equals(this.monetizationProperties, throttlingPolicy.monetizationProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.policyLevel, this.displayName, this.attributes, this.requestCount, this.unitTime, this.timeUnit, this.tierPlan, this.stopOnQuotaReach, this.monetizationProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThrottlingPolicyDTO {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    policyLevel: ").append(this.toIndentedString((Object)this.policyLevel)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    requestCount: ").append(this.toIndentedString(this.requestCount)).append("\n");
        sb.append("    unitTime: ").append(this.toIndentedString(this.unitTime)).append("\n");
        sb.append("    timeUnit: ").append(this.toIndentedString(this.timeUnit)).append("\n");
        sb.append("    tierPlan: ").append(this.toIndentedString((Object)this.tierPlan)).append("\n");
        sb.append("    stopOnQuotaReach: ").append(this.toIndentedString(this.stopOnQuotaReach)).append("\n");
        sb.append("    monetizationProperties: ").append(this.toIndentedString(this.monetizationProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TierPlanEnum {
        FREE("FREE"),
        COMMERCIAL("COMMERCIAL");

        private String value;

        private TierPlanEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TierPlanEnum fromValue(String text) {
            for (TierPlanEnum b : TierPlanEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TierPlanEnum> {
            public void write(JsonWriter jsonWriter, TierPlanEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TierPlanEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TierPlanEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PolicyLevelEnum {
        SUBSCRIPTION("subscription"),
        API("api");

        private String value;

        private PolicyLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PolicyLevelEnum fromValue(String text) {
            for (PolicyLevelEnum b : PolicyLevelEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PolicyLevelEnum> {
            public void write(JsonWriter jsonWriter, PolicyLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PolicyLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PolicyLevelEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

