/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.ProgressRequestBody;
import org.wso2.am.integration.clients.publisher.api.ProgressResponseBody;

public class GlobalMediationPolicyApi {
    private ApiClient apiClient;

    public GlobalMediationPolicyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GlobalMediationPolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getGlobalMediationPolicyContentCall(String mediationPolicyId, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/mediation-policies/{mediationPolicyId}/content".replaceAll("\\{mediationPolicyId\\}", this.apiClient.escapeString(mediationPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getGlobalMediationPolicyContentValidateBeforeCall(String mediationPolicyId, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (mediationPolicyId == null) {
            throw new ApiException("Missing the required parameter 'mediationPolicyId' when calling getGlobalMediationPolicyContent(Async)");
        }
        Call call = this.getGlobalMediationPolicyContentCall(mediationPolicyId, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public void getGlobalMediationPolicyContent(String mediationPolicyId, String ifNoneMatch) throws ApiException {
        this.getGlobalMediationPolicyContentWithHttpInfo(mediationPolicyId, ifNoneMatch);
    }

    public ApiResponse<Void> getGlobalMediationPolicyContentWithHttpInfo(String mediationPolicyId, String ifNoneMatch) throws ApiException {
        Call call = this.getGlobalMediationPolicyContentValidateBeforeCall(mediationPolicyId, ifNoneMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call getGlobalMediationPolicyContentAsync(String mediationPolicyId, String ifNoneMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getGlobalMediationPolicyContentValidateBeforeCall(mediationPolicyId, ifNoneMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

