/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class APIProductInfoDTO {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="context")
    private String context = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="provider")
    private String provider = null;
    @SerializedName(value="hasThumbnail")
    private Boolean hasThumbnail = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="securityScheme")
    private List<String> securityScheme = null;

    public APIProductInfoDTO id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="UUID of the api product ")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public APIProductInfoDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="CalculatorAPIProduct", value="Name of the API Product")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public APIProductInfoDTO context(String context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="CalculatorAPI", value="")
    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public APIProductInfoDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="A calculator API Product that supports basic operations", value="A brief description about the API")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public APIProductInfoDTO provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="admin", value="If the provider value is not given, the user invoking the API will be used as the provider. ")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public APIProductInfoDTO hasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
        return this;
    }

    @ApiModelProperty(example="true", value="")
    public Boolean isHasThumbnail() {
        return this.hasThumbnail;
    }

    public void setHasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
    }

    public APIProductInfoDTO state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="State of the API product. Only published api products are visible on the store ")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public APIProductInfoDTO securityScheme(List<String> securityScheme) {
        this.securityScheme = securityScheme;
        return this;
    }

    public APIProductInfoDTO addSecuritySchemeItem(String securitySchemeItem) {
        if (this.securityScheme == null) {
            this.securityScheme = new ArrayList<String>();
        }
        this.securityScheme.add(securitySchemeItem);
        return this;
    }

    @ApiModelProperty(value="Types of API security, the current API secured with. It can be either OAuth2 or mutual SSL or both. If it is not set OAuth2 will be set as the security for the current API. ")
    public List<String> getSecurityScheme() {
        return this.securityScheme;
    }

    public void setSecurityScheme(List<String> securityScheme) {
        this.securityScheme = securityScheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIProductInfoDTO apIProductInfo = (APIProductInfoDTO)o;
        return Objects.equals(this.id, apIProductInfo.id) && Objects.equals(this.name, apIProductInfo.name) && Objects.equals(this.context, apIProductInfo.context) && Objects.equals(this.description, apIProductInfo.description) && Objects.equals(this.provider, apIProductInfo.provider) && Objects.equals(this.hasThumbnail, apIProductInfo.hasThumbnail) && Objects.equals((Object)this.state, (Object)apIProductInfo.state) && Objects.equals(this.securityScheme, apIProductInfo.securityScheme);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.context, this.description, this.provider, this.hasThumbnail, this.state, this.securityScheme});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIProductInfoDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    hasThumbnail: ").append(this.toIndentedString(this.hasThumbnail)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    securityScheme: ").append(this.toIndentedString(this.securityScheme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        CREATED("CREATED"),
        PUBLISHED("PUBLISHED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

