/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.auth;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.auth.OAuth;
import org.wso2.am.integration.clients.publisher.api.auth.OAuthFlow;
import org.wso2.am.integration.clients.publisher.api.auth.OAuthOkHttpClient;

public class RetryingOAuth
extends OAuth
implements Interceptor {
    private OAuthClient oAuthClient;
    private OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;

    public RetryingOAuth(OkHttpClient client, OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.oAuthClient = new OAuthClient((HttpClient)new OAuthOkHttpClient(client));
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    public RetryingOAuth(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this(new OkHttpClient(), tokenRequestBuilder);
    }

    public RetryingOAuth(String tokenUrl, String clientId, OAuthFlow flow, String clientSecret, Map<String, String> parameters) {
        this(OAuthClientRequest.tokenLocation((String)tokenUrl).setClientId(clientId).setClientSecret(clientSecret));
        this.setFlow(flow);
        if (parameters != null) {
            for (String paramName : parameters.keySet()) {
                this.tokenRequestBuilder.setParameter(paramName, parameters.get(paramName));
            }
        }
    }

    public void setFlow(OAuthFlow flow) {
        switch (flow) {
            case accessCode: {
                this.tokenRequestBuilder.setGrantType(GrantType.AUTHORIZATION_CODE);
                break;
            }
            case implicit: {
                this.tokenRequestBuilder.setGrantType(GrantType.IMPLICIT);
                break;
            }
            case password: {
                this.tokenRequestBuilder.setGrantType(GrantType.PASSWORD);
                break;
            }
            case application: {
                this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
                break;
            }
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.retryingIntercept(chain, true);
    }

    private Response retryingIntercept(Interceptor.Chain chain, boolean updateTokenAndRetryOnAuthorizationFailure) throws IOException {
        Request request = chain.request();
        if (request.header("Authorization") != null) {
            return chain.proceed(request);
        }
        if (this.getAccessToken() == null) {
            this.updateAccessToken(null);
        }
        if (this.getAccessToken() != null) {
            OAuthClientRequest oAuthRequest;
            Request.Builder requestBuilder = request.newBuilder();
            String requestAccessToken = this.getAccessToken();
            try {
                oAuthRequest = new OAuthBearerClientRequest(request.url().toString()).setAccessToken(requestAccessToken).buildHeaderMessage();
            }
            catch (OAuthSystemException e) {
                throw new IOException(e);
            }
            Map headers = oAuthRequest.getHeaders();
            for (String headerName : headers.keySet()) {
                requestBuilder.addHeader(headerName, (String)headers.get(headerName));
            }
            requestBuilder.url(oAuthRequest.getLocationUri());
            Response response = chain.proceed(requestBuilder.build());
            if (response != null && (response.code() == 401 || response.code() == 403) && updateTokenAndRetryOnAuthorizationFailure) {
                try {
                    if (this.updateAccessToken(requestAccessToken)) {
                        response.body().close();
                        return this.retryingIntercept(chain, false);
                    }
                }
                catch (Exception e) {
                    response.body().close();
                    throw e;
                }
            }
            return response;
        }
        return chain.proceed(chain.request());
    }

    public synchronized boolean updateAccessToken(String requestAccessToken) throws IOException {
        if (this.getAccessToken() == null || this.getAccessToken().equals(requestAccessToken)) {
            try {
                OAuthJSONAccessTokenResponse accessTokenResponse = this.oAuthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
                if (accessTokenResponse != null && accessTokenResponse.getAccessToken() != null) {
                    this.setAccessToken(accessTokenResponse.getAccessToken());
                    return !this.getAccessToken().equals(requestAccessToken);
                }
            }
            catch (OAuthProblemException | OAuthSystemException e) {
                throw new IOException(e);
            }
        }
        return false;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    public void setTokenRequestBuilder(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
    }
}

