/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.AlertConfigDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.AlertConfigListDTO;

public class AlertConfigurationApi {
    private ApiClient localVarApiClient;

    public AlertConfigurationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlertConfigurationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addAlertConfigCall(String alertType, String configurationId, Map<String, String> requestBody, ApiCallback _callback) throws ApiException {
        Map<String, String> localVarPostBody = requestBody;
        String localVarPath = "/alerts/{alertType}/configurations/{configurationId}".replaceAll("\\{alertType\\}", this.localVarApiClient.escapeString(alertType.toString())).replaceAll("\\{configurationId\\}", this.localVarApiClient.escapeString(configurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAlertConfigValidateBeforeCall(String alertType, String configurationId, Map<String, String> requestBody, ApiCallback _callback) throws ApiException {
        if (alertType == null) {
            throw new ApiException("Missing the required parameter 'alertType' when calling addAlertConfig(Async)");
        }
        if (configurationId == null) {
            throw new ApiException("Missing the required parameter 'configurationId' when calling addAlertConfig(Async)");
        }
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling addAlertConfig(Async)");
        }
        Call localVarCall = this.addAlertConfigCall(alertType, configurationId, requestBody, _callback);
        return localVarCall;
    }

    public AlertConfigDTO addAlertConfig(String alertType, String configurationId, Map<String, String> requestBody) throws ApiException {
        ApiResponse<AlertConfigDTO> localVarResp = this.addAlertConfigWithHttpInfo(alertType, configurationId, requestBody);
        return localVarResp.getData();
    }

    public ApiResponse<AlertConfigDTO> addAlertConfigWithHttpInfo(String alertType, String configurationId, Map<String, String> requestBody) throws ApiException {
        Call localVarCall = this.addAlertConfigValidateBeforeCall(alertType, configurationId, requestBody, null);
        Type localVarReturnType = new TypeToken<AlertConfigDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addAlertConfigAsync(String alertType, String configurationId, Map<String, String> requestBody, ApiCallback<AlertConfigDTO> _callback) throws ApiException {
        Call localVarCall = this.addAlertConfigValidateBeforeCall(alertType, configurationId, requestBody, _callback);
        Type localVarReturnType = new TypeToken<AlertConfigDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAlertConfigCall(String alertType, String configurationId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/alerts/{alertType}/configurations/{configurationId}".replaceAll("\\{alertType\\}", this.localVarApiClient.escapeString(alertType.toString())).replaceAll("\\{configurationId\\}", this.localVarApiClient.escapeString(configurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAlertConfigValidateBeforeCall(String alertType, String configurationId, ApiCallback _callback) throws ApiException {
        if (alertType == null) {
            throw new ApiException("Missing the required parameter 'alertType' when calling deleteAlertConfig(Async)");
        }
        if (configurationId == null) {
            throw new ApiException("Missing the required parameter 'configurationId' when calling deleteAlertConfig(Async)");
        }
        Call localVarCall = this.deleteAlertConfigCall(alertType, configurationId, _callback);
        return localVarCall;
    }

    public void deleteAlertConfig(String alertType, String configurationId) throws ApiException {
        this.deleteAlertConfigWithHttpInfo(alertType, configurationId);
    }

    public ApiResponse<Void> deleteAlertConfigWithHttpInfo(String alertType, String configurationId) throws ApiException {
        Call localVarCall = this.deleteAlertConfigValidateBeforeCall(alertType, configurationId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAlertConfigAsync(String alertType, String configurationId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAlertConfigValidateBeforeCall(alertType, configurationId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllAlertConfigsCall(String alertType, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/alerts/{alertType}/configurations".replaceAll("\\{alertType\\}", this.localVarApiClient.escapeString(alertType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllAlertConfigsValidateBeforeCall(String alertType, ApiCallback _callback) throws ApiException {
        if (alertType == null) {
            throw new ApiException("Missing the required parameter 'alertType' when calling getAllAlertConfigs(Async)");
        }
        Call localVarCall = this.getAllAlertConfigsCall(alertType, _callback);
        return localVarCall;
    }

    public AlertConfigListDTO getAllAlertConfigs(String alertType) throws ApiException {
        ApiResponse<AlertConfigListDTO> localVarResp = this.getAllAlertConfigsWithHttpInfo(alertType);
        return localVarResp.getData();
    }

    public ApiResponse<AlertConfigListDTO> getAllAlertConfigsWithHttpInfo(String alertType) throws ApiException {
        Call localVarCall = this.getAllAlertConfigsValidateBeforeCall(alertType, null);
        Type localVarReturnType = new TypeToken<AlertConfigListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllAlertConfigsAsync(String alertType, ApiCallback<AlertConfigListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAllAlertConfigsValidateBeforeCall(alertType, _callback);
        Type localVarReturnType = new TypeToken<AlertConfigListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

