/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentListDTO;

public class ApiProductDocumentsApi {
    private ApiClient localVarApiClient;

    public ApiProductDocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiProductDocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addAPIProductDocumentCall(String apiProductId, DocumentDTO documentDTO, ApiCallback _callback) throws ApiException {
        DocumentDTO localVarPostBody = documentDTO;
        String localVarPath = "/api-products/{apiProductId}/documents".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAPIProductDocumentValidateBeforeCall(String apiProductId, DocumentDTO documentDTO, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling addAPIProductDocument(Async)");
        }
        if (documentDTO == null) {
            throw new ApiException("Missing the required parameter 'documentDTO' when calling addAPIProductDocument(Async)");
        }
        Call localVarCall = this.addAPIProductDocumentCall(apiProductId, documentDTO, _callback);
        return localVarCall;
    }

    public DocumentDTO addAPIProductDocument(String apiProductId, DocumentDTO documentDTO) throws ApiException {
        ApiResponse<DocumentDTO> localVarResp = this.addAPIProductDocumentWithHttpInfo(apiProductId, documentDTO);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentDTO> addAPIProductDocumentWithHttpInfo(String apiProductId, DocumentDTO documentDTO) throws ApiException {
        Call localVarCall = this.addAPIProductDocumentValidateBeforeCall(apiProductId, documentDTO, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addAPIProductDocumentAsync(String apiProductId, DocumentDTO documentDTO, ApiCallback<DocumentDTO> _callback) throws ApiException {
        Call localVarCall = this.addAPIProductDocumentValidateBeforeCall(apiProductId, documentDTO, _callback);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call addAPIProductDocumentContentCall(String apiProductId, String documentId, String ifMatch, File file, String inlineContent, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}/content".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (inlineContent != null) {
            localVarFormParams.put("inlineContent", inlineContent);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAPIProductDocumentContentValidateBeforeCall(String apiProductId, String documentId, String ifMatch, File file, String inlineContent, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling addAPIProductDocumentContent(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling addAPIProductDocumentContent(Async)");
        }
        Call localVarCall = this.addAPIProductDocumentContentCall(apiProductId, documentId, ifMatch, file, inlineContent, _callback);
        return localVarCall;
    }

    public DocumentDTO addAPIProductDocumentContent(String apiProductId, String documentId, String ifMatch, File file, String inlineContent) throws ApiException {
        ApiResponse<DocumentDTO> localVarResp = this.addAPIProductDocumentContentWithHttpInfo(apiProductId, documentId, ifMatch, file, inlineContent);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentDTO> addAPIProductDocumentContentWithHttpInfo(String apiProductId, String documentId, String ifMatch, File file, String inlineContent) throws ApiException {
        Call localVarCall = this.addAPIProductDocumentContentValidateBeforeCall(apiProductId, documentId, ifMatch, file, inlineContent, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addAPIProductDocumentContentAsync(String apiProductId, String documentId, String ifMatch, File file, String inlineContent, ApiCallback<DocumentDTO> _callback) throws ApiException {
        Call localVarCall = this.addAPIProductDocumentContentValidateBeforeCall(apiProductId, documentId, ifMatch, file, inlineContent, _callback);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAPIProductDocumentCall(String apiProductId, String documentId, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAPIProductDocumentValidateBeforeCall(String apiProductId, String documentId, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling deleteAPIProductDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteAPIProductDocument(Async)");
        }
        Call localVarCall = this.deleteAPIProductDocumentCall(apiProductId, documentId, ifMatch, _callback);
        return localVarCall;
    }

    public void deleteAPIProductDocument(String apiProductId, String documentId, String ifMatch) throws ApiException {
        this.deleteAPIProductDocumentWithHttpInfo(apiProductId, documentId, ifMatch);
    }

    public ApiResponse<Void> deleteAPIProductDocumentWithHttpInfo(String apiProductId, String documentId, String ifMatch) throws ApiException {
        Call localVarCall = this.deleteAPIProductDocumentValidateBeforeCall(apiProductId, documentId, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAPIProductDocumentAsync(String apiProductId, String documentId, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAPIProductDocumentValidateBeforeCall(apiProductId, documentId, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIProductDocumentCall(String apiProductId, String documentId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIProductDocumentValidateBeforeCall(String apiProductId, String documentId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getAPIProductDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getAPIProductDocument(Async)");
        }
        Call localVarCall = this.getAPIProductDocumentCall(apiProductId, documentId, accept, ifNoneMatch, _callback);
        return localVarCall;
    }

    public DocumentDTO getAPIProductDocument(String apiProductId, String documentId, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<DocumentDTO> localVarResp = this.getAPIProductDocumentWithHttpInfo(apiProductId, documentId, accept, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentDTO> getAPIProductDocumentWithHttpInfo(String apiProductId, String documentId, String accept, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIProductDocumentValidateBeforeCall(apiProductId, documentId, accept, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIProductDocumentAsync(String apiProductId, String documentId, String accept, String ifNoneMatch, ApiCallback<DocumentDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIProductDocumentValidateBeforeCall(apiProductId, documentId, accept, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIProductDocumentContentCall(String apiProductId, String documentId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}/content".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIProductDocumentContentValidateBeforeCall(String apiProductId, String documentId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getAPIProductDocumentContent(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getAPIProductDocumentContent(Async)");
        }
        Call localVarCall = this.getAPIProductDocumentContentCall(apiProductId, documentId, accept, ifNoneMatch, _callback);
        return localVarCall;
    }

    public void getAPIProductDocumentContent(String apiProductId, String documentId, String accept, String ifNoneMatch) throws ApiException {
        this.getAPIProductDocumentContentWithHttpInfo(apiProductId, documentId, accept, ifNoneMatch);
    }

    public ApiResponse<Void> getAPIProductDocumentContentWithHttpInfo(String apiProductId, String documentId, String accept, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIProductDocumentContentValidateBeforeCall(apiProductId, documentId, accept, ifNoneMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getAPIProductDocumentContentAsync(String apiProductId, String documentId, String accept, String ifNoneMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getAPIProductDocumentContentValidateBeforeCall(apiProductId, documentId, accept, ifNoneMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIProductDocumentsCall(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/documents".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIProductDocumentsValidateBeforeCall(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getAPIProductDocuments(Async)");
        }
        Call localVarCall = this.getAPIProductDocumentsCall(apiProductId, limit, offset, accept, ifNoneMatch, _callback);
        return localVarCall;
    }

    public DocumentListDTO getAPIProductDocuments(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<DocumentListDTO> localVarResp = this.getAPIProductDocumentsWithHttpInfo(apiProductId, limit, offset, accept, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentListDTO> getAPIProductDocumentsWithHttpInfo(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIProductDocumentsValidateBeforeCall(apiProductId, limit, offset, accept, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DocumentListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIProductDocumentsAsync(String apiProductId, Integer limit, Integer offset, String accept, String ifNoneMatch, ApiCallback<DocumentListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIProductDocumentsValidateBeforeCall(apiProductId, limit, offset, accept, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<DocumentListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAPIProductDocumentCall(String apiProductId, String documentId, DocumentDTO documentDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        DocumentDTO localVarPostBody = documentDTO;
        String localVarPath = "/api-products/{apiProductId}/documents/{documentId}".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAPIProductDocumentValidateBeforeCall(String apiProductId, String documentId, DocumentDTO documentDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling updateAPIProductDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling updateAPIProductDocument(Async)");
        }
        if (documentDTO == null) {
            throw new ApiException("Missing the required parameter 'documentDTO' when calling updateAPIProductDocument(Async)");
        }
        Call localVarCall = this.updateAPIProductDocumentCall(apiProductId, documentId, documentDTO, ifMatch, _callback);
        return localVarCall;
    }

    public DocumentDTO updateAPIProductDocument(String apiProductId, String documentId, DocumentDTO documentDTO, String ifMatch) throws ApiException {
        ApiResponse<DocumentDTO> localVarResp = this.updateAPIProductDocumentWithHttpInfo(apiProductId, documentId, documentDTO, ifMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentDTO> updateAPIProductDocumentWithHttpInfo(String apiProductId, String documentId, DocumentDTO documentDTO, String ifMatch) throws ApiException {
        Call localVarCall = this.updateAPIProductDocumentValidateBeforeCall(apiProductId, documentId, documentDTO, ifMatch, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAPIProductDocumentAsync(String apiProductId, String documentId, DocumentDTO documentDTO, String ifMatch, ApiCallback<DocumentDTO> _callback) throws ApiException {
        Call localVarCall = this.updateAPIProductDocumentValidateBeforeCall(apiProductId, documentId, documentDTO, ifMatch, _callback);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

