/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDeploymentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDeploymentListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionListDTO;

public class ApiProductRevisionsApi {
    private ApiClient localVarApiClient;

    public ApiProductRevisionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiProductRevisionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createAPIProductRevisionCall(String apiProductId, APIRevisionDTO apIRevisionDTO, ApiCallback _callback) throws ApiException {
        APIRevisionDTO localVarPostBody = apIRevisionDTO;
        String localVarPath = "/api-products/{apiProductId}/revisions".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAPIProductRevisionValidateBeforeCall(String apiProductId, APIRevisionDTO apIRevisionDTO, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling createAPIProductRevision(Async)");
        }
        Call localVarCall = this.createAPIProductRevisionCall(apiProductId, apIRevisionDTO, _callback);
        return localVarCall;
    }

    public APIRevisionDTO createAPIProductRevision(String apiProductId, APIRevisionDTO apIRevisionDTO) throws ApiException {
        ApiResponse<APIRevisionDTO> localVarResp = this.createAPIProductRevisionWithHttpInfo(apiProductId, apIRevisionDTO);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionDTO> createAPIProductRevisionWithHttpInfo(String apiProductId, APIRevisionDTO apIRevisionDTO) throws ApiException {
        Call localVarCall = this.createAPIProductRevisionValidateBeforeCall(apiProductId, apIRevisionDTO, null);
        Type localVarReturnType = new TypeToken<APIRevisionDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAPIProductRevisionAsync(String apiProductId, APIRevisionDTO apIRevisionDTO, ApiCallback<APIRevisionDTO> _callback) throws ApiException {
        Call localVarCall = this.createAPIProductRevisionValidateBeforeCall(apiProductId, apIRevisionDTO, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAPIProductRevisionCall(String apiProductId, String revisionId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/revisions/{revisionId}".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString())).replaceAll("\\{revisionId\\}", this.localVarApiClient.escapeString(revisionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAPIProductRevisionValidateBeforeCall(String apiProductId, String revisionId, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling deleteAPIProductRevision(Async)");
        }
        if (revisionId == null) {
            throw new ApiException("Missing the required parameter 'revisionId' when calling deleteAPIProductRevision(Async)");
        }
        Call localVarCall = this.deleteAPIProductRevisionCall(apiProductId, revisionId, _callback);
        return localVarCall;
    }

    public APIRevisionListDTO deleteAPIProductRevision(String apiProductId, String revisionId) throws ApiException {
        ApiResponse<APIRevisionListDTO> localVarResp = this.deleteAPIProductRevisionWithHttpInfo(apiProductId, revisionId);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionListDTO> deleteAPIProductRevisionWithHttpInfo(String apiProductId, String revisionId) throws ApiException {
        Call localVarCall = this.deleteAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, null);
        Type localVarReturnType = new TypeToken<APIRevisionListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteAPIProductRevisionAsync(String apiProductId, String revisionId, ApiCallback<APIRevisionListDTO> _callback) throws ApiException {
        Call localVarCall = this.deleteAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deployAPIProductRevisionCall(String apiProductId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        List<APIRevisionDeploymentDTO> localVarPostBody = apIRevisionDeploymentDTO;
        String localVarPath = "/api-products/{apiProductId}/deploy-revision".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (revisionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("revisionId", revisionId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deployAPIProductRevisionValidateBeforeCall(String apiProductId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling deployAPIProductRevision(Async)");
        }
        Call localVarCall = this.deployAPIProductRevisionCall(apiProductId, revisionId, apIRevisionDeploymentDTO, _callback);
        return localVarCall;
    }

    public void deployAPIProductRevision(String apiProductId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO) throws ApiException {
        this.deployAPIProductRevisionWithHttpInfo(apiProductId, revisionId, apIRevisionDeploymentDTO);
    }

    public ApiResponse<Void> deployAPIProductRevisionWithHttpInfo(String apiProductId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO) throws ApiException {
        Call localVarCall = this.deployAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, apIRevisionDeploymentDTO, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deployAPIProductRevisionAsync(String apiProductId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deployAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, apIRevisionDeploymentDTO, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIProductRevisionCall(String apiProductId, String revisionId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/revisions/{revisionId}".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString())).replaceAll("\\{revisionId\\}", this.localVarApiClient.escapeString(revisionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIProductRevisionValidateBeforeCall(String apiProductId, String revisionId, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getAPIProductRevision(Async)");
        }
        if (revisionId == null) {
            throw new ApiException("Missing the required parameter 'revisionId' when calling getAPIProductRevision(Async)");
        }
        Call localVarCall = this.getAPIProductRevisionCall(apiProductId, revisionId, _callback);
        return localVarCall;
    }

    public APIRevisionDTO getAPIProductRevision(String apiProductId, String revisionId) throws ApiException {
        ApiResponse<APIRevisionDTO> localVarResp = this.getAPIProductRevisionWithHttpInfo(apiProductId, revisionId);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionDTO> getAPIProductRevisionWithHttpInfo(String apiProductId, String revisionId) throws ApiException {
        Call localVarCall = this.getAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, null);
        Type localVarReturnType = new TypeToken<APIRevisionDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIProductRevisionAsync(String apiProductId, String revisionId, ApiCallback<APIRevisionDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIProductRevisionDeploymentsCall(String apiProductId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/deploy-revision".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIProductRevisionDeploymentsValidateBeforeCall(String apiProductId, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getAPIProductRevisionDeployments(Async)");
        }
        Call localVarCall = this.getAPIProductRevisionDeploymentsCall(apiProductId, _callback);
        return localVarCall;
    }

    public APIRevisionDeploymentListDTO getAPIProductRevisionDeployments(String apiProductId) throws ApiException {
        ApiResponse<APIRevisionDeploymentListDTO> localVarResp = this.getAPIProductRevisionDeploymentsWithHttpInfo(apiProductId);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionDeploymentListDTO> getAPIProductRevisionDeploymentsWithHttpInfo(String apiProductId) throws ApiException {
        Call localVarCall = this.getAPIProductRevisionDeploymentsValidateBeforeCall(apiProductId, null);
        Type localVarReturnType = new TypeToken<APIRevisionDeploymentListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIProductRevisionDeploymentsAsync(String apiProductId, ApiCallback<APIRevisionDeploymentListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIProductRevisionDeploymentsValidateBeforeCall(apiProductId, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionDeploymentListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIProductRevisionsCall(String apiProductId, String query, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/revisions".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIProductRevisionsValidateBeforeCall(String apiProductId, String query, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getAPIProductRevisions(Async)");
        }
        Call localVarCall = this.getAPIProductRevisionsCall(apiProductId, query, _callback);
        return localVarCall;
    }

    public APIRevisionListDTO getAPIProductRevisions(String apiProductId, String query) throws ApiException {
        ApiResponse<APIRevisionListDTO> localVarResp = this.getAPIProductRevisionsWithHttpInfo(apiProductId, query);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionListDTO> getAPIProductRevisionsWithHttpInfo(String apiProductId, String query) throws ApiException {
        Call localVarCall = this.getAPIProductRevisionsValidateBeforeCall(apiProductId, query, null);
        Type localVarReturnType = new TypeToken<APIRevisionListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIProductRevisionsAsync(String apiProductId, String query, ApiCallback<APIRevisionListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIProductRevisionsValidateBeforeCall(apiProductId, query, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call restoreAPIProductRevisionCall(String apiProductId, String revisionId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/restore-revision".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (revisionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("revisionId", revisionId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restoreAPIProductRevisionValidateBeforeCall(String apiProductId, String revisionId, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling restoreAPIProductRevision(Async)");
        }
        Call localVarCall = this.restoreAPIProductRevisionCall(apiProductId, revisionId, _callback);
        return localVarCall;
    }

    public APIProductDTO restoreAPIProductRevision(String apiProductId, String revisionId) throws ApiException {
        ApiResponse<APIProductDTO> localVarResp = this.restoreAPIProductRevisionWithHttpInfo(apiProductId, revisionId);
        return localVarResp.getData();
    }

    public ApiResponse<APIProductDTO> restoreAPIProductRevisionWithHttpInfo(String apiProductId, String revisionId) throws ApiException {
        Call localVarCall = this.restoreAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, null);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call restoreAPIProductRevisionAsync(String apiProductId, String revisionId, ApiCallback<APIProductDTO> _callback) throws ApiException {
        Call localVarCall = this.restoreAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, _callback);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call undeployAPIProductRevisionCall(String apiProductId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        List<APIRevisionDeploymentDTO> localVarPostBody = apIRevisionDeploymentDTO;
        String localVarPath = "/api-products/{apiProductId}/undeploy-revision".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (revisionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("revisionId", revisionId));
        }
        if (revisionNumber != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("revisionNumber", revisionNumber));
        }
        if (allEnvironments != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allEnvironments", allEnvironments));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call undeployAPIProductRevisionValidateBeforeCall(String apiProductId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling undeployAPIProductRevision(Async)");
        }
        Call localVarCall = this.undeployAPIProductRevisionCall(apiProductId, revisionId, revisionNumber, allEnvironments, apIRevisionDeploymentDTO, _callback);
        return localVarCall;
    }

    public void undeployAPIProductRevision(String apiProductId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO) throws ApiException {
        this.undeployAPIProductRevisionWithHttpInfo(apiProductId, revisionId, revisionNumber, allEnvironments, apIRevisionDeploymentDTO);
    }

    public ApiResponse<Void> undeployAPIProductRevisionWithHttpInfo(String apiProductId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO) throws ApiException {
        Call localVarCall = this.undeployAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, revisionNumber, allEnvironments, apIRevisionDeploymentDTO, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call undeployAPIProductRevisionAsync(String apiProductId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.undeployAPIProductRevisionValidateBeforeCall(apiProductId, revisionId, revisionNumber, allEnvironments, apIRevisionDeploymentDTO, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

