/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionListDTO;

public class SubscriptionsApi {
    private ApiClient localVarApiClient;

    public SubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call blockSubscriptionCall(String subscriptionId, String blockState, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions/block-subscription";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subscriptionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subscriptionId", subscriptionId));
        }
        if (blockState != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("blockState", blockState));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call blockSubscriptionValidateBeforeCall(String subscriptionId, String blockState, String ifMatch, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling blockSubscription(Async)");
        }
        if (blockState == null) {
            throw new ApiException("Missing the required parameter 'blockState' when calling blockSubscription(Async)");
        }
        Call localVarCall = this.blockSubscriptionCall(subscriptionId, blockState, ifMatch, _callback);
        return localVarCall;
    }

    public void blockSubscription(String subscriptionId, String blockState, String ifMatch) throws ApiException {
        this.blockSubscriptionWithHttpInfo(subscriptionId, blockState, ifMatch);
    }

    public ApiResponse<Void> blockSubscriptionWithHttpInfo(String subscriptionId, String blockState, String ifMatch) throws ApiException {
        Call localVarCall = this.blockSubscriptionValidateBeforeCall(subscriptionId, blockState, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call blockSubscriptionAsync(String subscriptionId, String blockState, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.blockSubscriptionValidateBeforeCall(subscriptionId, blockState, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getSubscriptionsCall(String apiId, Integer limit, Integer offset, String ifNoneMatch, String query, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("apiId", apiId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionsValidateBeforeCall(String apiId, Integer limit, Integer offset, String ifNoneMatch, String query, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionsCall(apiId, limit, offset, ifNoneMatch, query, _callback);
        return localVarCall;
    }

    public SubscriptionListDTO getSubscriptions(String apiId, Integer limit, Integer offset, String ifNoneMatch, String query) throws ApiException {
        ApiResponse<SubscriptionListDTO> localVarResp = this.getSubscriptionsWithHttpInfo(apiId, limit, offset, ifNoneMatch, query);
        return localVarResp.getData();
    }

    public ApiResponse<SubscriptionListDTO> getSubscriptionsWithHttpInfo(String apiId, Integer limit, Integer offset, String ifNoneMatch, String query) throws ApiException {
        Call localVarCall = this.getSubscriptionsValidateBeforeCall(apiId, limit, offset, ifNoneMatch, query, null);
        Type localVarReturnType = new TypeToken<SubscriptionListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSubscriptionsAsync(String apiId, Integer limit, Integer offset, String ifNoneMatch, String query, ApiCallback<SubscriptionListDTO> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionsValidateBeforeCall(apiId, limit, offset, ifNoneMatch, query, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unBlockSubscriptionCall(String subscriptionId, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions/unblock-subscription";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subscriptionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subscriptionId", subscriptionId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unBlockSubscriptionValidateBeforeCall(String subscriptionId, String ifMatch, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling unBlockSubscription(Async)");
        }
        Call localVarCall = this.unBlockSubscriptionCall(subscriptionId, ifMatch, _callback);
        return localVarCall;
    }

    public void unBlockSubscription(String subscriptionId, String ifMatch) throws ApiException {
        this.unBlockSubscriptionWithHttpInfo(subscriptionId, ifMatch);
    }

    public ApiResponse<Void> unBlockSubscriptionWithHttpInfo(String subscriptionId, String ifMatch) throws ApiException {
        Call localVarCall = this.unBlockSubscriptionValidateBeforeCall(subscriptionId, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call unBlockSubscriptionAsync(String subscriptionId, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.unBlockSubscriptionValidateBeforeCall(subscriptionId, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

