/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ThrottlingPolicyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ThrottlingPolicyListDTO;

public class ThrottlingPoliciesApi {
    private ApiClient localVarApiClient;

    public ThrottlingPoliciesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ThrottlingPoliciesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAllThrottlingPoliciesCall(String policyLevel, Integer limit, Integer offset, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/throttling-policies/{policyLevel}".replaceAll("\\{policyLevel\\}", this.localVarApiClient.escapeString(policyLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllThrottlingPoliciesValidateBeforeCall(String policyLevel, Integer limit, Integer offset, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (policyLevel == null) {
            throw new ApiException("Missing the required parameter 'policyLevel' when calling getAllThrottlingPolicies(Async)");
        }
        Call localVarCall = this.getAllThrottlingPoliciesCall(policyLevel, limit, offset, ifNoneMatch, _callback);
        return localVarCall;
    }

    public ThrottlingPolicyListDTO getAllThrottlingPolicies(String policyLevel, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        ApiResponse<ThrottlingPolicyListDTO> localVarResp = this.getAllThrottlingPoliciesWithHttpInfo(policyLevel, limit, offset, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<ThrottlingPolicyListDTO> getAllThrottlingPoliciesWithHttpInfo(String policyLevel, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAllThrottlingPoliciesValidateBeforeCall(policyLevel, limit, offset, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<ThrottlingPolicyListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllThrottlingPoliciesAsync(String policyLevel, Integer limit, Integer offset, String ifNoneMatch, ApiCallback<ThrottlingPolicyListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAllThrottlingPoliciesValidateBeforeCall(policyLevel, limit, offset, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<ThrottlingPolicyListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getThrottlingPolicyByNameCall(String policyName, String policyLevel, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/throttling-policies/{policyLevel}/{policyName}".replaceAll("\\{policyName\\}", this.localVarApiClient.escapeString(policyName.toString())).replaceAll("\\{policyLevel\\}", this.localVarApiClient.escapeString(policyLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getThrottlingPolicyByNameValidateBeforeCall(String policyName, String policyLevel, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (policyName == null) {
            throw new ApiException("Missing the required parameter 'policyName' when calling getThrottlingPolicyByName(Async)");
        }
        if (policyLevel == null) {
            throw new ApiException("Missing the required parameter 'policyLevel' when calling getThrottlingPolicyByName(Async)");
        }
        Call localVarCall = this.getThrottlingPolicyByNameCall(policyName, policyLevel, ifNoneMatch, _callback);
        return localVarCall;
    }

    public ThrottlingPolicyDTO getThrottlingPolicyByName(String policyName, String policyLevel, String ifNoneMatch) throws ApiException {
        ApiResponse<ThrottlingPolicyDTO> localVarResp = this.getThrottlingPolicyByNameWithHttpInfo(policyName, policyLevel, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<ThrottlingPolicyDTO> getThrottlingPolicyByNameWithHttpInfo(String policyName, String policyLevel, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getThrottlingPolicyByNameValidateBeforeCall(policyName, policyLevel, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<ThrottlingPolicyDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getThrottlingPolicyByNameAsync(String policyName, String policyLevel, String ifNoneMatch, ApiCallback<ThrottlingPolicyDTO> _callback) throws ApiException {
        Call localVarCall = this.getThrottlingPolicyByNameValidateBeforeCall(policyName, policyLevel, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<ThrottlingPolicyDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

