/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ResourcePolicyInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ResourcePolicyListDTO;

public class ApiResourcePoliciesApi {
    private ApiClient localVarApiClient;

    public ApiResourcePoliciesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiResourcePoliciesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAPIResourcePoliciesCall(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/resource-policies".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (resourcePath != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourcePath", resourcePath));
        }
        if (verb != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("verb", verb));
        }
        if (sequenceType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sequenceType", sequenceType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcePoliciesValidateBeforeCall(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIResourcePolicies(Async)");
        }
        if (sequenceType == null) {
            throw new ApiException("Missing the required parameter 'sequenceType' when calling getAPIResourcePolicies(Async)");
        }
        Call localVarCall = this.getAPIResourcePoliciesCall(apiId, sequenceType, resourcePath, verb, ifNoneMatch, _callback);
        return localVarCall;
    }

    public ResourcePolicyListDTO getAPIResourcePolicies(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch) throws ApiException {
        ApiResponse<ResourcePolicyListDTO> localVarResp = this.getAPIResourcePoliciesWithHttpInfo(apiId, sequenceType, resourcePath, verb, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<ResourcePolicyListDTO> getAPIResourcePoliciesWithHttpInfo(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIResourcePoliciesValidateBeforeCall(apiId, sequenceType, resourcePath, verb, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<ResourcePolicyListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIResourcePoliciesAsync(String apiId, String sequenceType, String resourcePath, String verb, String ifNoneMatch, ApiCallback<ResourcePolicyListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcePoliciesValidateBeforeCall(apiId, sequenceType, resourcePath, verb, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<ResourcePolicyListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIResourcePoliciesByPolicyIdCall(String apiId, String resourcePolicyId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/resource-policies/{resourcePolicyId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{resourcePolicyId\\}", this.localVarApiClient.escapeString(resourcePolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcePoliciesByPolicyIdValidateBeforeCall(String apiId, String resourcePolicyId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIResourcePoliciesByPolicyId(Async)");
        }
        if (resourcePolicyId == null) {
            throw new ApiException("Missing the required parameter 'resourcePolicyId' when calling getAPIResourcePoliciesByPolicyId(Async)");
        }
        Call localVarCall = this.getAPIResourcePoliciesByPolicyIdCall(apiId, resourcePolicyId, ifNoneMatch, _callback);
        return localVarCall;
    }

    public ResourcePolicyInfoDTO getAPIResourcePoliciesByPolicyId(String apiId, String resourcePolicyId, String ifNoneMatch) throws ApiException {
        ApiResponse<ResourcePolicyInfoDTO> localVarResp = this.getAPIResourcePoliciesByPolicyIdWithHttpInfo(apiId, resourcePolicyId, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<ResourcePolicyInfoDTO> getAPIResourcePoliciesByPolicyIdWithHttpInfo(String apiId, String resourcePolicyId, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIResourcePoliciesByPolicyIdValidateBeforeCall(apiId, resourcePolicyId, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<ResourcePolicyInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIResourcePoliciesByPolicyIdAsync(String apiId, String resourcePolicyId, String ifNoneMatch, ApiCallback<ResourcePolicyInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcePoliciesByPolicyIdValidateBeforeCall(apiId, resourcePolicyId, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<ResourcePolicyInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAPIResourcePoliciesByPolicyIdCall(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO resourcePolicyInfoDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        ResourcePolicyInfoDTO localVarPostBody = resourcePolicyInfoDTO;
        String localVarPath = "/apis/{apiId}/resource-policies/{resourcePolicyId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{resourcePolicyId\\}", this.localVarApiClient.escapeString(resourcePolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAPIResourcePoliciesByPolicyIdValidateBeforeCall(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO resourcePolicyInfoDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling updateAPIResourcePoliciesByPolicyId(Async)");
        }
        if (resourcePolicyId == null) {
            throw new ApiException("Missing the required parameter 'resourcePolicyId' when calling updateAPIResourcePoliciesByPolicyId(Async)");
        }
        if (resourcePolicyInfoDTO == null) {
            throw new ApiException("Missing the required parameter 'resourcePolicyInfoDTO' when calling updateAPIResourcePoliciesByPolicyId(Async)");
        }
        Call localVarCall = this.updateAPIResourcePoliciesByPolicyIdCall(apiId, resourcePolicyId, resourcePolicyInfoDTO, ifMatch, _callback);
        return localVarCall;
    }

    public ResourcePolicyInfoDTO updateAPIResourcePoliciesByPolicyId(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO resourcePolicyInfoDTO, String ifMatch) throws ApiException {
        ApiResponse<ResourcePolicyInfoDTO> localVarResp = this.updateAPIResourcePoliciesByPolicyIdWithHttpInfo(apiId, resourcePolicyId, resourcePolicyInfoDTO, ifMatch);
        return localVarResp.getData();
    }

    public ApiResponse<ResourcePolicyInfoDTO> updateAPIResourcePoliciesByPolicyIdWithHttpInfo(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO resourcePolicyInfoDTO, String ifMatch) throws ApiException {
        Call localVarCall = this.updateAPIResourcePoliciesByPolicyIdValidateBeforeCall(apiId, resourcePolicyId, resourcePolicyInfoDTO, ifMatch, null);
        Type localVarReturnType = new TypeToken<ResourcePolicyInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAPIResourcePoliciesByPolicyIdAsync(String apiId, String resourcePolicyId, ResourcePolicyInfoDTO resourcePolicyInfoDTO, String ifMatch, ApiCallback<ResourcePolicyInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.updateAPIResourcePoliciesByPolicyIdValidateBeforeCall(apiId, resourcePolicyId, resourcePolicyInfoDTO, ifMatch, _callback);
        Type localVarReturnType = new TypeToken<ResourcePolicyInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

