/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OperationPolicyDataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OperationPolicyDataListDTO;

public class OperationPoliciesApi {
    private ApiClient localVarApiClient;

    public OperationPoliciesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OperationPoliciesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addCommonOperationPolicyCall(File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/operation-policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (policySpecFile != null) {
            localVarFormParams.put("policySpecFile", policySpecFile);
        }
        if (synapsePolicyDefinitionFile != null) {
            localVarFormParams.put("synapsePolicyDefinitionFile", synapsePolicyDefinitionFile);
        }
        if (ccPolicyDefinitionFile != null) {
            localVarFormParams.put("ccPolicyDefinitionFile", ccPolicyDefinitionFile);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addCommonOperationPolicyValidateBeforeCall(File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.addCommonOperationPolicyCall(policySpecFile, synapsePolicyDefinitionFile, ccPolicyDefinitionFile, _callback);
        return localVarCall;
    }

    public OperationPolicyDataDTO addCommonOperationPolicy(File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile) throws ApiException {
        ApiResponse<OperationPolicyDataDTO> localVarResp = this.addCommonOperationPolicyWithHttpInfo(policySpecFile, synapsePolicyDefinitionFile, ccPolicyDefinitionFile);
        return localVarResp.getData();
    }

    public ApiResponse<OperationPolicyDataDTO> addCommonOperationPolicyWithHttpInfo(File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile) throws ApiException {
        Call localVarCall = this.addCommonOperationPolicyValidateBeforeCall(policySpecFile, synapsePolicyDefinitionFile, ccPolicyDefinitionFile, null);
        Type localVarReturnType = new TypeToken<OperationPolicyDataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addCommonOperationPolicyAsync(File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile, ApiCallback<OperationPolicyDataDTO> _callback) throws ApiException {
        Call localVarCall = this.addCommonOperationPolicyValidateBeforeCall(policySpecFile, synapsePolicyDefinitionFile, ccPolicyDefinitionFile, _callback);
        Type localVarReturnType = new TypeToken<OperationPolicyDataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCommonOperationPolicyByPolicyIdCall(String operationPolicyId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/operation-policies/{operationPolicyId}".replaceAll("\\{operationPolicyId\\}", this.localVarApiClient.escapeString(operationPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCommonOperationPolicyByPolicyIdValidateBeforeCall(String operationPolicyId, ApiCallback _callback) throws ApiException {
        if (operationPolicyId == null) {
            throw new ApiException("Missing the required parameter 'operationPolicyId' when calling deleteCommonOperationPolicyByPolicyId(Async)");
        }
        Call localVarCall = this.deleteCommonOperationPolicyByPolicyIdCall(operationPolicyId, _callback);
        return localVarCall;
    }

    public void deleteCommonOperationPolicyByPolicyId(String operationPolicyId) throws ApiException {
        this.deleteCommonOperationPolicyByPolicyIdWithHttpInfo(operationPolicyId);
    }

    public ApiResponse<Void> deleteCommonOperationPolicyByPolicyIdWithHttpInfo(String operationPolicyId) throws ApiException {
        Call localVarCall = this.deleteCommonOperationPolicyByPolicyIdValidateBeforeCall(operationPolicyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteCommonOperationPolicyByPolicyIdAsync(String operationPolicyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCommonOperationPolicyByPolicyIdValidateBeforeCall(operationPolicyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call exportOperationPolicySpecificationSchemaCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/operation-policies/specification/schema";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call exportOperationPolicySpecificationSchemaValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.exportOperationPolicySpecificationSchemaCall(_callback);
        return localVarCall;
    }

    public String exportOperationPolicySpecificationSchema() throws ApiException {
        ApiResponse<String> localVarResp = this.exportOperationPolicySpecificationSchemaWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<String> exportOperationPolicySpecificationSchemaWithHttpInfo() throws ApiException {
        Call localVarCall = this.exportOperationPolicySpecificationSchemaValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call exportOperationPolicySpecificationSchemaAsync(ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.exportOperationPolicySpecificationSchemaValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAllCommonOperationPoliciesCall(Integer limit, Integer offset, String query, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/operation-policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllCommonOperationPoliciesValidateBeforeCall(Integer limit, Integer offset, String query, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllCommonOperationPoliciesCall(limit, offset, query, _callback);
        return localVarCall;
    }

    public OperationPolicyDataListDTO getAllCommonOperationPolicies(Integer limit, Integer offset, String query) throws ApiException {
        ApiResponse<OperationPolicyDataListDTO> localVarResp = this.getAllCommonOperationPoliciesWithHttpInfo(limit, offset, query);
        return localVarResp.getData();
    }

    public ApiResponse<OperationPolicyDataListDTO> getAllCommonOperationPoliciesWithHttpInfo(Integer limit, Integer offset, String query) throws ApiException {
        Call localVarCall = this.getAllCommonOperationPoliciesValidateBeforeCall(limit, offset, query, null);
        Type localVarReturnType = new TypeToken<OperationPolicyDataListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllCommonOperationPoliciesAsync(Integer limit, Integer offset, String query, ApiCallback<OperationPolicyDataListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAllCommonOperationPoliciesValidateBeforeCall(limit, offset, query, _callback);
        Type localVarReturnType = new TypeToken<OperationPolicyDataListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCommonOperationPolicyByPolicyIdCall(String operationPolicyId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/operation-policies/{operationPolicyId}".replaceAll("\\{operationPolicyId\\}", this.localVarApiClient.escapeString(operationPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCommonOperationPolicyByPolicyIdValidateBeforeCall(String operationPolicyId, ApiCallback _callback) throws ApiException {
        if (operationPolicyId == null) {
            throw new ApiException("Missing the required parameter 'operationPolicyId' when calling getCommonOperationPolicyByPolicyId(Async)");
        }
        Call localVarCall = this.getCommonOperationPolicyByPolicyIdCall(operationPolicyId, _callback);
        return localVarCall;
    }

    public OperationPolicyDataDTO getCommonOperationPolicyByPolicyId(String operationPolicyId) throws ApiException {
        ApiResponse<OperationPolicyDataDTO> localVarResp = this.getCommonOperationPolicyByPolicyIdWithHttpInfo(operationPolicyId);
        return localVarResp.getData();
    }

    public ApiResponse<OperationPolicyDataDTO> getCommonOperationPolicyByPolicyIdWithHttpInfo(String operationPolicyId) throws ApiException {
        Call localVarCall = this.getCommonOperationPolicyByPolicyIdValidateBeforeCall(operationPolicyId, null);
        Type localVarReturnType = new TypeToken<OperationPolicyDataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCommonOperationPolicyByPolicyIdAsync(String operationPolicyId, ApiCallback<OperationPolicyDataDTO> _callback) throws ApiException {
        Call localVarCall = this.getCommonOperationPolicyByPolicyIdValidateBeforeCall(operationPolicyId, _callback);
        Type localVarReturnType = new TypeToken<OperationPolicyDataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCommonOperationPolicyContentByPolicyIdCall(String operationPolicyId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/operation-policies/{operationPolicyId}/content".replaceAll("\\{operationPolicyId\\}", this.localVarApiClient.escapeString(operationPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/zip", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCommonOperationPolicyContentByPolicyIdValidateBeforeCall(String operationPolicyId, ApiCallback _callback) throws ApiException {
        if (operationPolicyId == null) {
            throw new ApiException("Missing the required parameter 'operationPolicyId' when calling getCommonOperationPolicyContentByPolicyId(Async)");
        }
        Call localVarCall = this.getCommonOperationPolicyContentByPolicyIdCall(operationPolicyId, _callback);
        return localVarCall;
    }

    public File getCommonOperationPolicyContentByPolicyId(String operationPolicyId) throws ApiException {
        ApiResponse<File> localVarResp = this.getCommonOperationPolicyContentByPolicyIdWithHttpInfo(operationPolicyId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getCommonOperationPolicyContentByPolicyIdWithHttpInfo(String operationPolicyId) throws ApiException {
        Call localVarCall = this.getCommonOperationPolicyContentByPolicyIdValidateBeforeCall(operationPolicyId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCommonOperationPolicyContentByPolicyIdAsync(String operationPolicyId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getCommonOperationPolicyContentByPolicyIdValidateBeforeCall(operationPolicyId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

