/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.TenantListDTO;

public class TenantsApi {
    private ApiClient localVarApiClient;

    public TenantsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TenantsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getTenantExistenceCall(String tenantDomain, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenants/{tenantDomain}".replaceAll("\\{tenantDomain\\}", this.localVarApiClient.escapeString(tenantDomain.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTenantExistenceValidateBeforeCall(String tenantDomain, ApiCallback _callback) throws ApiException {
        if (tenantDomain == null) {
            throw new ApiException("Missing the required parameter 'tenantDomain' when calling getTenantExistence(Async)");
        }
        Call localVarCall = this.getTenantExistenceCall(tenantDomain, _callback);
        return localVarCall;
    }

    public void getTenantExistence(String tenantDomain) throws ApiException {
        this.getTenantExistenceWithHttpInfo(tenantDomain);
    }

    public ApiResponse<Void> getTenantExistenceWithHttpInfo(String tenantDomain) throws ApiException {
        Call localVarCall = this.getTenantExistenceValidateBeforeCall(tenantDomain, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getTenantExistenceAsync(String tenantDomain, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getTenantExistenceValidateBeforeCall(tenantDomain, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getTenantsByStateCall(String state, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenants";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("state", state));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTenantsByStateValidateBeforeCall(String state, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTenantsByStateCall(state, limit, offset, _callback);
        return localVarCall;
    }

    public TenantListDTO getTenantsByState(String state, Integer limit, Integer offset) throws ApiException {
        ApiResponse<TenantListDTO> localVarResp = this.getTenantsByStateWithHttpInfo(state, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<TenantListDTO> getTenantsByStateWithHttpInfo(String state, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.getTenantsByStateValidateBeforeCall(state, limit, offset, null);
        Type localVarReturnType = new TypeToken<TenantListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTenantsByStateAsync(String state, Integer limit, Integer offset, ApiCallback<TenantListDTO> _callback) throws ApiException {
        Call localVarCall = this.getTenantsByStateValidateBeforeCall(state, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<TenantListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

