/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDeploymentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDeploymentListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionListDTO;

public class ApiRevisionsApi {
    private ApiClient localVarApiClient;

    public ApiRevisionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiRevisionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createAPIRevisionCall(String apiId, APIRevisionDTO apIRevisionDTO, ApiCallback _callback) throws ApiException {
        APIRevisionDTO localVarPostBody = apIRevisionDTO;
        String localVarPath = "/apis/{apiId}/revisions".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAPIRevisionValidateBeforeCall(String apiId, APIRevisionDTO apIRevisionDTO, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling createAPIRevision(Async)");
        }
        Call localVarCall = this.createAPIRevisionCall(apiId, apIRevisionDTO, _callback);
        return localVarCall;
    }

    public APIRevisionDTO createAPIRevision(String apiId, APIRevisionDTO apIRevisionDTO) throws ApiException {
        ApiResponse<APIRevisionDTO> localVarResp = this.createAPIRevisionWithHttpInfo(apiId, apIRevisionDTO);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionDTO> createAPIRevisionWithHttpInfo(String apiId, APIRevisionDTO apIRevisionDTO) throws ApiException {
        Call localVarCall = this.createAPIRevisionValidateBeforeCall(apiId, apIRevisionDTO, null);
        Type localVarReturnType = new TypeToken<APIRevisionDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAPIRevisionAsync(String apiId, APIRevisionDTO apIRevisionDTO, ApiCallback<APIRevisionDTO> _callback) throws ApiException {
        Call localVarCall = this.createAPIRevisionValidateBeforeCall(apiId, apIRevisionDTO, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAPIRevisionCall(String apiId, String revisionId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/revisions/{revisionId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{revisionId\\}", this.localVarApiClient.escapeString(revisionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAPIRevisionValidateBeforeCall(String apiId, String revisionId, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling deleteAPIRevision(Async)");
        }
        if (revisionId == null) {
            throw new ApiException("Missing the required parameter 'revisionId' when calling deleteAPIRevision(Async)");
        }
        Call localVarCall = this.deleteAPIRevisionCall(apiId, revisionId, _callback);
        return localVarCall;
    }

    public APIRevisionListDTO deleteAPIRevision(String apiId, String revisionId) throws ApiException {
        ApiResponse<APIRevisionListDTO> localVarResp = this.deleteAPIRevisionWithHttpInfo(apiId, revisionId);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionListDTO> deleteAPIRevisionWithHttpInfo(String apiId, String revisionId) throws ApiException {
        Call localVarCall = this.deleteAPIRevisionValidateBeforeCall(apiId, revisionId, null);
        Type localVarReturnType = new TypeToken<APIRevisionListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteAPIRevisionAsync(String apiId, String revisionId, ApiCallback<APIRevisionListDTO> _callback) throws ApiException {
        Call localVarCall = this.deleteAPIRevisionValidateBeforeCall(apiId, revisionId, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deployAPIRevisionCall(String apiId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        List<APIRevisionDeploymentDTO> localVarPostBody = apIRevisionDeploymentDTO;
        String localVarPath = "/apis/{apiId}/deploy-revision".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (revisionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("revisionId", revisionId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deployAPIRevisionValidateBeforeCall(String apiId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling deployAPIRevision(Async)");
        }
        Call localVarCall = this.deployAPIRevisionCall(apiId, revisionId, apIRevisionDeploymentDTO, _callback);
        return localVarCall;
    }

    public List<APIRevisionDeploymentDTO> deployAPIRevision(String apiId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO) throws ApiException {
        ApiResponse<List<APIRevisionDeploymentDTO>> localVarResp = this.deployAPIRevisionWithHttpInfo(apiId, revisionId, apIRevisionDeploymentDTO);
        return localVarResp.getData();
    }

    public ApiResponse<List<APIRevisionDeploymentDTO>> deployAPIRevisionWithHttpInfo(String apiId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO) throws ApiException {
        Call localVarCall = this.deployAPIRevisionValidateBeforeCall(apiId, revisionId, apIRevisionDeploymentDTO, null);
        Type localVarReturnType = new TypeToken<List<APIRevisionDeploymentDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deployAPIRevisionAsync(String apiId, String revisionId, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback<List<APIRevisionDeploymentDTO>> _callback) throws ApiException {
        Call localVarCall = this.deployAPIRevisionValidateBeforeCall(apiId, revisionId, apIRevisionDeploymentDTO, _callback);
        Type localVarReturnType = new TypeToken<List<APIRevisionDeploymentDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIRevisionCall(String apiId, String revisionId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/revisions/{revisionId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{revisionId\\}", this.localVarApiClient.escapeString(revisionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIRevisionValidateBeforeCall(String apiId, String revisionId, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIRevision(Async)");
        }
        if (revisionId == null) {
            throw new ApiException("Missing the required parameter 'revisionId' when calling getAPIRevision(Async)");
        }
        Call localVarCall = this.getAPIRevisionCall(apiId, revisionId, _callback);
        return localVarCall;
    }

    public APIRevisionDTO getAPIRevision(String apiId, String revisionId) throws ApiException {
        ApiResponse<APIRevisionDTO> localVarResp = this.getAPIRevisionWithHttpInfo(apiId, revisionId);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionDTO> getAPIRevisionWithHttpInfo(String apiId, String revisionId) throws ApiException {
        Call localVarCall = this.getAPIRevisionValidateBeforeCall(apiId, revisionId, null);
        Type localVarReturnType = new TypeToken<APIRevisionDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIRevisionAsync(String apiId, String revisionId, ApiCallback<APIRevisionDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIRevisionValidateBeforeCall(apiId, revisionId, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIRevisionDeploymentsCall(String apiId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/deployments".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIRevisionDeploymentsValidateBeforeCall(String apiId, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIRevisionDeployments(Async)");
        }
        Call localVarCall = this.getAPIRevisionDeploymentsCall(apiId, _callback);
        return localVarCall;
    }

    public APIRevisionDeploymentListDTO getAPIRevisionDeployments(String apiId) throws ApiException {
        ApiResponse<APIRevisionDeploymentListDTO> localVarResp = this.getAPIRevisionDeploymentsWithHttpInfo(apiId);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionDeploymentListDTO> getAPIRevisionDeploymentsWithHttpInfo(String apiId) throws ApiException {
        Call localVarCall = this.getAPIRevisionDeploymentsValidateBeforeCall(apiId, null);
        Type localVarReturnType = new TypeToken<APIRevisionDeploymentListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIRevisionDeploymentsAsync(String apiId, ApiCallback<APIRevisionDeploymentListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIRevisionDeploymentsValidateBeforeCall(apiId, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionDeploymentListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIRevisionsCall(String apiId, String query, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/revisions".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIRevisionsValidateBeforeCall(String apiId, String query, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIRevisions(Async)");
        }
        Call localVarCall = this.getAPIRevisionsCall(apiId, query, _callback);
        return localVarCall;
    }

    public APIRevisionListDTO getAPIRevisions(String apiId, String query) throws ApiException {
        ApiResponse<APIRevisionListDTO> localVarResp = this.getAPIRevisionsWithHttpInfo(apiId, query);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionListDTO> getAPIRevisionsWithHttpInfo(String apiId, String query) throws ApiException {
        Call localVarCall = this.getAPIRevisionsValidateBeforeCall(apiId, query, null);
        Type localVarReturnType = new TypeToken<APIRevisionListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIRevisionsAsync(String apiId, String query, ApiCallback<APIRevisionListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIRevisionsValidateBeforeCall(apiId, query, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call restoreAPIRevisionCall(String apiId, String revisionId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/restore-revision".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (revisionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("revisionId", revisionId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restoreAPIRevisionValidateBeforeCall(String apiId, String revisionId, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling restoreAPIRevision(Async)");
        }
        Call localVarCall = this.restoreAPIRevisionCall(apiId, revisionId, _callback);
        return localVarCall;
    }

    public APIDTO restoreAPIRevision(String apiId, String revisionId) throws ApiException {
        ApiResponse<APIDTO> localVarResp = this.restoreAPIRevisionWithHttpInfo(apiId, revisionId);
        return localVarResp.getData();
    }

    public ApiResponse<APIDTO> restoreAPIRevisionWithHttpInfo(String apiId, String revisionId) throws ApiException {
        Call localVarCall = this.restoreAPIRevisionValidateBeforeCall(apiId, revisionId, null);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call restoreAPIRevisionAsync(String apiId, String revisionId, ApiCallback<APIDTO> _callback) throws ApiException {
        Call localVarCall = this.restoreAPIRevisionValidateBeforeCall(apiId, revisionId, _callback);
        Type localVarReturnType = new TypeToken<APIDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call undeployAPIRevisionCall(String apiId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        List<APIRevisionDeploymentDTO> localVarPostBody = apIRevisionDeploymentDTO;
        String localVarPath = "/apis/{apiId}/undeploy-revision".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (revisionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("revisionId", revisionId));
        }
        if (revisionNumber != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("revisionNumber", revisionNumber));
        }
        if (allEnvironments != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allEnvironments", allEnvironments));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call undeployAPIRevisionValidateBeforeCall(String apiId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling undeployAPIRevision(Async)");
        }
        Call localVarCall = this.undeployAPIRevisionCall(apiId, revisionId, revisionNumber, allEnvironments, apIRevisionDeploymentDTO, _callback);
        return localVarCall;
    }

    public void undeployAPIRevision(String apiId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO) throws ApiException {
        this.undeployAPIRevisionWithHttpInfo(apiId, revisionId, revisionNumber, allEnvironments, apIRevisionDeploymentDTO);
    }

    public ApiResponse<Void> undeployAPIRevisionWithHttpInfo(String apiId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO) throws ApiException {
        Call localVarCall = this.undeployAPIRevisionValidateBeforeCall(apiId, revisionId, revisionNumber, allEnvironments, apIRevisionDeploymentDTO, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call undeployAPIRevisionAsync(String apiId, String revisionId, String revisionNumber, Boolean allEnvironments, List<APIRevisionDeploymentDTO> apIRevisionDeploymentDTO, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.undeployAPIRevisionValidateBeforeCall(apiId, revisionId, revisionNumber, allEnvironments, apIRevisionDeploymentDTO, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateAPIDeploymentCall(String apiId, String deploymentId, APIRevisionDeploymentDTO apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        APIRevisionDeploymentDTO localVarPostBody = apIRevisionDeploymentDTO;
        String localVarPath = "/apis/{apiId}/deployments/{deploymentId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{deploymentId\\}", this.localVarApiClient.escapeString(deploymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAPIDeploymentValidateBeforeCall(String apiId, String deploymentId, APIRevisionDeploymentDTO apIRevisionDeploymentDTO, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling updateAPIDeployment(Async)");
        }
        if (deploymentId == null) {
            throw new ApiException("Missing the required parameter 'deploymentId' when calling updateAPIDeployment(Async)");
        }
        Call localVarCall = this.updateAPIDeploymentCall(apiId, deploymentId, apIRevisionDeploymentDTO, _callback);
        return localVarCall;
    }

    public APIRevisionDeploymentDTO updateAPIDeployment(String apiId, String deploymentId, APIRevisionDeploymentDTO apIRevisionDeploymentDTO) throws ApiException {
        ApiResponse<APIRevisionDeploymentDTO> localVarResp = this.updateAPIDeploymentWithHttpInfo(apiId, deploymentId, apIRevisionDeploymentDTO);
        return localVarResp.getData();
    }

    public ApiResponse<APIRevisionDeploymentDTO> updateAPIDeploymentWithHttpInfo(String apiId, String deploymentId, APIRevisionDeploymentDTO apIRevisionDeploymentDTO) throws ApiException {
        Call localVarCall = this.updateAPIDeploymentValidateBeforeCall(apiId, deploymentId, apIRevisionDeploymentDTO, null);
        Type localVarReturnType = new TypeToken<APIRevisionDeploymentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAPIDeploymentAsync(String apiId, String deploymentId, APIRevisionDeploymentDTO apIRevisionDeploymentDTO, ApiCallback<APIRevisionDeploymentDTO> _callback) throws ApiException {
        Call localVarCall = this.updateAPIDeploymentValidateBeforeCall(apiId, deploymentId, apIRevisionDeploymentDTO, _callback);
        Type localVarReturnType = new TypeToken<APIRevisionDeploymentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

