/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SharedScopeUsageDTO;

public class ScopesApi {
    private ApiClient localVarApiClient;

    public ScopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScopesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addSharedScopeCall(ScopeDTO scopeDTO, ApiCallback _callback) throws ApiException {
        ScopeDTO localVarPostBody = scopeDTO;
        String localVarPath = "/scopes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addSharedScopeValidateBeforeCall(ScopeDTO scopeDTO, ApiCallback _callback) throws ApiException {
        if (scopeDTO == null) {
            throw new ApiException("Missing the required parameter 'scopeDTO' when calling addSharedScope(Async)");
        }
        Call localVarCall = this.addSharedScopeCall(scopeDTO, _callback);
        return localVarCall;
    }

    public ScopeDTO addSharedScope(ScopeDTO scopeDTO) throws ApiException {
        ApiResponse<ScopeDTO> localVarResp = this.addSharedScopeWithHttpInfo(scopeDTO);
        return localVarResp.getData();
    }

    public ApiResponse<ScopeDTO> addSharedScopeWithHttpInfo(ScopeDTO scopeDTO) throws ApiException {
        Call localVarCall = this.addSharedScopeValidateBeforeCall(scopeDTO, null);
        Type localVarReturnType = new TypeToken<ScopeDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addSharedScopeAsync(ScopeDTO scopeDTO, ApiCallback<ScopeDTO> _callback) throws ApiException {
        Call localVarCall = this.addSharedScopeValidateBeforeCall(scopeDTO, _callback);
        Type localVarReturnType = new TypeToken<ScopeDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSharedScopeCall(String scopeId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scopes/{scopeId}".replaceAll("\\{scopeId\\}", this.localVarApiClient.escapeString(scopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSharedScopeValidateBeforeCall(String scopeId, ApiCallback _callback) throws ApiException {
        if (scopeId == null) {
            throw new ApiException("Missing the required parameter 'scopeId' when calling deleteSharedScope(Async)");
        }
        Call localVarCall = this.deleteSharedScopeCall(scopeId, _callback);
        return localVarCall;
    }

    public void deleteSharedScope(String scopeId) throws ApiException {
        this.deleteSharedScopeWithHttpInfo(scopeId);
    }

    public ApiResponse<Void> deleteSharedScopeWithHttpInfo(String scopeId) throws ApiException {
        Call localVarCall = this.deleteSharedScopeValidateBeforeCall(scopeId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSharedScopeAsync(String scopeId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSharedScopeValidateBeforeCall(scopeId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getSharedScopeCall(String scopeId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scopes/{scopeId}".replaceAll("\\{scopeId\\}", this.localVarApiClient.escapeString(scopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSharedScopeValidateBeforeCall(String scopeId, ApiCallback _callback) throws ApiException {
        if (scopeId == null) {
            throw new ApiException("Missing the required parameter 'scopeId' when calling getSharedScope(Async)");
        }
        Call localVarCall = this.getSharedScopeCall(scopeId, _callback);
        return localVarCall;
    }

    public ScopeDTO getSharedScope(String scopeId) throws ApiException {
        ApiResponse<ScopeDTO> localVarResp = this.getSharedScopeWithHttpInfo(scopeId);
        return localVarResp.getData();
    }

    public ApiResponse<ScopeDTO> getSharedScopeWithHttpInfo(String scopeId) throws ApiException {
        Call localVarCall = this.getSharedScopeValidateBeforeCall(scopeId, null);
        Type localVarReturnType = new TypeToken<ScopeDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSharedScopeAsync(String scopeId, ApiCallback<ScopeDTO> _callback) throws ApiException {
        Call localVarCall = this.getSharedScopeValidateBeforeCall(scopeId, _callback);
        Type localVarReturnType = new TypeToken<ScopeDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSharedScopeUsagesCall(String scopeId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scopes/{scopeId}/usage".replaceAll("\\{scopeId\\}", this.localVarApiClient.escapeString(scopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSharedScopeUsagesValidateBeforeCall(String scopeId, ApiCallback _callback) throws ApiException {
        if (scopeId == null) {
            throw new ApiException("Missing the required parameter 'scopeId' when calling getSharedScopeUsages(Async)");
        }
        Call localVarCall = this.getSharedScopeUsagesCall(scopeId, _callback);
        return localVarCall;
    }

    public SharedScopeUsageDTO getSharedScopeUsages(String scopeId) throws ApiException {
        ApiResponse<SharedScopeUsageDTO> localVarResp = this.getSharedScopeUsagesWithHttpInfo(scopeId);
        return localVarResp.getData();
    }

    public ApiResponse<SharedScopeUsageDTO> getSharedScopeUsagesWithHttpInfo(String scopeId) throws ApiException {
        Call localVarCall = this.getSharedScopeUsagesValidateBeforeCall(scopeId, null);
        Type localVarReturnType = new TypeToken<SharedScopeUsageDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSharedScopeUsagesAsync(String scopeId, ApiCallback<SharedScopeUsageDTO> _callback) throws ApiException {
        Call localVarCall = this.getSharedScopeUsagesValidateBeforeCall(scopeId, _callback);
        Type localVarReturnType = new TypeToken<SharedScopeUsageDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSharedScopesCall(Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scopes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSharedScopesValidateBeforeCall(Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getSharedScopesCall(limit, offset, _callback);
        return localVarCall;
    }

    public ScopeListDTO getSharedScopes(Integer limit, Integer offset) throws ApiException {
        ApiResponse<ScopeListDTO> localVarResp = this.getSharedScopesWithHttpInfo(limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ScopeListDTO> getSharedScopesWithHttpInfo(Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.getSharedScopesValidateBeforeCall(limit, offset, null);
        Type localVarReturnType = new TypeToken<ScopeListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSharedScopesAsync(Integer limit, Integer offset, ApiCallback<ScopeListDTO> _callback) throws ApiException {
        Call localVarCall = this.getSharedScopesValidateBeforeCall(limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ScopeListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSharedScopeCall(String scopeId, ScopeDTO scopeDTO, ApiCallback _callback) throws ApiException {
        ScopeDTO localVarPostBody = scopeDTO;
        String localVarPath = "/scopes/{scopeId}".replaceAll("\\{scopeId\\}", this.localVarApiClient.escapeString(scopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSharedScopeValidateBeforeCall(String scopeId, ScopeDTO scopeDTO, ApiCallback _callback) throws ApiException {
        if (scopeId == null) {
            throw new ApiException("Missing the required parameter 'scopeId' when calling updateSharedScope(Async)");
        }
        if (scopeDTO == null) {
            throw new ApiException("Missing the required parameter 'scopeDTO' when calling updateSharedScope(Async)");
        }
        Call localVarCall = this.updateSharedScopeCall(scopeId, scopeDTO, _callback);
        return localVarCall;
    }

    public ScopeDTO updateSharedScope(String scopeId, ScopeDTO scopeDTO) throws ApiException {
        ApiResponse<ScopeDTO> localVarResp = this.updateSharedScopeWithHttpInfo(scopeId, scopeDTO);
        return localVarResp.getData();
    }

    public ApiResponse<ScopeDTO> updateSharedScopeWithHttpInfo(String scopeId, ScopeDTO scopeDTO) throws ApiException {
        Call localVarCall = this.updateSharedScopeValidateBeforeCall(scopeId, scopeDTO, null);
        Type localVarReturnType = new TypeToken<ScopeDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSharedScopeAsync(String scopeId, ScopeDTO scopeDTO, ApiCallback<ScopeDTO> _callback) throws ApiException {
        Call localVarCall = this.updateSharedScopeValidateBeforeCall(scopeId, scopeDTO, _callback);
        Type localVarReturnType = new TypeToken<ScopeDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call validateScopeCall(String scopeId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scopes/{scopeId}".replaceAll("\\{scopeId\\}", this.localVarApiClient.escapeString(scopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call validateScopeValidateBeforeCall(String scopeId, ApiCallback _callback) throws ApiException {
        if (scopeId == null) {
            throw new ApiException("Missing the required parameter 'scopeId' when calling validateScope(Async)");
        }
        Call localVarCall = this.validateScopeCall(scopeId, _callback);
        return localVarCall;
    }

    public void validateScope(String scopeId) throws ApiException {
        this.validateScopeWithHttpInfo(scopeId);
    }

    public ApiResponse<Void> validateScopeWithHttpInfo(String scopeId) throws ApiException {
        Call localVarCall = this.validateScopeValidateBeforeCall(scopeId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call validateScopeAsync(String scopeId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.validateScopeValidateBeforeCall(scopeId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

