/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CommentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CommentListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.PatchRequestBodyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.PostRequestBodyDTO;

public class CommentsApi {
    private ApiClient localVarApiClient;

    public CommentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CommentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addCommentToAPICall(String apiId, PostRequestBodyDTO postRequestBodyDTO, String replyTo, ApiCallback _callback) throws ApiException {
        PostRequestBodyDTO localVarPostBody = postRequestBodyDTO;
        String localVarPath = "/apis/{apiId}/comments".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (replyTo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("replyTo", replyTo));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addCommentToAPIValidateBeforeCall(String apiId, PostRequestBodyDTO postRequestBodyDTO, String replyTo, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling addCommentToAPI(Async)");
        }
        if (postRequestBodyDTO == null) {
            throw new ApiException("Missing the required parameter 'postRequestBodyDTO' when calling addCommentToAPI(Async)");
        }
        Call localVarCall = this.addCommentToAPICall(apiId, postRequestBodyDTO, replyTo, _callback);
        return localVarCall;
    }

    public CommentDTO addCommentToAPI(String apiId, PostRequestBodyDTO postRequestBodyDTO, String replyTo) throws ApiException {
        ApiResponse<CommentDTO> localVarResp = this.addCommentToAPIWithHttpInfo(apiId, postRequestBodyDTO, replyTo);
        return localVarResp.getData();
    }

    public ApiResponse<CommentDTO> addCommentToAPIWithHttpInfo(String apiId, PostRequestBodyDTO postRequestBodyDTO, String replyTo) throws ApiException {
        Call localVarCall = this.addCommentToAPIValidateBeforeCall(apiId, postRequestBodyDTO, replyTo, null);
        Type localVarReturnType = new TypeToken<CommentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addCommentToAPIAsync(String apiId, PostRequestBodyDTO postRequestBodyDTO, String replyTo, ApiCallback<CommentDTO> _callback) throws ApiException {
        Call localVarCall = this.addCommentToAPIValidateBeforeCall(apiId, postRequestBodyDTO, replyTo, _callback);
        Type localVarReturnType = new TypeToken<CommentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCommentCall(String commentId, String apiId, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/comments/{commentId}".replaceAll("\\{commentId\\}", this.localVarApiClient.escapeString(commentId.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCommentValidateBeforeCall(String commentId, String apiId, String ifMatch, ApiCallback _callback) throws ApiException {
        if (commentId == null) {
            throw new ApiException("Missing the required parameter 'commentId' when calling deleteComment(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling deleteComment(Async)");
        }
        Call localVarCall = this.deleteCommentCall(commentId, apiId, ifMatch, _callback);
        return localVarCall;
    }

    public void deleteComment(String commentId, String apiId, String ifMatch) throws ApiException {
        this.deleteCommentWithHttpInfo(commentId, apiId, ifMatch);
    }

    public ApiResponse<Void> deleteCommentWithHttpInfo(String commentId, String apiId, String ifMatch) throws ApiException {
        Call localVarCall = this.deleteCommentValidateBeforeCall(commentId, apiId, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteCommentAsync(String commentId, String apiId, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCommentValidateBeforeCall(commentId, apiId, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call editCommentOfAPICall(String commentId, String apiId, PatchRequestBodyDTO patchRequestBodyDTO, ApiCallback _callback) throws ApiException {
        PatchRequestBodyDTO localVarPostBody = patchRequestBodyDTO;
        String localVarPath = "/apis/{apiId}/comments/{commentId}".replaceAll("\\{commentId\\}", this.localVarApiClient.escapeString(commentId.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call editCommentOfAPIValidateBeforeCall(String commentId, String apiId, PatchRequestBodyDTO patchRequestBodyDTO, ApiCallback _callback) throws ApiException {
        if (commentId == null) {
            throw new ApiException("Missing the required parameter 'commentId' when calling editCommentOfAPI(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling editCommentOfAPI(Async)");
        }
        if (patchRequestBodyDTO == null) {
            throw new ApiException("Missing the required parameter 'patchRequestBodyDTO' when calling editCommentOfAPI(Async)");
        }
        Call localVarCall = this.editCommentOfAPICall(commentId, apiId, patchRequestBodyDTO, _callback);
        return localVarCall;
    }

    public CommentDTO editCommentOfAPI(String commentId, String apiId, PatchRequestBodyDTO patchRequestBodyDTO) throws ApiException {
        ApiResponse<CommentDTO> localVarResp = this.editCommentOfAPIWithHttpInfo(commentId, apiId, patchRequestBodyDTO);
        return localVarResp.getData();
    }

    public ApiResponse<CommentDTO> editCommentOfAPIWithHttpInfo(String commentId, String apiId, PatchRequestBodyDTO patchRequestBodyDTO) throws ApiException {
        Call localVarCall = this.editCommentOfAPIValidateBeforeCall(commentId, apiId, patchRequestBodyDTO, null);
        Type localVarReturnType = new TypeToken<CommentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call editCommentOfAPIAsync(String commentId, String apiId, PatchRequestBodyDTO patchRequestBodyDTO, ApiCallback<CommentDTO> _callback) throws ApiException {
        Call localVarCall = this.editCommentOfAPIValidateBeforeCall(commentId, apiId, patchRequestBodyDTO, _callback);
        Type localVarReturnType = new TypeToken<CommentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAllCommentsOfAPICall(String apiId, String xWSO2Tenant, Integer limit, Integer offset, Boolean includeCommenterInfo, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/comments".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (includeCommenterInfo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeCommenterInfo", includeCommenterInfo));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllCommentsOfAPIValidateBeforeCall(String apiId, String xWSO2Tenant, Integer limit, Integer offset, Boolean includeCommenterInfo, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAllCommentsOfAPI(Async)");
        }
        Call localVarCall = this.getAllCommentsOfAPICall(apiId, xWSO2Tenant, limit, offset, includeCommenterInfo, _callback);
        return localVarCall;
    }

    public CommentListDTO getAllCommentsOfAPI(String apiId, String xWSO2Tenant, Integer limit, Integer offset, Boolean includeCommenterInfo) throws ApiException {
        ApiResponse<CommentListDTO> localVarResp = this.getAllCommentsOfAPIWithHttpInfo(apiId, xWSO2Tenant, limit, offset, includeCommenterInfo);
        return localVarResp.getData();
    }

    public ApiResponse<CommentListDTO> getAllCommentsOfAPIWithHttpInfo(String apiId, String xWSO2Tenant, Integer limit, Integer offset, Boolean includeCommenterInfo) throws ApiException {
        Call localVarCall = this.getAllCommentsOfAPIValidateBeforeCall(apiId, xWSO2Tenant, limit, offset, includeCommenterInfo, null);
        Type localVarReturnType = new TypeToken<CommentListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllCommentsOfAPIAsync(String apiId, String xWSO2Tenant, Integer limit, Integer offset, Boolean includeCommenterInfo, ApiCallback<CommentListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAllCommentsOfAPIValidateBeforeCall(apiId, xWSO2Tenant, limit, offset, includeCommenterInfo, _callback);
        Type localVarReturnType = new TypeToken<CommentListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCommentOfAPICall(String commentId, String apiId, String xWSO2Tenant, String ifNoneMatch, Boolean includeCommenterInfo, Integer replyLimit, Integer replyOffset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/comments/{commentId}".replaceAll("\\{commentId\\}", this.localVarApiClient.escapeString(commentId.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (includeCommenterInfo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeCommenterInfo", includeCommenterInfo));
        }
        if (replyLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("replyLimit", replyLimit));
        }
        if (replyOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("replyOffset", replyOffset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCommentOfAPIValidateBeforeCall(String commentId, String apiId, String xWSO2Tenant, String ifNoneMatch, Boolean includeCommenterInfo, Integer replyLimit, Integer replyOffset, ApiCallback _callback) throws ApiException {
        if (commentId == null) {
            throw new ApiException("Missing the required parameter 'commentId' when calling getCommentOfAPI(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getCommentOfAPI(Async)");
        }
        Call localVarCall = this.getCommentOfAPICall(commentId, apiId, xWSO2Tenant, ifNoneMatch, includeCommenterInfo, replyLimit, replyOffset, _callback);
        return localVarCall;
    }

    public CommentDTO getCommentOfAPI(String commentId, String apiId, String xWSO2Tenant, String ifNoneMatch, Boolean includeCommenterInfo, Integer replyLimit, Integer replyOffset) throws ApiException {
        ApiResponse<CommentDTO> localVarResp = this.getCommentOfAPIWithHttpInfo(commentId, apiId, xWSO2Tenant, ifNoneMatch, includeCommenterInfo, replyLimit, replyOffset);
        return localVarResp.getData();
    }

    public ApiResponse<CommentDTO> getCommentOfAPIWithHttpInfo(String commentId, String apiId, String xWSO2Tenant, String ifNoneMatch, Boolean includeCommenterInfo, Integer replyLimit, Integer replyOffset) throws ApiException {
        Call localVarCall = this.getCommentOfAPIValidateBeforeCall(commentId, apiId, xWSO2Tenant, ifNoneMatch, includeCommenterInfo, replyLimit, replyOffset, null);
        Type localVarReturnType = new TypeToken<CommentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCommentOfAPIAsync(String commentId, String apiId, String xWSO2Tenant, String ifNoneMatch, Boolean includeCommenterInfo, Integer replyLimit, Integer replyOffset, ApiCallback<CommentDTO> _callback) throws ApiException {
        Call localVarCall = this.getCommentOfAPIValidateBeforeCall(commentId, apiId, xWSO2Tenant, ifNoneMatch, includeCommenterInfo, replyLimit, replyOffset, _callback);
        Type localVarReturnType = new TypeToken<CommentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRepliesOfCommentCall(String commentId, String apiId, String xWSO2Tenant, Integer limit, Integer offset, String ifNoneMatch, Boolean includeCommenterInfo, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/comments/{commentId}/replies".replaceAll("\\{commentId\\}", this.localVarApiClient.escapeString(commentId.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (includeCommenterInfo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeCommenterInfo", includeCommenterInfo));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRepliesOfCommentValidateBeforeCall(String commentId, String apiId, String xWSO2Tenant, Integer limit, Integer offset, String ifNoneMatch, Boolean includeCommenterInfo, ApiCallback _callback) throws ApiException {
        if (commentId == null) {
            throw new ApiException("Missing the required parameter 'commentId' when calling getRepliesOfComment(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getRepliesOfComment(Async)");
        }
        Call localVarCall = this.getRepliesOfCommentCall(commentId, apiId, xWSO2Tenant, limit, offset, ifNoneMatch, includeCommenterInfo, _callback);
        return localVarCall;
    }

    public CommentListDTO getRepliesOfComment(String commentId, String apiId, String xWSO2Tenant, Integer limit, Integer offset, String ifNoneMatch, Boolean includeCommenterInfo) throws ApiException {
        ApiResponse<CommentListDTO> localVarResp = this.getRepliesOfCommentWithHttpInfo(commentId, apiId, xWSO2Tenant, limit, offset, ifNoneMatch, includeCommenterInfo);
        return localVarResp.getData();
    }

    public ApiResponse<CommentListDTO> getRepliesOfCommentWithHttpInfo(String commentId, String apiId, String xWSO2Tenant, Integer limit, Integer offset, String ifNoneMatch, Boolean includeCommenterInfo) throws ApiException {
        Call localVarCall = this.getRepliesOfCommentValidateBeforeCall(commentId, apiId, xWSO2Tenant, limit, offset, ifNoneMatch, includeCommenterInfo, null);
        Type localVarReturnType = new TypeToken<CommentListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRepliesOfCommentAsync(String commentId, String apiId, String xWSO2Tenant, Integer limit, Integer offset, String ifNoneMatch, Boolean includeCommenterInfo, ApiCallback<CommentListDTO> _callback) throws ApiException {
        Call localVarCall = this.getRepliesOfCommentValidateBeforeCall(commentId, apiId, xWSO2Tenant, limit, offset, ifNoneMatch, includeCommenterInfo, _callback);
        Type localVarReturnType = new TypeToken<CommentListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

