/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ApplicationInfoDTO;

public class SubscriptionDTO {
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ID = "subscriptionId";
    @SerializedName(value="subscriptionId")
    private String subscriptionId;
    public static final String SERIALIZED_NAME_APPLICATION_INFO = "applicationInfo";
    @SerializedName(value="applicationInfo")
    private ApplicationInfoDTO applicationInfo;
    public static final String SERIALIZED_NAME_THROTTLING_POLICY = "throttlingPolicy";
    @SerializedName(value="throttlingPolicy")
    private String throttlingPolicy;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_STATUS = "subscriptionStatus";
    @SerializedName(value="subscriptionStatus")
    private SubscriptionStatusEnum subscriptionStatus;

    public SubscriptionDTO subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", required=true, value="")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public SubscriptionDTO applicationInfo(ApplicationInfoDTO applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ApplicationInfoDTO getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfoDTO applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public SubscriptionDTO throttlingPolicy(String throttlingPolicy) {
        this.throttlingPolicy = throttlingPolicy;
        return this;
    }

    @ApiModelProperty(example="Unlimited", required=true, value="")
    public String getThrottlingPolicy() {
        return this.throttlingPolicy;
    }

    public void setThrottlingPolicy(String throttlingPolicy) {
        this.throttlingPolicy = throttlingPolicy;
    }

    public SubscriptionDTO subscriptionStatus(SubscriptionStatusEnum subscriptionStatus) {
        this.subscriptionStatus = subscriptionStatus;
        return this;
    }

    @ApiModelProperty(example="BLOCKED", required=true, value="")
    public SubscriptionStatusEnum getSubscriptionStatus() {
        return this.subscriptionStatus;
    }

    public void setSubscriptionStatus(SubscriptionStatusEnum subscriptionStatus) {
        this.subscriptionStatus = subscriptionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionDTO subscription = (SubscriptionDTO)o;
        return Objects.equals(this.subscriptionId, subscription.subscriptionId) && Objects.equals(this.applicationInfo, subscription.applicationInfo) && Objects.equals(this.throttlingPolicy, subscription.throttlingPolicy) && Objects.equals((Object)this.subscriptionStatus, (Object)subscription.subscriptionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subscriptionId, this.applicationInfo, this.throttlingPolicy, this.subscriptionStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionDTO {\n");
        sb.append("    subscriptionId: ").append(this.toIndentedString(this.subscriptionId)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    throttlingPolicy: ").append(this.toIndentedString(this.throttlingPolicy)).append("\n");
        sb.append("    subscriptionStatus: ").append(this.toIndentedString((Object)this.subscriptionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SubscriptionStatusEnum {
        BLOCKED("BLOCKED"),
        PROD_ONLY_BLOCKED("PROD_ONLY_BLOCKED"),
        UNBLOCKED("UNBLOCKED"),
        ON_HOLD("ON_HOLD"),
        REJECTED("REJECTED"),
        TIER_UPDATE_PENDING("TIER_UPDATE_PENDING");

        private String value;

        private SubscriptionStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SubscriptionStatusEnum fromValue(String value) {
            for (SubscriptionStatusEnum b : SubscriptionStatusEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SubscriptionStatusEnum> {
            public void write(JsonWriter jsonWriter, SubscriptionStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SubscriptionStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SubscriptionStatusEnum.fromValue(value);
            }
        }
    }
}

