/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentListDTO;

public class ApiDocumentsApi {
    private ApiClient localVarApiClient;

    public ApiDocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiDocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addAPIDocumentCall(String apiId, DocumentDTO documentDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        DocumentDTO localVarPostBody = documentDTO;
        String localVarPath = "/apis/{apiId}/documents".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAPIDocumentValidateBeforeCall(String apiId, DocumentDTO documentDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling addAPIDocument(Async)");
        }
        if (documentDTO == null) {
            throw new ApiException("Missing the required parameter 'documentDTO' when calling addAPIDocument(Async)");
        }
        Call localVarCall = this.addAPIDocumentCall(apiId, documentDTO, ifMatch, _callback);
        return localVarCall;
    }

    public DocumentDTO addAPIDocument(String apiId, DocumentDTO documentDTO, String ifMatch) throws ApiException {
        ApiResponse<DocumentDTO> localVarResp = this.addAPIDocumentWithHttpInfo(apiId, documentDTO, ifMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentDTO> addAPIDocumentWithHttpInfo(String apiId, DocumentDTO documentDTO, String ifMatch) throws ApiException {
        Call localVarCall = this.addAPIDocumentValidateBeforeCall(apiId, documentDTO, ifMatch, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addAPIDocumentAsync(String apiId, DocumentDTO documentDTO, String ifMatch, ApiCallback<DocumentDTO> _callback) throws ApiException {
        Call localVarCall = this.addAPIDocumentValidateBeforeCall(apiId, documentDTO, ifMatch, _callback);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call addAPIDocumentContentCall(String apiId, String documentId, String ifMatch, File file, String inlineContent, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}/content".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (inlineContent != null) {
            localVarFormParams.put("inlineContent", inlineContent);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAPIDocumentContentValidateBeforeCall(String apiId, String documentId, String ifMatch, File file, String inlineContent, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling addAPIDocumentContent(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling addAPIDocumentContent(Async)");
        }
        Call localVarCall = this.addAPIDocumentContentCall(apiId, documentId, ifMatch, file, inlineContent, _callback);
        return localVarCall;
    }

    public DocumentDTO addAPIDocumentContent(String apiId, String documentId, String ifMatch, File file, String inlineContent) throws ApiException {
        ApiResponse<DocumentDTO> localVarResp = this.addAPIDocumentContentWithHttpInfo(apiId, documentId, ifMatch, file, inlineContent);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentDTO> addAPIDocumentContentWithHttpInfo(String apiId, String documentId, String ifMatch, File file, String inlineContent) throws ApiException {
        Call localVarCall = this.addAPIDocumentContentValidateBeforeCall(apiId, documentId, ifMatch, file, inlineContent, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addAPIDocumentContentAsync(String apiId, String documentId, String ifMatch, File file, String inlineContent, ApiCallback<DocumentDTO> _callback) throws ApiException {
        Call localVarCall = this.addAPIDocumentContentValidateBeforeCall(apiId, documentId, ifMatch, file, inlineContent, _callback);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAPIDocumentCall(String apiId, String documentId, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAPIDocumentValidateBeforeCall(String apiId, String documentId, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling deleteAPIDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteAPIDocument(Async)");
        }
        Call localVarCall = this.deleteAPIDocumentCall(apiId, documentId, ifMatch, _callback);
        return localVarCall;
    }

    public void deleteAPIDocument(String apiId, String documentId, String ifMatch) throws ApiException {
        this.deleteAPIDocumentWithHttpInfo(apiId, documentId, ifMatch);
    }

    public ApiResponse<Void> deleteAPIDocumentWithHttpInfo(String apiId, String documentId, String ifMatch) throws ApiException {
        Call localVarCall = this.deleteAPIDocumentValidateBeforeCall(apiId, documentId, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAPIDocumentAsync(String apiId, String documentId, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAPIDocumentValidateBeforeCall(apiId, documentId, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIDocumentByDocumentIdCall(String apiId, String documentId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIDocumentByDocumentIdValidateBeforeCall(String apiId, String documentId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIDocumentByDocumentId(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getAPIDocumentByDocumentId(Async)");
        }
        Call localVarCall = this.getAPIDocumentByDocumentIdCall(apiId, documentId, ifNoneMatch, _callback);
        return localVarCall;
    }

    public DocumentDTO getAPIDocumentByDocumentId(String apiId, String documentId, String ifNoneMatch) throws ApiException {
        ApiResponse<DocumentDTO> localVarResp = this.getAPIDocumentByDocumentIdWithHttpInfo(apiId, documentId, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentDTO> getAPIDocumentByDocumentIdWithHttpInfo(String apiId, String documentId, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIDocumentByDocumentIdValidateBeforeCall(apiId, documentId, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIDocumentByDocumentIdAsync(String apiId, String documentId, String ifNoneMatch, ApiCallback<DocumentDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIDocumentByDocumentIdValidateBeforeCall(apiId, documentId, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIDocumentContentByDocumentIdCall(String apiId, String documentId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}/content".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIDocumentContentByDocumentIdValidateBeforeCall(String apiId, String documentId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIDocumentContentByDocumentId(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getAPIDocumentContentByDocumentId(Async)");
        }
        Call localVarCall = this.getAPIDocumentContentByDocumentIdCall(apiId, documentId, ifNoneMatch, _callback);
        return localVarCall;
    }

    public String getAPIDocumentContentByDocumentId(String apiId, String documentId, String ifNoneMatch) throws ApiException {
        ApiResponse<String> localVarResp = this.getAPIDocumentContentByDocumentIdWithHttpInfo(apiId, documentId, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAPIDocumentContentByDocumentIdWithHttpInfo(String apiId, String documentId, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIDocumentContentByDocumentIdValidateBeforeCall(apiId, documentId, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIDocumentContentByDocumentIdAsync(String apiId, String documentId, String ifNoneMatch, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAPIDocumentContentByDocumentIdValidateBeforeCall(apiId, documentId, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIDocumentsCall(String apiId, Integer limit, Integer offset, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIDocumentsValidateBeforeCall(String apiId, Integer limit, Integer offset, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIDocuments(Async)");
        }
        Call localVarCall = this.getAPIDocumentsCall(apiId, limit, offset, ifNoneMatch, _callback);
        return localVarCall;
    }

    public DocumentListDTO getAPIDocuments(String apiId, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        ApiResponse<DocumentListDTO> localVarResp = this.getAPIDocumentsWithHttpInfo(apiId, limit, offset, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentListDTO> getAPIDocumentsWithHttpInfo(String apiId, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIDocumentsValidateBeforeCall(apiId, limit, offset, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DocumentListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIDocumentsAsync(String apiId, Integer limit, Integer offset, String ifNoneMatch, ApiCallback<DocumentListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIDocumentsValidateBeforeCall(apiId, limit, offset, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<DocumentListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAPIDocumentCall(String apiId, String documentId, DocumentDTO documentDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        DocumentDTO localVarPostBody = documentDTO;
        String localVarPath = "/apis/{apiId}/documents/{documentId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAPIDocumentValidateBeforeCall(String apiId, String documentId, DocumentDTO documentDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling updateAPIDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling updateAPIDocument(Async)");
        }
        if (documentDTO == null) {
            throw new ApiException("Missing the required parameter 'documentDTO' when calling updateAPIDocument(Async)");
        }
        Call localVarCall = this.updateAPIDocumentCall(apiId, documentId, documentDTO, ifMatch, _callback);
        return localVarCall;
    }

    public DocumentDTO updateAPIDocument(String apiId, String documentId, DocumentDTO documentDTO, String ifMatch) throws ApiException {
        ApiResponse<DocumentDTO> localVarResp = this.updateAPIDocumentWithHttpInfo(apiId, documentId, documentDTO, ifMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentDTO> updateAPIDocumentWithHttpInfo(String apiId, String documentId, DocumentDTO documentDTO, String ifMatch) throws ApiException {
        Call localVarCall = this.updateAPIDocumentValidateBeforeCall(apiId, documentId, documentDTO, ifMatch, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAPIDocumentAsync(String apiId, String documentId, DocumentDTO documentDTO, String ifMatch, ApiCallback<DocumentDTO> _callback) throws ApiException {
        Call localVarCall = this.updateAPIDocumentValidateBeforeCall(apiId, documentId, documentDTO, ifMatch, _callback);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call validateDocumentCall(String apiId, String name, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/validate".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call validateDocumentValidateBeforeCall(String apiId, String name, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling validateDocument(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling validateDocument(Async)");
        }
        Call localVarCall = this.validateDocumentCall(apiId, name, ifMatch, _callback);
        return localVarCall;
    }

    public void validateDocument(String apiId, String name, String ifMatch) throws ApiException {
        this.validateDocumentWithHttpInfo(apiId, name, ifMatch);
    }

    public ApiResponse<Void> validateDocumentWithHttpInfo(String apiId, String name, String ifMatch) throws ApiException {
        Call localVarCall = this.validateDocumentValidateBeforeCall(apiId, name, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call validateDocumentAsync(String apiId, String name, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.validateDocumentValidateBeforeCall(apiId, name, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

