/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductOutdatedStatusDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.FileInfoDTO;

public class ApiProductsApi {
    private ApiClient localVarApiClient;

    public ApiProductsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiProductsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createAPIProductCall(APIProductDTO apIProductDTO, ApiCallback _callback) throws ApiException {
        APIProductDTO localVarPostBody = apIProductDTO;
        String localVarPath = "/api-products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAPIProductValidateBeforeCall(APIProductDTO apIProductDTO, ApiCallback _callback) throws ApiException {
        if (apIProductDTO == null) {
            throw new ApiException("Missing the required parameter 'apIProductDTO' when calling createAPIProduct(Async)");
        }
        Call localVarCall = this.createAPIProductCall(apIProductDTO, _callback);
        return localVarCall;
    }

    public APIProductDTO createAPIProduct(APIProductDTO apIProductDTO) throws ApiException {
        ApiResponse<APIProductDTO> localVarResp = this.createAPIProductWithHttpInfo(apIProductDTO);
        return localVarResp.getData();
    }

    public ApiResponse<APIProductDTO> createAPIProductWithHttpInfo(APIProductDTO apIProductDTO) throws ApiException {
        Call localVarCall = this.createAPIProductValidateBeforeCall(apIProductDTO, null);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAPIProductAsync(APIProductDTO apIProductDTO, ApiCallback<APIProductDTO> _callback) throws ApiException {
        Call localVarCall = this.createAPIProductValidateBeforeCall(apIProductDTO, _callback);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAPIProductCall(String apiProductId, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAPIProductValidateBeforeCall(String apiProductId, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling deleteAPIProduct(Async)");
        }
        Call localVarCall = this.deleteAPIProductCall(apiProductId, ifMatch, _callback);
        return localVarCall;
    }

    public void deleteAPIProduct(String apiProductId, String ifMatch) throws ApiException {
        this.deleteAPIProductWithHttpInfo(apiProductId, ifMatch);
    }

    public ApiResponse<Void> deleteAPIProductWithHttpInfo(String apiProductId, String ifMatch) throws ApiException {
        Call localVarCall = this.deleteAPIProductValidateBeforeCall(apiProductId, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAPIProductAsync(String apiProductId, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAPIProductValidateBeforeCall(apiProductId, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIProductCall(String apiProductId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIProductValidateBeforeCall(String apiProductId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getAPIProduct(Async)");
        }
        Call localVarCall = this.getAPIProductCall(apiProductId, accept, ifNoneMatch, _callback);
        return localVarCall;
    }

    public APIProductDTO getAPIProduct(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<APIProductDTO> localVarResp = this.getAPIProductWithHttpInfo(apiProductId, accept, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<APIProductDTO> getAPIProductWithHttpInfo(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIProductValidateBeforeCall(apiProductId, accept, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIProductAsync(String apiProductId, String accept, String ifNoneMatch, ApiCallback<APIProductDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIProductValidateBeforeCall(apiProductId, accept, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIProductSwaggerCall(String apiProductId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/swagger".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIProductSwaggerValidateBeforeCall(String apiProductId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getAPIProductSwagger(Async)");
        }
        Call localVarCall = this.getAPIProductSwaggerCall(apiProductId, accept, ifNoneMatch, _callback);
        return localVarCall;
    }

    public void getAPIProductSwagger(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        this.getAPIProductSwaggerWithHttpInfo(apiProductId, accept, ifNoneMatch);
    }

    public ApiResponse<Void> getAPIProductSwaggerWithHttpInfo(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIProductSwaggerValidateBeforeCall(apiProductId, accept, ifNoneMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getAPIProductSwaggerAsync(String apiProductId, String accept, String ifNoneMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getAPIProductSwaggerValidateBeforeCall(apiProductId, accept, ifNoneMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIProductThumbnailCall(String apiProductId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/thumbnail".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIProductThumbnailValidateBeforeCall(String apiProductId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getAPIProductThumbnail(Async)");
        }
        Call localVarCall = this.getAPIProductThumbnailCall(apiProductId, accept, ifNoneMatch, _callback);
        return localVarCall;
    }

    public void getAPIProductThumbnail(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        this.getAPIProductThumbnailWithHttpInfo(apiProductId, accept, ifNoneMatch);
    }

    public ApiResponse<Void> getAPIProductThumbnailWithHttpInfo(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAPIProductThumbnailValidateBeforeCall(apiProductId, accept, ifNoneMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getAPIProductThumbnailAsync(String apiProductId, String accept, String ifNoneMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getAPIProductThumbnailValidateBeforeCall(apiProductId, accept, ifNoneMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllAPIProductsCall(Integer limit, Integer offset, String query, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllAPIProductsValidateBeforeCall(Integer limit, Integer offset, String query, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllAPIProductsCall(limit, offset, query, accept, ifNoneMatch, _callback);
        return localVarCall;
    }

    public APIProductListDTO getAllAPIProducts(Integer limit, Integer offset, String query, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<APIProductListDTO> localVarResp = this.getAllAPIProductsWithHttpInfo(limit, offset, query, accept, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<APIProductListDTO> getAllAPIProductsWithHttpInfo(Integer limit, Integer offset, String query, String accept, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAllAPIProductsValidateBeforeCall(limit, offset, query, accept, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<APIProductListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllAPIProductsAsync(Integer limit, Integer offset, String query, String accept, String ifNoneMatch, ApiCallback<APIProductListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAllAPIProductsValidateBeforeCall(limit, offset, query, accept, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<APIProductListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIsAPIProductOutdatedCall(String apiProductId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/is-outdated".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIsAPIProductOutdatedValidateBeforeCall(String apiProductId, String accept, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling getIsAPIProductOutdated(Async)");
        }
        Call localVarCall = this.getIsAPIProductOutdatedCall(apiProductId, accept, ifNoneMatch, _callback);
        return localVarCall;
    }

    public APIProductOutdatedStatusDTO getIsAPIProductOutdated(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<APIProductOutdatedStatusDTO> localVarResp = this.getIsAPIProductOutdatedWithHttpInfo(apiProductId, accept, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<APIProductOutdatedStatusDTO> getIsAPIProductOutdatedWithHttpInfo(String apiProductId, String accept, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getIsAPIProductOutdatedValidateBeforeCall(apiProductId, accept, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<APIProductOutdatedStatusDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIsAPIProductOutdatedAsync(String apiProductId, String accept, String ifNoneMatch, ApiCallback<APIProductOutdatedStatusDTO> _callback) throws ApiException {
        Call localVarCall = this.getIsAPIProductOutdatedValidateBeforeCall(apiProductId, accept, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<APIProductOutdatedStatusDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAPIProductCall(String apiProductId, APIProductDTO apIProductDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        APIProductDTO localVarPostBody = apIProductDTO;
        String localVarPath = "/api-products/{apiProductId}".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAPIProductValidateBeforeCall(String apiProductId, APIProductDTO apIProductDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling updateAPIProduct(Async)");
        }
        if (apIProductDTO == null) {
            throw new ApiException("Missing the required parameter 'apIProductDTO' when calling updateAPIProduct(Async)");
        }
        Call localVarCall = this.updateAPIProductCall(apiProductId, apIProductDTO, ifMatch, _callback);
        return localVarCall;
    }

    public APIProductDTO updateAPIProduct(String apiProductId, APIProductDTO apIProductDTO, String ifMatch) throws ApiException {
        ApiResponse<APIProductDTO> localVarResp = this.updateAPIProductWithHttpInfo(apiProductId, apIProductDTO, ifMatch);
        return localVarResp.getData();
    }

    public ApiResponse<APIProductDTO> updateAPIProductWithHttpInfo(String apiProductId, APIProductDTO apIProductDTO, String ifMatch) throws ApiException {
        Call localVarCall = this.updateAPIProductValidateBeforeCall(apiProductId, apIProductDTO, ifMatch, null);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAPIProductAsync(String apiProductId, APIProductDTO apIProductDTO, String ifMatch, ApiCallback<APIProductDTO> _callback) throws ApiException {
        Call localVarCall = this.updateAPIProductValidateBeforeCall(apiProductId, apIProductDTO, ifMatch, _callback);
        Type localVarReturnType = new TypeToken<APIProductDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAPIProductThumbnailCall(String apiProductId, File file, String ifMatch, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api-products/{apiProductId}/thumbnail".replaceAll("\\{apiProductId\\}", this.localVarApiClient.escapeString(apiProductId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAPIProductThumbnailValidateBeforeCall(String apiProductId, File file, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiProductId == null) {
            throw new ApiException("Missing the required parameter 'apiProductId' when calling updateAPIProductThumbnail(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling updateAPIProductThumbnail(Async)");
        }
        Call localVarCall = this.updateAPIProductThumbnailCall(apiProductId, file, ifMatch, _callback);
        return localVarCall;
    }

    public FileInfoDTO updateAPIProductThumbnail(String apiProductId, File file, String ifMatch) throws ApiException {
        ApiResponse<FileInfoDTO> localVarResp = this.updateAPIProductThumbnailWithHttpInfo(apiProductId, file, ifMatch);
        return localVarResp.getData();
    }

    public ApiResponse<FileInfoDTO> updateAPIProductThumbnailWithHttpInfo(String apiProductId, File file, String ifMatch) throws ApiException {
        Call localVarCall = this.updateAPIProductThumbnailValidateBeforeCall(apiProductId, file, ifMatch, null);
        Type localVarReturnType = new TypeToken<FileInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAPIProductThumbnailAsync(String apiProductId, File file, String ifMatch, ApiCallback<FileInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.updateAPIProductThumbnailValidateBeforeCall(apiProductId, file, ifMatch, _callback);
        Type localVarReturnType = new TypeToken<FileInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

