/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertMetadataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertificateInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertificatesDTO;

public class EndpointCertificatesApi {
    private ApiClient localVarApiClient;

    public EndpointCertificatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EndpointCertificatesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addEndpointCertificateCall(File certificate, String alias, String endpoint, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if (alias != null) {
            localVarFormParams.put("alias", alias);
        }
        if (endpoint != null) {
            localVarFormParams.put("endpoint", endpoint);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addEndpointCertificateValidateBeforeCall(File certificate, String alias, String endpoint, ApiCallback _callback) throws ApiException {
        if (certificate == null) {
            throw new ApiException("Missing the required parameter 'certificate' when calling addEndpointCertificate(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling addEndpointCertificate(Async)");
        }
        if (endpoint == null) {
            throw new ApiException("Missing the required parameter 'endpoint' when calling addEndpointCertificate(Async)");
        }
        Call localVarCall = this.addEndpointCertificateCall(certificate, alias, endpoint, _callback);
        return localVarCall;
    }

    public CertMetadataDTO addEndpointCertificate(File certificate, String alias, String endpoint) throws ApiException {
        ApiResponse<CertMetadataDTO> localVarResp = this.addEndpointCertificateWithHttpInfo(certificate, alias, endpoint);
        return localVarResp.getData();
    }

    public ApiResponse<CertMetadataDTO> addEndpointCertificateWithHttpInfo(File certificate, String alias, String endpoint) throws ApiException {
        Call localVarCall = this.addEndpointCertificateValidateBeforeCall(certificate, alias, endpoint, null);
        Type localVarReturnType = new TypeToken<CertMetadataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addEndpointCertificateAsync(File certificate, String alias, String endpoint, ApiCallback<CertMetadataDTO> _callback) throws ApiException {
        Call localVarCall = this.addEndpointCertificateValidateBeforeCall(certificate, alias, endpoint, _callback);
        Type localVarReturnType = new TypeToken<CertMetadataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteEndpointCertificateByAliasCall(String alias, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates/{alias}".replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteEndpointCertificateByAliasValidateBeforeCall(String alias, ApiCallback _callback) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling deleteEndpointCertificateByAlias(Async)");
        }
        Call localVarCall = this.deleteEndpointCertificateByAliasCall(alias, _callback);
        return localVarCall;
    }

    public void deleteEndpointCertificateByAlias(String alias) throws ApiException {
        this.deleteEndpointCertificateByAliasWithHttpInfo(alias);
    }

    public ApiResponse<Void> deleteEndpointCertificateByAliasWithHttpInfo(String alias) throws ApiException {
        Call localVarCall = this.deleteEndpointCertificateByAliasValidateBeforeCall(alias, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteEndpointCertificateByAliasAsync(String alias, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteEndpointCertificateByAliasValidateBeforeCall(alias, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getEndpointCertificateByAliasCall(String alias, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates/{alias}".replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEndpointCertificateByAliasValidateBeforeCall(String alias, ApiCallback _callback) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling getEndpointCertificateByAlias(Async)");
        }
        Call localVarCall = this.getEndpointCertificateByAliasCall(alias, _callback);
        return localVarCall;
    }

    public CertificateInfoDTO getEndpointCertificateByAlias(String alias) throws ApiException {
        ApiResponse<CertificateInfoDTO> localVarResp = this.getEndpointCertificateByAliasWithHttpInfo(alias);
        return localVarResp.getData();
    }

    public ApiResponse<CertificateInfoDTO> getEndpointCertificateByAliasWithHttpInfo(String alias) throws ApiException {
        Call localVarCall = this.getEndpointCertificateByAliasValidateBeforeCall(alias, null);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEndpointCertificateByAliasAsync(String alias, ApiCallback<CertificateInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getEndpointCertificateByAliasValidateBeforeCall(alias, _callback);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEndpointCertificateContentByAliasCall(String alias, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates/{alias}/content".replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEndpointCertificateContentByAliasValidateBeforeCall(String alias, ApiCallback _callback) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling getEndpointCertificateContentByAlias(Async)");
        }
        Call localVarCall = this.getEndpointCertificateContentByAliasCall(alias, _callback);
        return localVarCall;
    }

    public void getEndpointCertificateContentByAlias(String alias) throws ApiException {
        this.getEndpointCertificateContentByAliasWithHttpInfo(alias);
    }

    public ApiResponse<Void> getEndpointCertificateContentByAliasWithHttpInfo(String alias) throws ApiException {
        Call localVarCall = this.getEndpointCertificateContentByAliasValidateBeforeCall(alias, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getEndpointCertificateContentByAliasAsync(String alias, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getEndpointCertificateContentByAliasValidateBeforeCall(alias, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getEndpointCertificatesCall(Integer limit, Integer offset, String alias, String endpoint, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (alias != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alias", alias));
        }
        if (endpoint != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endpoint", endpoint));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEndpointCertificatesValidateBeforeCall(Integer limit, Integer offset, String alias, String endpoint, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getEndpointCertificatesCall(limit, offset, alias, endpoint, _callback);
        return localVarCall;
    }

    public CertificatesDTO getEndpointCertificates(Integer limit, Integer offset, String alias, String endpoint) throws ApiException {
        ApiResponse<CertificatesDTO> localVarResp = this.getEndpointCertificatesWithHttpInfo(limit, offset, alias, endpoint);
        return localVarResp.getData();
    }

    public ApiResponse<CertificatesDTO> getEndpointCertificatesWithHttpInfo(Integer limit, Integer offset, String alias, String endpoint) throws ApiException {
        Call localVarCall = this.getEndpointCertificatesValidateBeforeCall(limit, offset, alias, endpoint, null);
        Type localVarReturnType = new TypeToken<CertificatesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEndpointCertificatesAsync(Integer limit, Integer offset, String alias, String endpoint, ApiCallback<CertificatesDTO> _callback) throws ApiException {
        Call localVarCall = this.getEndpointCertificatesValidateBeforeCall(limit, offset, alias, endpoint, _callback);
        Type localVarReturnType = new TypeToken<CertificatesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateEndpointCertificateByAliasCall(String alias, File certificate, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/endpoint-certificates/{alias}".replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateEndpointCertificateByAliasValidateBeforeCall(String alias, File certificate, ApiCallback _callback) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling updateEndpointCertificateByAlias(Async)");
        }
        if (certificate == null) {
            throw new ApiException("Missing the required parameter 'certificate' when calling updateEndpointCertificateByAlias(Async)");
        }
        Call localVarCall = this.updateEndpointCertificateByAliasCall(alias, certificate, _callback);
        return localVarCall;
    }

    public CertMetadataDTO updateEndpointCertificateByAlias(String alias, File certificate) throws ApiException {
        ApiResponse<CertMetadataDTO> localVarResp = this.updateEndpointCertificateByAliasWithHttpInfo(alias, certificate);
        return localVarResp.getData();
    }

    public ApiResponse<CertMetadataDTO> updateEndpointCertificateByAliasWithHttpInfo(String alias, File certificate) throws ApiException {
        Call localVarCall = this.updateEndpointCertificateByAliasValidateBeforeCall(alias, certificate, null);
        Type localVarReturnType = new TypeToken<CertMetadataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateEndpointCertificateByAliasAsync(String alias, File certificate, ApiCallback<CertMetadataDTO> _callback) throws ApiException {
        Call localVarCall = this.updateEndpointCertificateByAliasValidateBeforeCall(alias, certificate, _callback);
        Type localVarReturnType = new TypeToken<CertMetadataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

