/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OperationPolicyDataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OperationPolicyDataListDTO;

public class ApiOperationPoliciesApi {
    private ApiClient localVarApiClient;

    public ApiOperationPoliciesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiOperationPoliciesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addAPISpecificOperationPolicyCall(String apiId, File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/operation-policies".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (policySpecFile != null) {
            localVarFormParams.put("policySpecFile", policySpecFile);
        }
        if (synapsePolicyDefinitionFile != null) {
            localVarFormParams.put("synapsePolicyDefinitionFile", synapsePolicyDefinitionFile);
        }
        if (ccPolicyDefinitionFile != null) {
            localVarFormParams.put("ccPolicyDefinitionFile", ccPolicyDefinitionFile);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAPISpecificOperationPolicyValidateBeforeCall(String apiId, File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling addAPISpecificOperationPolicy(Async)");
        }
        Call localVarCall = this.addAPISpecificOperationPolicyCall(apiId, policySpecFile, synapsePolicyDefinitionFile, ccPolicyDefinitionFile, _callback);
        return localVarCall;
    }

    public OperationPolicyDataDTO addAPISpecificOperationPolicy(String apiId, File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile) throws ApiException {
        ApiResponse<OperationPolicyDataDTO> localVarResp = this.addAPISpecificOperationPolicyWithHttpInfo(apiId, policySpecFile, synapsePolicyDefinitionFile, ccPolicyDefinitionFile);
        return localVarResp.getData();
    }

    public ApiResponse<OperationPolicyDataDTO> addAPISpecificOperationPolicyWithHttpInfo(String apiId, File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile) throws ApiException {
        Call localVarCall = this.addAPISpecificOperationPolicyValidateBeforeCall(apiId, policySpecFile, synapsePolicyDefinitionFile, ccPolicyDefinitionFile, null);
        Type localVarReturnType = new TypeToken<OperationPolicyDataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addAPISpecificOperationPolicyAsync(String apiId, File policySpecFile, File synapsePolicyDefinitionFile, File ccPolicyDefinitionFile, ApiCallback<OperationPolicyDataDTO> _callback) throws ApiException {
        Call localVarCall = this.addAPISpecificOperationPolicyValidateBeforeCall(apiId, policySpecFile, synapsePolicyDefinitionFile, ccPolicyDefinitionFile, _callback);
        Type localVarReturnType = new TypeToken<OperationPolicyDataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAPISpecificOperationPolicyByPolicyIdCall(String apiId, String operationPolicyId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/operation-policies/{operationPolicyId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{operationPolicyId\\}", this.localVarApiClient.escapeString(operationPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAPISpecificOperationPolicyByPolicyIdValidateBeforeCall(String apiId, String operationPolicyId, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling deleteAPISpecificOperationPolicyByPolicyId(Async)");
        }
        if (operationPolicyId == null) {
            throw new ApiException("Missing the required parameter 'operationPolicyId' when calling deleteAPISpecificOperationPolicyByPolicyId(Async)");
        }
        Call localVarCall = this.deleteAPISpecificOperationPolicyByPolicyIdCall(apiId, operationPolicyId, _callback);
        return localVarCall;
    }

    public void deleteAPISpecificOperationPolicyByPolicyId(String apiId, String operationPolicyId) throws ApiException {
        this.deleteAPISpecificOperationPolicyByPolicyIdWithHttpInfo(apiId, operationPolicyId);
    }

    public ApiResponse<Void> deleteAPISpecificOperationPolicyByPolicyIdWithHttpInfo(String apiId, String operationPolicyId) throws ApiException {
        Call localVarCall = this.deleteAPISpecificOperationPolicyByPolicyIdValidateBeforeCall(apiId, operationPolicyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAPISpecificOperationPolicyByPolicyIdAsync(String apiId, String operationPolicyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAPISpecificOperationPolicyByPolicyIdValidateBeforeCall(apiId, operationPolicyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPISpecificOperationPolicyContentByPolicyIdCall(String apiId, String operationPolicyId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/operation-policies/{operationPolicyId}/content".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{operationPolicyId\\}", this.localVarApiClient.escapeString(operationPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/zip", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPISpecificOperationPolicyContentByPolicyIdValidateBeforeCall(String apiId, String operationPolicyId, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPISpecificOperationPolicyContentByPolicyId(Async)");
        }
        if (operationPolicyId == null) {
            throw new ApiException("Missing the required parameter 'operationPolicyId' when calling getAPISpecificOperationPolicyContentByPolicyId(Async)");
        }
        Call localVarCall = this.getAPISpecificOperationPolicyContentByPolicyIdCall(apiId, operationPolicyId, _callback);
        return localVarCall;
    }

    public File getAPISpecificOperationPolicyContentByPolicyId(String apiId, String operationPolicyId) throws ApiException {
        ApiResponse<File> localVarResp = this.getAPISpecificOperationPolicyContentByPolicyIdWithHttpInfo(apiId, operationPolicyId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getAPISpecificOperationPolicyContentByPolicyIdWithHttpInfo(String apiId, String operationPolicyId) throws ApiException {
        Call localVarCall = this.getAPISpecificOperationPolicyContentByPolicyIdValidateBeforeCall(apiId, operationPolicyId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPISpecificOperationPolicyContentByPolicyIdAsync(String apiId, String operationPolicyId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getAPISpecificOperationPolicyContentByPolicyIdValidateBeforeCall(apiId, operationPolicyId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAllAPISpecificOperationPoliciesCall(String apiId, Integer limit, Integer offset, String query, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/operation-policies".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllAPISpecificOperationPoliciesValidateBeforeCall(String apiId, Integer limit, Integer offset, String query, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAllAPISpecificOperationPolicies(Async)");
        }
        Call localVarCall = this.getAllAPISpecificOperationPoliciesCall(apiId, limit, offset, query, _callback);
        return localVarCall;
    }

    public OperationPolicyDataListDTO getAllAPISpecificOperationPolicies(String apiId, Integer limit, Integer offset, String query) throws ApiException {
        ApiResponse<OperationPolicyDataListDTO> localVarResp = this.getAllAPISpecificOperationPoliciesWithHttpInfo(apiId, limit, offset, query);
        return localVarResp.getData();
    }

    public ApiResponse<OperationPolicyDataListDTO> getAllAPISpecificOperationPoliciesWithHttpInfo(String apiId, Integer limit, Integer offset, String query) throws ApiException {
        Call localVarCall = this.getAllAPISpecificOperationPoliciesValidateBeforeCall(apiId, limit, offset, query, null);
        Type localVarReturnType = new TypeToken<OperationPolicyDataListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllAPISpecificOperationPoliciesAsync(String apiId, Integer limit, Integer offset, String query, ApiCallback<OperationPolicyDataListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAllAPISpecificOperationPoliciesValidateBeforeCall(apiId, limit, offset, query, _callback);
        Type localVarReturnType = new TypeToken<OperationPolicyDataListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOperationPolicyForAPIByPolicyIdCall(String apiId, String operationPolicyId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/operation-policies/{operationPolicyId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{operationPolicyId\\}", this.localVarApiClient.escapeString(operationPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOperationPolicyForAPIByPolicyIdValidateBeforeCall(String apiId, String operationPolicyId, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getOperationPolicyForAPIByPolicyId(Async)");
        }
        if (operationPolicyId == null) {
            throw new ApiException("Missing the required parameter 'operationPolicyId' when calling getOperationPolicyForAPIByPolicyId(Async)");
        }
        Call localVarCall = this.getOperationPolicyForAPIByPolicyIdCall(apiId, operationPolicyId, _callback);
        return localVarCall;
    }

    public OperationPolicyDataDTO getOperationPolicyForAPIByPolicyId(String apiId, String operationPolicyId) throws ApiException {
        ApiResponse<OperationPolicyDataDTO> localVarResp = this.getOperationPolicyForAPIByPolicyIdWithHttpInfo(apiId, operationPolicyId);
        return localVarResp.getData();
    }

    public ApiResponse<OperationPolicyDataDTO> getOperationPolicyForAPIByPolicyIdWithHttpInfo(String apiId, String operationPolicyId) throws ApiException {
        Call localVarCall = this.getOperationPolicyForAPIByPolicyIdValidateBeforeCall(apiId, operationPolicyId, null);
        Type localVarReturnType = new TypeToken<OperationPolicyDataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOperationPolicyForAPIByPolicyIdAsync(String apiId, String operationPolicyId, ApiCallback<OperationPolicyDataDTO> _callback) throws ApiException {
        Call localVarCall = this.getOperationPolicyForAPIByPolicyIdValidateBeforeCall(apiId, operationPolicyId, _callback);
        Type localVarReturnType = new TypeToken<OperationPolicyDataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

