/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIExternalStoreListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ExternalStoreDTO;

public class ExternalStoresApi {
    private ApiClient localVarApiClient;

    public ExternalStoresApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExternalStoresApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAllExternalStoresCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/external-stores";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllExternalStoresValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllExternalStoresCall(_callback);
        return localVarCall;
    }

    public ExternalStoreDTO getAllExternalStores() throws ApiException {
        ApiResponse<ExternalStoreDTO> localVarResp = this.getAllExternalStoresWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ExternalStoreDTO> getAllExternalStoresWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAllExternalStoresValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ExternalStoreDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllExternalStoresAsync(ApiCallback<ExternalStoreDTO> _callback) throws ApiException {
        Call localVarCall = this.getAllExternalStoresValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ExternalStoreDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAllPublishedExternalStoresByAPICall(String apiId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/external-stores".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllPublishedExternalStoresByAPIValidateBeforeCall(String apiId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAllPublishedExternalStoresByAPI(Async)");
        }
        Call localVarCall = this.getAllPublishedExternalStoresByAPICall(apiId, ifNoneMatch, _callback);
        return localVarCall;
    }

    public APIExternalStoreListDTO getAllPublishedExternalStoresByAPI(String apiId, String ifNoneMatch) throws ApiException {
        ApiResponse<APIExternalStoreListDTO> localVarResp = this.getAllPublishedExternalStoresByAPIWithHttpInfo(apiId, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<APIExternalStoreListDTO> getAllPublishedExternalStoresByAPIWithHttpInfo(String apiId, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAllPublishedExternalStoresByAPIValidateBeforeCall(apiId, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<APIExternalStoreListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllPublishedExternalStoresByAPIAsync(String apiId, String ifNoneMatch, ApiCallback<APIExternalStoreListDTO> _callback) throws ApiException {
        Call localVarCall = this.getAllPublishedExternalStoresByAPIValidateBeforeCall(apiId, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<APIExternalStoreListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call publishAPIToExternalStoresCall(String apiId, String externalStoreIds, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/publish-to-external-stores".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (externalStoreIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("externalStoreIds", externalStoreIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call publishAPIToExternalStoresValidateBeforeCall(String apiId, String externalStoreIds, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling publishAPIToExternalStores(Async)");
        }
        Call localVarCall = this.publishAPIToExternalStoresCall(apiId, externalStoreIds, ifMatch, _callback);
        return localVarCall;
    }

    public APIExternalStoreListDTO publishAPIToExternalStores(String apiId, String externalStoreIds, String ifMatch) throws ApiException {
        ApiResponse<APIExternalStoreListDTO> localVarResp = this.publishAPIToExternalStoresWithHttpInfo(apiId, externalStoreIds, ifMatch);
        return localVarResp.getData();
    }

    public ApiResponse<APIExternalStoreListDTO> publishAPIToExternalStoresWithHttpInfo(String apiId, String externalStoreIds, String ifMatch) throws ApiException {
        Call localVarCall = this.publishAPIToExternalStoresValidateBeforeCall(apiId, externalStoreIds, ifMatch, null);
        Type localVarReturnType = new TypeToken<APIExternalStoreListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call publishAPIToExternalStoresAsync(String apiId, String externalStoreIds, String ifMatch, ApiCallback<APIExternalStoreListDTO> _callback) throws ApiException {
        Call localVarCall = this.publishAPIToExternalStoresValidateBeforeCall(apiId, externalStoreIds, ifMatch, _callback);
        Type localVarReturnType = new TypeToken<APIExternalStoreListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

