/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.publisher.api.v1;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.publisher.api.ApiCallback;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.Configuration;
import org.wso2.am.integration.clients.publisher.api.Pair;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertificateInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ClientCertMetadataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ClientCertificatesDTO;

public class ClientCertificatesApi {
    private ApiClient localVarApiClient;

    public ClientCertificatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ClientCertificatesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addAPIClientCertificateCall(String apiId, File certificate, String alias, String tier, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if (alias != null) {
            localVarFormParams.put("alias", alias);
        }
        if (tier != null) {
            localVarFormParams.put("tier", tier);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAPIClientCertificateValidateBeforeCall(String apiId, File certificate, String alias, String tier, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling addAPIClientCertificate(Async)");
        }
        if (certificate == null) {
            throw new ApiException("Missing the required parameter 'certificate' when calling addAPIClientCertificate(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling addAPIClientCertificate(Async)");
        }
        if (tier == null) {
            throw new ApiException("Missing the required parameter 'tier' when calling addAPIClientCertificate(Async)");
        }
        Call localVarCall = this.addAPIClientCertificateCall(apiId, certificate, alias, tier, _callback);
        return localVarCall;
    }

    public ClientCertMetadataDTO addAPIClientCertificate(String apiId, File certificate, String alias, String tier) throws ApiException {
        ApiResponse<ClientCertMetadataDTO> localVarResp = this.addAPIClientCertificateWithHttpInfo(apiId, certificate, alias, tier);
        return localVarResp.getData();
    }

    public ApiResponse<ClientCertMetadataDTO> addAPIClientCertificateWithHttpInfo(String apiId, File certificate, String alias, String tier) throws ApiException {
        Call localVarCall = this.addAPIClientCertificateValidateBeforeCall(apiId, certificate, alias, tier, null);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addAPIClientCertificateAsync(String apiId, File certificate, String alias, String tier, ApiCallback<ClientCertMetadataDTO> _callback) throws ApiException {
        Call localVarCall = this.addAPIClientCertificateValidateBeforeCall(apiId, certificate, alias, tier, _callback);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call addAPIClientCertificateOfGivenKeyTypeCall(String keyType, String apiId, File certificate, String alias, String tier, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certs/{keyType}".replaceAll("\\{keyType\\}", this.localVarApiClient.escapeString(keyType.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if (alias != null) {
            localVarFormParams.put("alias", alias);
        }
        if (tier != null) {
            localVarFormParams.put("tier", tier);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAPIClientCertificateOfGivenKeyTypeValidateBeforeCall(String keyType, String apiId, File certificate, String alias, String tier, ApiCallback _callback) throws ApiException {
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling addAPIClientCertificateOfGivenKeyType(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling addAPIClientCertificateOfGivenKeyType(Async)");
        }
        if (certificate == null) {
            throw new ApiException("Missing the required parameter 'certificate' when calling addAPIClientCertificateOfGivenKeyType(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling addAPIClientCertificateOfGivenKeyType(Async)");
        }
        if (tier == null) {
            throw new ApiException("Missing the required parameter 'tier' when calling addAPIClientCertificateOfGivenKeyType(Async)");
        }
        Call localVarCall = this.addAPIClientCertificateOfGivenKeyTypeCall(keyType, apiId, certificate, alias, tier, _callback);
        return localVarCall;
    }

    public ClientCertMetadataDTO addAPIClientCertificateOfGivenKeyType(String keyType, String apiId, File certificate, String alias, String tier) throws ApiException {
        ApiResponse<ClientCertMetadataDTO> localVarResp = this.addAPIClientCertificateOfGivenKeyTypeWithHttpInfo(keyType, apiId, certificate, alias, tier);
        return localVarResp.getData();
    }

    public ApiResponse<ClientCertMetadataDTO> addAPIClientCertificateOfGivenKeyTypeWithHttpInfo(String keyType, String apiId, File certificate, String alias, String tier) throws ApiException {
        Call localVarCall = this.addAPIClientCertificateOfGivenKeyTypeValidateBeforeCall(keyType, apiId, certificate, alias, tier, null);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addAPIClientCertificateOfGivenKeyTypeAsync(String keyType, String apiId, File certificate, String alias, String tier, ApiCallback<ClientCertMetadataDTO> _callback) throws ApiException {
        Call localVarCall = this.addAPIClientCertificateOfGivenKeyTypeValidateBeforeCall(keyType, apiId, certificate, alias, tier, _callback);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAPIClientCertificateByAliasCall(String alias, String apiId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates/{alias}".replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAPIClientCertificateByAliasValidateBeforeCall(String alias, String apiId, ApiCallback _callback) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling deleteAPIClientCertificateByAlias(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling deleteAPIClientCertificateByAlias(Async)");
        }
        Call localVarCall = this.deleteAPIClientCertificateByAliasCall(alias, apiId, _callback);
        return localVarCall;
    }

    public void deleteAPIClientCertificateByAlias(String alias, String apiId) throws ApiException {
        this.deleteAPIClientCertificateByAliasWithHttpInfo(alias, apiId);
    }

    public ApiResponse<Void> deleteAPIClientCertificateByAliasWithHttpInfo(String alias, String apiId) throws ApiException {
        Call localVarCall = this.deleteAPIClientCertificateByAliasValidateBeforeCall(alias, apiId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAPIClientCertificateByAliasAsync(String alias, String apiId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAPIClientCertificateByAliasValidateBeforeCall(alias, apiId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteAPIClientCertificateByKeyTypeAndAliasCall(String keyType, String alias, String apiId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certs/{keyType}/{alias}".replaceAll("\\{keyType\\}", this.localVarApiClient.escapeString(keyType.toString())).replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAPIClientCertificateByKeyTypeAndAliasValidateBeforeCall(String keyType, String alias, String apiId, ApiCallback _callback) throws ApiException {
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling deleteAPIClientCertificateByKeyTypeAndAlias(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling deleteAPIClientCertificateByKeyTypeAndAlias(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling deleteAPIClientCertificateByKeyTypeAndAlias(Async)");
        }
        Call localVarCall = this.deleteAPIClientCertificateByKeyTypeAndAliasCall(keyType, alias, apiId, _callback);
        return localVarCall;
    }

    public void deleteAPIClientCertificateByKeyTypeAndAlias(String keyType, String alias, String apiId) throws ApiException {
        this.deleteAPIClientCertificateByKeyTypeAndAliasWithHttpInfo(keyType, alias, apiId);
    }

    public ApiResponse<Void> deleteAPIClientCertificateByKeyTypeAndAliasWithHttpInfo(String keyType, String alias, String apiId) throws ApiException {
        Call localVarCall = this.deleteAPIClientCertificateByKeyTypeAndAliasValidateBeforeCall(keyType, alias, apiId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAPIClientCertificateByKeyTypeAndAliasAsync(String keyType, String alias, String apiId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAPIClientCertificateByKeyTypeAndAliasValidateBeforeCall(keyType, alias, apiId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIClientCertificateByAliasCall(String alias, String apiId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates/{alias}".replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIClientCertificateByAliasValidateBeforeCall(String alias, String apiId, ApiCallback _callback) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling getAPIClientCertificateByAlias(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIClientCertificateByAlias(Async)");
        }
        Call localVarCall = this.getAPIClientCertificateByAliasCall(alias, apiId, _callback);
        return localVarCall;
    }

    public CertificateInfoDTO getAPIClientCertificateByAlias(String alias, String apiId) throws ApiException {
        ApiResponse<CertificateInfoDTO> localVarResp = this.getAPIClientCertificateByAliasWithHttpInfo(alias, apiId);
        return localVarResp.getData();
    }

    public ApiResponse<CertificateInfoDTO> getAPIClientCertificateByAliasWithHttpInfo(String alias, String apiId) throws ApiException {
        Call localVarCall = this.getAPIClientCertificateByAliasValidateBeforeCall(alias, apiId, null);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIClientCertificateByAliasAsync(String alias, String apiId, ApiCallback<CertificateInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIClientCertificateByAliasValidateBeforeCall(alias, apiId, _callback);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIClientCertificateByKeyTypeAndAliasCall(String keyType, String alias, String apiId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certs/{keyType}/{alias}".replaceAll("\\{keyType\\}", this.localVarApiClient.escapeString(keyType.toString())).replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIClientCertificateByKeyTypeAndAliasValidateBeforeCall(String keyType, String alias, String apiId, ApiCallback _callback) throws ApiException {
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling getAPIClientCertificateByKeyTypeAndAlias(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling getAPIClientCertificateByKeyTypeAndAlias(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIClientCertificateByKeyTypeAndAlias(Async)");
        }
        Call localVarCall = this.getAPIClientCertificateByKeyTypeAndAliasCall(keyType, alias, apiId, _callback);
        return localVarCall;
    }

    public CertificateInfoDTO getAPIClientCertificateByKeyTypeAndAlias(String keyType, String alias, String apiId) throws ApiException {
        ApiResponse<CertificateInfoDTO> localVarResp = this.getAPIClientCertificateByKeyTypeAndAliasWithHttpInfo(keyType, alias, apiId);
        return localVarResp.getData();
    }

    public ApiResponse<CertificateInfoDTO> getAPIClientCertificateByKeyTypeAndAliasWithHttpInfo(String keyType, String alias, String apiId) throws ApiException {
        Call localVarCall = this.getAPIClientCertificateByKeyTypeAndAliasValidateBeforeCall(keyType, alias, apiId, null);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIClientCertificateByKeyTypeAndAliasAsync(String keyType, String alias, String apiId, ApiCallback<CertificateInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIClientCertificateByKeyTypeAndAliasValidateBeforeCall(keyType, alias, apiId, _callback);
        Type localVarReturnType = new TypeToken<CertificateInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIClientCertificateContentByAliasCall(String apiId, String alias, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates/{alias}/content".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIClientCertificateContentByAliasValidateBeforeCall(String apiId, String alias, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIClientCertificateContentByAlias(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling getAPIClientCertificateContentByAlias(Async)");
        }
        Call localVarCall = this.getAPIClientCertificateContentByAliasCall(apiId, alias, _callback);
        return localVarCall;
    }

    public void getAPIClientCertificateContentByAlias(String apiId, String alias) throws ApiException {
        this.getAPIClientCertificateContentByAliasWithHttpInfo(apiId, alias);
    }

    public ApiResponse<Void> getAPIClientCertificateContentByAliasWithHttpInfo(String apiId, String alias) throws ApiException {
        Call localVarCall = this.getAPIClientCertificateContentByAliasValidateBeforeCall(apiId, alias, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getAPIClientCertificateContentByAliasAsync(String apiId, String alias, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getAPIClientCertificateContentByAliasValidateBeforeCall(apiId, alias, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIClientCertificateContentByKeyTypeAndAliasCall(String apiId, String alias, String keyType, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certs/{keyType}/{alias}/content".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString())).replaceAll("\\{keyType\\}", this.localVarApiClient.escapeString(keyType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIClientCertificateContentByKeyTypeAndAliasValidateBeforeCall(String apiId, String alias, String keyType, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIClientCertificateContentByKeyTypeAndAlias(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling getAPIClientCertificateContentByKeyTypeAndAlias(Async)");
        }
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling getAPIClientCertificateContentByKeyTypeAndAlias(Async)");
        }
        Call localVarCall = this.getAPIClientCertificateContentByKeyTypeAndAliasCall(apiId, alias, keyType, _callback);
        return localVarCall;
    }

    public void getAPIClientCertificateContentByKeyTypeAndAlias(String apiId, String alias, String keyType) throws ApiException {
        this.getAPIClientCertificateContentByKeyTypeAndAliasWithHttpInfo(apiId, alias, keyType);
    }

    public ApiResponse<Void> getAPIClientCertificateContentByKeyTypeAndAliasWithHttpInfo(String apiId, String alias, String keyType) throws ApiException {
        Call localVarCall = this.getAPIClientCertificateContentByKeyTypeAndAliasValidateBeforeCall(apiId, alias, keyType, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getAPIClientCertificateContentByKeyTypeAndAliasAsync(String apiId, String alias, String keyType, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getAPIClientCertificateContentByKeyTypeAndAliasValidateBeforeCall(apiId, alias, keyType, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIClientCertificatesCall(String apiId, Integer limit, Integer offset, String alias, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (alias != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alias", alias));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIClientCertificatesValidateBeforeCall(String apiId, Integer limit, Integer offset, String alias, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIClientCertificates(Async)");
        }
        Call localVarCall = this.getAPIClientCertificatesCall(apiId, limit, offset, alias, _callback);
        return localVarCall;
    }

    public ClientCertificatesDTO getAPIClientCertificates(String apiId, Integer limit, Integer offset, String alias) throws ApiException {
        ApiResponse<ClientCertificatesDTO> localVarResp = this.getAPIClientCertificatesWithHttpInfo(apiId, limit, offset, alias);
        return localVarResp.getData();
    }

    public ApiResponse<ClientCertificatesDTO> getAPIClientCertificatesWithHttpInfo(String apiId, Integer limit, Integer offset, String alias) throws ApiException {
        Call localVarCall = this.getAPIClientCertificatesValidateBeforeCall(apiId, limit, offset, alias, null);
        Type localVarReturnType = new TypeToken<ClientCertificatesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIClientCertificatesAsync(String apiId, Integer limit, Integer offset, String alias, ApiCallback<ClientCertificatesDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIClientCertificatesValidateBeforeCall(apiId, limit, offset, alias, _callback);
        Type localVarReturnType = new TypeToken<ClientCertificatesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIClientCertificatesByKeyTypeCall(String keyType, String apiId, Integer limit, Integer offset, String alias, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certs/{keyType}".replaceAll("\\{keyType\\}", this.localVarApiClient.escapeString(keyType.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (alias != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alias", alias));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIClientCertificatesByKeyTypeValidateBeforeCall(String keyType, String apiId, Integer limit, Integer offset, String alias, ApiCallback _callback) throws ApiException {
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling getAPIClientCertificatesByKeyType(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAPIClientCertificatesByKeyType(Async)");
        }
        Call localVarCall = this.getAPIClientCertificatesByKeyTypeCall(keyType, apiId, limit, offset, alias, _callback);
        return localVarCall;
    }

    public ClientCertificatesDTO getAPIClientCertificatesByKeyType(String keyType, String apiId, Integer limit, Integer offset, String alias) throws ApiException {
        ApiResponse<ClientCertificatesDTO> localVarResp = this.getAPIClientCertificatesByKeyTypeWithHttpInfo(keyType, apiId, limit, offset, alias);
        return localVarResp.getData();
    }

    public ApiResponse<ClientCertificatesDTO> getAPIClientCertificatesByKeyTypeWithHttpInfo(String keyType, String apiId, Integer limit, Integer offset, String alias) throws ApiException {
        Call localVarCall = this.getAPIClientCertificatesByKeyTypeValidateBeforeCall(keyType, apiId, limit, offset, alias, null);
        Type localVarReturnType = new TypeToken<ClientCertificatesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIClientCertificatesByKeyTypeAsync(String keyType, String apiId, Integer limit, Integer offset, String alias, ApiCallback<ClientCertificatesDTO> _callback) throws ApiException {
        Call localVarCall = this.getAPIClientCertificatesByKeyTypeValidateBeforeCall(keyType, apiId, limit, offset, alias, _callback);
        Type localVarReturnType = new TypeToken<ClientCertificatesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAPIClientCertificateByAliasCall(String alias, String apiId, File certificate, String tier, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certificates/{alias}".replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if (tier != null) {
            localVarFormParams.put("tier", tier);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAPIClientCertificateByAliasValidateBeforeCall(String alias, String apiId, File certificate, String tier, ApiCallback _callback) throws ApiException {
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling updateAPIClientCertificateByAlias(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling updateAPIClientCertificateByAlias(Async)");
        }
        Call localVarCall = this.updateAPIClientCertificateByAliasCall(alias, apiId, certificate, tier, _callback);
        return localVarCall;
    }

    public ClientCertMetadataDTO updateAPIClientCertificateByAlias(String alias, String apiId, File certificate, String tier) throws ApiException {
        ApiResponse<ClientCertMetadataDTO> localVarResp = this.updateAPIClientCertificateByAliasWithHttpInfo(alias, apiId, certificate, tier);
        return localVarResp.getData();
    }

    public ApiResponse<ClientCertMetadataDTO> updateAPIClientCertificateByAliasWithHttpInfo(String alias, String apiId, File certificate, String tier) throws ApiException {
        Call localVarCall = this.updateAPIClientCertificateByAliasValidateBeforeCall(alias, apiId, certificate, tier, null);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAPIClientCertificateByAliasAsync(String alias, String apiId, File certificate, String tier, ApiCallback<ClientCertMetadataDTO> _callback) throws ApiException {
        Call localVarCall = this.updateAPIClientCertificateByAliasValidateBeforeCall(alias, apiId, certificate, tier, _callback);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAPIClientCertificateByKeyTypeAndAliasCall(String keyType, String alias, String apiId, File certificate, String tier, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/client-certs/{keyType}/{alias}".replaceAll("\\{keyType\\}", this.localVarApiClient.escapeString(keyType.toString())).replaceAll("\\{alias\\}", this.localVarApiClient.escapeString(alias.toString())).replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certificate != null) {
            localVarFormParams.put("certificate", certificate);
        }
        if (tier != null) {
            localVarFormParams.put("tier", tier);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAPIClientCertificateByKeyTypeAndAliasValidateBeforeCall(String keyType, String alias, String apiId, File certificate, String tier, ApiCallback _callback) throws ApiException {
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling updateAPIClientCertificateByKeyTypeAndAlias(Async)");
        }
        if (alias == null) {
            throw new ApiException("Missing the required parameter 'alias' when calling updateAPIClientCertificateByKeyTypeAndAlias(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling updateAPIClientCertificateByKeyTypeAndAlias(Async)");
        }
        Call localVarCall = this.updateAPIClientCertificateByKeyTypeAndAliasCall(keyType, alias, apiId, certificate, tier, _callback);
        return localVarCall;
    }

    public ClientCertMetadataDTO updateAPIClientCertificateByKeyTypeAndAlias(String keyType, String alias, String apiId, File certificate, String tier) throws ApiException {
        ApiResponse<ClientCertMetadataDTO> localVarResp = this.updateAPIClientCertificateByKeyTypeAndAliasWithHttpInfo(keyType, alias, apiId, certificate, tier);
        return localVarResp.getData();
    }

    public ApiResponse<ClientCertMetadataDTO> updateAPIClientCertificateByKeyTypeAndAliasWithHttpInfo(String keyType, String alias, String apiId, File certificate, String tier) throws ApiException {
        Call localVarCall = this.updateAPIClientCertificateByKeyTypeAndAliasValidateBeforeCall(keyType, alias, apiId, certificate, tier, null);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAPIClientCertificateByKeyTypeAndAliasAsync(String keyType, String alias, String apiId, File certificate, String tier, ApiCallback<ClientCertMetadataDTO> _callback) throws ApiException {
        Call localVarCall = this.updateAPIClientCertificateByKeyTypeAndAliasValidateBeforeCall(keyType, alias, apiId, certificate, tier, _callback);
        Type localVarReturnType = new TypeToken<ClientCertMetadataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

