/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.service.catalog.api.v1;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.service.catalog.api.ApiCallback;
import org.wso2.am.integration.clients.service.catalog.api.ApiClient;
import org.wso2.am.integration.clients.service.catalog.api.ApiException;
import org.wso2.am.integration.clients.service.catalog.api.ApiResponse;
import org.wso2.am.integration.clients.service.catalog.api.Configuration;
import org.wso2.am.integration.clients.service.catalog.api.Pair;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceInfoListDTO;
import org.wso2.am.integration.clients.service.catalog.api.v1.dto.ServiceListDTO;

public class ServicesApi {
    private ApiClient localVarApiClient;

    public ServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServicesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addServiceCall(ServiceDTO serviceMetadata, File definitionFile, String inlineContent, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/services";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (serviceMetadata != null) {
            localVarFormParams.put("serviceMetadata", serviceMetadata);
        }
        if (definitionFile != null) {
            localVarFormParams.put("definitionFile", definitionFile);
        }
        if (inlineContent != null) {
            localVarFormParams.put("inlineContent", inlineContent);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addServiceValidateBeforeCall(ServiceDTO serviceMetadata, File definitionFile, String inlineContent, ApiCallback _callback) throws ApiException {
        if (serviceMetadata == null) {
            throw new ApiException("Missing the required parameter 'serviceMetadata' when calling addService(Async)");
        }
        Call localVarCall = this.addServiceCall(serviceMetadata, definitionFile, inlineContent, _callback);
        return localVarCall;
    }

    public ServiceDTO addService(ServiceDTO serviceMetadata, File definitionFile, String inlineContent) throws ApiException {
        ApiResponse<ServiceDTO> localVarResp = this.addServiceWithHttpInfo(serviceMetadata, definitionFile, inlineContent);
        return localVarResp.getData();
    }

    public ApiResponse<ServiceDTO> addServiceWithHttpInfo(ServiceDTO serviceMetadata, File definitionFile, String inlineContent) throws ApiException {
        Call localVarCall = this.addServiceValidateBeforeCall(serviceMetadata, definitionFile, inlineContent, null);
        Type localVarReturnType = new TypeToken<ServiceDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addServiceAsync(ServiceDTO serviceMetadata, File definitionFile, String inlineContent, ApiCallback<ServiceDTO> _callback) throws ApiException {
        Call localVarCall = this.addServiceValidateBeforeCall(serviceMetadata, definitionFile, inlineContent, _callback);
        Type localVarReturnType = new TypeToken<ServiceDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteServiceCall(String serviceId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/services/{serviceId}".replaceAll("\\{serviceId\\}", this.localVarApiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteServiceValidateBeforeCall(String serviceId, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling deleteService(Async)");
        }
        Call localVarCall = this.deleteServiceCall(serviceId, _callback);
        return localVarCall;
    }

    public void deleteService(String serviceId) throws ApiException {
        this.deleteServiceWithHttpInfo(serviceId);
    }

    public ApiResponse<Void> deleteServiceWithHttpInfo(String serviceId) throws ApiException {
        Call localVarCall = this.deleteServiceValidateBeforeCall(serviceId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteServiceAsync(String serviceId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteServiceValidateBeforeCall(serviceId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call exportServiceCall(String name, String version, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/services/export";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/zip", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call exportServiceValidateBeforeCall(String name, String version, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling exportService(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling exportService(Async)");
        }
        Call localVarCall = this.exportServiceCall(name, version, _callback);
        return localVarCall;
    }

    public File exportService(String name, String version) throws ApiException {
        ApiResponse<File> localVarResp = this.exportServiceWithHttpInfo(name, version);
        return localVarResp.getData();
    }

    public ApiResponse<File> exportServiceWithHttpInfo(String name, String version) throws ApiException {
        Call localVarCall = this.exportServiceValidateBeforeCall(name, version, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call exportServiceAsync(String name, String version, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.exportServiceValidateBeforeCall(name, version, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getServiceByIdCall(String serviceId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/services/{serviceId}".replaceAll("\\{serviceId\\}", this.localVarApiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getServiceByIdValidateBeforeCall(String serviceId, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getServiceById(Async)");
        }
        Call localVarCall = this.getServiceByIdCall(serviceId, _callback);
        return localVarCall;
    }

    public ServiceDTO getServiceById(String serviceId) throws ApiException {
        ApiResponse<ServiceDTO> localVarResp = this.getServiceByIdWithHttpInfo(serviceId);
        return localVarResp.getData();
    }

    public ApiResponse<ServiceDTO> getServiceByIdWithHttpInfo(String serviceId) throws ApiException {
        Call localVarCall = this.getServiceByIdValidateBeforeCall(serviceId, null);
        Type localVarReturnType = new TypeToken<ServiceDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getServiceByIdAsync(String serviceId, ApiCallback<ServiceDTO> _callback) throws ApiException {
        Call localVarCall = this.getServiceByIdValidateBeforeCall(serviceId, _callback);
        Type localVarReturnType = new TypeToken<ServiceDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getServiceDefinitionCall(String serviceId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/services/{serviceId}/definition".replaceAll("\\{serviceId\\}", this.localVarApiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getServiceDefinitionValidateBeforeCall(String serviceId, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getServiceDefinition(Async)");
        }
        Call localVarCall = this.getServiceDefinitionCall(serviceId, _callback);
        return localVarCall;
    }

    public String getServiceDefinition(String serviceId) throws ApiException {
        ApiResponse<String> localVarResp = this.getServiceDefinitionWithHttpInfo(serviceId);
        return localVarResp.getData();
    }

    public ApiResponse<String> getServiceDefinitionWithHttpInfo(String serviceId) throws ApiException {
        Call localVarCall = this.getServiceDefinitionValidateBeforeCall(serviceId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getServiceDefinitionAsync(String serviceId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getServiceDefinitionValidateBeforeCall(serviceId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getServiceUsageCall(String serviceId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/services/{serviceId}/usage".replaceAll("\\{serviceId\\}", this.localVarApiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getServiceUsageValidateBeforeCall(String serviceId, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getServiceUsage(Async)");
        }
        Call localVarCall = this.getServiceUsageCall(serviceId, _callback);
        return localVarCall;
    }

    public APIListDTO getServiceUsage(String serviceId) throws ApiException {
        ApiResponse<APIListDTO> localVarResp = this.getServiceUsageWithHttpInfo(serviceId);
        return localVarResp.getData();
    }

    public ApiResponse<APIListDTO> getServiceUsageWithHttpInfo(String serviceId) throws ApiException {
        Call localVarCall = this.getServiceUsageValidateBeforeCall(serviceId, null);
        Type localVarReturnType = new TypeToken<APIListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getServiceUsageAsync(String serviceId, ApiCallback<APIListDTO> _callback) throws ApiException {
        Call localVarCall = this.getServiceUsageValidateBeforeCall(serviceId, _callback);
        Type localVarReturnType = new TypeToken<APIListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call importServiceCall(File file, Boolean overwrite, String verifier, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/services/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (overwrite != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("overwrite", overwrite));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (verifier != null) {
            localVarFormParams.put("verifier", verifier);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importServiceValidateBeforeCall(File file, Boolean overwrite, String verifier, ApiCallback _callback) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling importService(Async)");
        }
        Call localVarCall = this.importServiceCall(file, overwrite, verifier, _callback);
        return localVarCall;
    }

    public ServiceInfoListDTO importService(File file, Boolean overwrite, String verifier) throws ApiException {
        ApiResponse<ServiceInfoListDTO> localVarResp = this.importServiceWithHttpInfo(file, overwrite, verifier);
        return localVarResp.getData();
    }

    public ApiResponse<ServiceInfoListDTO> importServiceWithHttpInfo(File file, Boolean overwrite, String verifier) throws ApiException {
        Call localVarCall = this.importServiceValidateBeforeCall(file, overwrite, verifier, null);
        Type localVarReturnType = new TypeToken<ServiceInfoListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call importServiceAsync(File file, Boolean overwrite, String verifier, ApiCallback<ServiceInfoListDTO> _callback) throws ApiException {
        Call localVarCall = this.importServiceValidateBeforeCall(file, overwrite, verifier, _callback);
        Type localVarReturnType = new TypeToken<ServiceInfoListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call searchServicesCall(String name, String version, String definitionType, String key, Boolean shrink, String sortBy, String sortOrder, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/services";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (definitionType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("definitionType", definitionType));
        }
        if (key != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("key", key));
        }
        if (shrink != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shrink", shrink));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call searchServicesValidateBeforeCall(String name, String version, String definitionType, String key, Boolean shrink, String sortBy, String sortOrder, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.searchServicesCall(name, version, definitionType, key, shrink, sortBy, sortOrder, limit, offset, _callback);
        return localVarCall;
    }

    public ServiceListDTO searchServices(String name, String version, String definitionType, String key, Boolean shrink, String sortBy, String sortOrder, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ServiceListDTO> localVarResp = this.searchServicesWithHttpInfo(name, version, definitionType, key, shrink, sortBy, sortOrder, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ServiceListDTO> searchServicesWithHttpInfo(String name, String version, String definitionType, String key, Boolean shrink, String sortBy, String sortOrder, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.searchServicesValidateBeforeCall(name, version, definitionType, key, shrink, sortBy, sortOrder, limit, offset, null);
        Type localVarReturnType = new TypeToken<ServiceListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call searchServicesAsync(String name, String version, String definitionType, String key, Boolean shrink, String sortBy, String sortOrder, Integer limit, Integer offset, ApiCallback<ServiceListDTO> _callback) throws ApiException {
        Call localVarCall = this.searchServicesValidateBeforeCall(name, version, definitionType, key, shrink, sortBy, sortOrder, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ServiceListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateServiceCall(String serviceId, ServiceDTO serviceMetadata, File definitionFile, String inlineContent, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/services/{serviceId}".replaceAll("\\{serviceId\\}", this.localVarApiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (serviceMetadata != null) {
            localVarFormParams.put("serviceMetadata", serviceMetadata);
        }
        if (definitionFile != null) {
            localVarFormParams.put("definitionFile", definitionFile);
        }
        if (inlineContent != null) {
            localVarFormParams.put("inlineContent", inlineContent);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateServiceValidateBeforeCall(String serviceId, ServiceDTO serviceMetadata, File definitionFile, String inlineContent, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling updateService(Async)");
        }
        if (serviceMetadata == null) {
            throw new ApiException("Missing the required parameter 'serviceMetadata' when calling updateService(Async)");
        }
        Call localVarCall = this.updateServiceCall(serviceId, serviceMetadata, definitionFile, inlineContent, _callback);
        return localVarCall;
    }

    public ServiceDTO updateService(String serviceId, ServiceDTO serviceMetadata, File definitionFile, String inlineContent) throws ApiException {
        ApiResponse<ServiceDTO> localVarResp = this.updateServiceWithHttpInfo(serviceId, serviceMetadata, definitionFile, inlineContent);
        return localVarResp.getData();
    }

    public ApiResponse<ServiceDTO> updateServiceWithHttpInfo(String serviceId, ServiceDTO serviceMetadata, File definitionFile, String inlineContent) throws ApiException {
        Call localVarCall = this.updateServiceValidateBeforeCall(serviceId, serviceMetadata, definitionFile, inlineContent, null);
        Type localVarReturnType = new TypeToken<ServiceDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateServiceAsync(String serviceId, ServiceDTO serviceMetadata, File definitionFile, String inlineContent, ApiCallback<ServiceDTO> _callback) throws ApiException {
        Call localVarCall = this.updateServiceValidateBeforeCall(serviceId, serviceMetadata, definitionFile, inlineContent, _callback);
        Type localVarReturnType = new TypeToken<ServiceDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

