/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.service.catalog.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class ServiceDTO {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_SERVICE_KEY = "serviceKey";
    @SerializedName(value="serviceKey")
    private String serviceKey;
    public static final String SERIALIZED_NAME_SERVICE_URL = "serviceUrl";
    @SerializedName(value="serviceUrl")
    private String serviceUrl;
    public static final String SERIALIZED_NAME_DEFINITION_TYPE = "definitionType";
    @SerializedName(value="definitionType")
    private DefinitionTypeEnum definitionType;
    public static final String SERIALIZED_NAME_SECURITY_TYPE = "securityType";
    @SerializedName(value="securityType")
    private SecurityTypeEnum securityType = SecurityTypeEnum.NONE;
    public static final String SERIALIZED_NAME_MUTUAL_S_S_L_ENABLED = "mutualSSLEnabled";
    @SerializedName(value="mutualSSLEnabled")
    private Boolean mutualSSLEnabled = false;
    public static final String SERIALIZED_NAME_USAGE = "usage";
    @SerializedName(value="usage")
    private Integer usage;
    public static final String SERIALIZED_NAME_CREATED_TIME = "createdTime";
    @SerializedName(value="createdTime")
    private String createdTime;
    public static final String SERIALIZED_NAME_LAST_UPDATED_TIME = "lastUpdatedTime";
    @SerializedName(value="lastUpdatedTime")
    private String lastUpdatedTime;
    public static final String SERIALIZED_NAME_MD5 = "md5";
    @SerializedName(value="md5")
    private String md5;
    public static final String SERIALIZED_NAME_DEFINITION_URL = "definitionUrl";
    @SerializedName(value="definitionUrl")
    private String definitionUrl;

    public ServiceDTO id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Pizzashack-Endpoint", required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceDTO description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A Catalog Entry that exposes a REST endpoint", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceDTO version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="v1", required=true, value="")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceDTO serviceKey(String serviceKey) {
        this.serviceKey = serviceKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Pizzashack-Endpoint-1.0.0", value="")
    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public ServiceDTO serviceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    @ApiModelProperty(example="http://localhost/pizzashack", required=true, value="")
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public ServiceDTO definitionType(DefinitionTypeEnum definitionType) {
        this.definitionType = definitionType;
        return this;
    }

    @ApiModelProperty(example="OAS3", required=true, value="The type of the provided API definition")
    public DefinitionTypeEnum getDefinitionType() {
        return this.definitionType;
    }

    public void setDefinitionType(DefinitionTypeEnum definitionType) {
        this.definitionType = definitionType;
    }

    public ServiceDTO securityType(SecurityTypeEnum securityType) {
        this.securityType = securityType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="BASIC", value="The security type of the endpoint")
    public SecurityTypeEnum getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(SecurityTypeEnum securityType) {
        this.securityType = securityType;
    }

    public ServiceDTO mutualSSLEnabled(Boolean mutualSSLEnabled) {
        this.mutualSSLEnabled = mutualSSLEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether Mutual SSL is enabled for the endpoint")
    public Boolean isMutualSSLEnabled() {
        return this.mutualSSLEnabled;
    }

    public void setMutualSSLEnabled(Boolean mutualSSLEnabled) {
        this.mutualSSLEnabled = mutualSSLEnabled;
    }

    public ServiceDTO usage(Integer usage) {
        this.usage = usage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Number of usages of the service in APIs")
    public Integer getUsage() {
        return this.usage;
    }

    public void setUsage(Integer usage) {
        this.usage = usage;
    }

    public ServiceDTO createdTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-02-20T13:57:16.229", value="")
    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public ServiceDTO lastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-02-20T13:57:16.229", value="")
    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public ServiceDTO md5(String md5) {
        this.md5 = md5;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="36583a6a249b410e7fc4f892029709cac09763ddb230e1a829d5f9134d1abd07", value="")
    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public ServiceDTO definitionUrl(String definitionUrl) {
        this.definitionUrl = definitionUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://petstore.swagger.io/v2/swagger.json", value="")
    public String getDefinitionUrl() {
        return this.definitionUrl;
    }

    public void setDefinitionUrl(String definitionUrl) {
        this.definitionUrl = definitionUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDTO service = (ServiceDTO)o;
        return Objects.equals(this.id, service.id) && Objects.equals(this.name, service.name) && Objects.equals(this.description, service.description) && Objects.equals(this.version, service.version) && Objects.equals(this.serviceKey, service.serviceKey) && Objects.equals(this.serviceUrl, service.serviceUrl) && Objects.equals((Object)this.definitionType, (Object)service.definitionType) && Objects.equals((Object)this.securityType, (Object)service.securityType) && Objects.equals(this.mutualSSLEnabled, service.mutualSSLEnabled) && Objects.equals(this.usage, service.usage) && Objects.equals(this.createdTime, service.createdTime) && Objects.equals(this.lastUpdatedTime, service.lastUpdatedTime) && Objects.equals(this.md5, service.md5) && Objects.equals(this.definitionUrl, service.definitionUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.version, this.serviceKey, this.serviceUrl, this.definitionType, this.securityType, this.mutualSSLEnabled, this.usage, this.createdTime, this.lastUpdatedTime, this.md5, this.definitionUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    serviceKey: ").append(this.toIndentedString(this.serviceKey)).append("\n");
        sb.append("    serviceUrl: ").append(this.toIndentedString(this.serviceUrl)).append("\n");
        sb.append("    definitionType: ").append(this.toIndentedString((Object)this.definitionType)).append("\n");
        sb.append("    securityType: ").append(this.toIndentedString((Object)this.securityType)).append("\n");
        sb.append("    mutualSSLEnabled: ").append(this.toIndentedString(this.mutualSSLEnabled)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    md5: ").append(this.toIndentedString(this.md5)).append("\n");
        sb.append("    definitionUrl: ").append(this.toIndentedString(this.definitionUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SecurityTypeEnum {
        BASIC("BASIC"),
        DIGEST("DIGEST"),
        OAUTH2("OAUTH2"),
        X509("X509"),
        API_KEY("API_KEY"),
        NONE("NONE");

        private String value;

        private SecurityTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SecurityTypeEnum fromValue(String value) {
            for (SecurityTypeEnum b : SecurityTypeEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SecurityTypeEnum> {
            public void write(JsonWriter jsonWriter, SecurityTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SecurityTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SecurityTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DefinitionTypeEnum {
        OAS2("OAS2"),
        OAS3("OAS3"),
        WSDL1("WSDL1"),
        WSDL2("WSDL2"),
        GRAPHQL_SDL("GRAPHQL_SDL"),
        ASYNC_API("ASYNC_API");

        private String value;

        private DefinitionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DefinitionTypeEnum fromValue(String value) {
            for (DefinitionTypeEnum b : DefinitionTypeEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DefinitionTypeEnum> {
            public void write(JsonWriter jsonWriter, DefinitionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DefinitionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DefinitionTypeEnum.fromValue(value);
            }
        }
    }
}

